/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.userfilter;

import java.util.HashMap;
import java.util.Map;
import org.bonitasoft.engine.core.expression.control.model.SExpressionContext;
import org.bonitasoft.engine.core.filter.FilterResult;
import org.bonitasoft.engine.core.filter.UserFilterService;
import org.bonitasoft.engine.core.filter.exception.SUserFilterExecutionException;
import org.bonitasoft.engine.core.filter.exception.SUserFilterLoadingException;
import org.bonitasoft.engine.core.process.definition.model.SUserFilterDefinition;
import org.bonitasoft.engine.expression.EngineConstantExpressionBuilder;
import org.bonitasoft.engine.expression.exception.SInvalidExpressionException;
import org.bonitasoft.engine.expression.model.SExpression;

public class UserFilterServiceDecorator
implements UserFilterService {
    private final UserFilterService userFilterService;

    public UserFilterServiceDecorator(UserFilterService userFilterService) {
        this.userFilterService = userFilterService;
    }

    @Override
    public FilterResult executeFilter(long processDefinitionId, SUserFilterDefinition sUserFilterDefinition, Map<String, SExpression> inputs, ClassLoader classLoader, SExpressionContext expressionContext, String actorName) throws SUserFilterExecutionException {
        SExpression engineExecutionContext;
        SExpression apiAccessorExpression;
        try {
            apiAccessorExpression = EngineConstantExpressionBuilder.getConnectorAPIAccessorExpression();
            engineExecutionContext = EngineConstantExpressionBuilder.getEngineExecutionContext();
        }
        catch (SInvalidExpressionException e) {
            throw new SUserFilterExecutionException(e);
        }
        HashMap<String, SExpression> enrichedInputs = new HashMap<String, SExpression>(inputs);
        enrichedInputs.put("connectorApiAccessor", apiAccessorExpression);
        enrichedInputs.put("engineExecutionContext", engineExecutionContext);
        return this.userFilterService.executeFilter(processDefinitionId, sUserFilterDefinition, enrichedInputs, classLoader, expressionContext, actorName);
    }

    @Override
    public boolean loadUserFilters(long processDefinitionId, long tenantId) throws SUserFilterLoadingException {
        return this.userFilterService.loadUserFilters(processDefinitionId, tenantId);
    }
}

