/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.api.impl.transaction.profile;

import java.util.ArrayList;
import java.util.List;
import org.bonitasoft.engine.bpm.bar.xml.XMLProcessDefinition;
import org.bonitasoft.engine.builder.BuilderFactory;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.commons.transaction.TransactionContentWithResult;
import org.bonitasoft.engine.identity.IdentityService;
import org.bonitasoft.engine.identity.SGroupNotFoundException;
import org.bonitasoft.engine.identity.SRoleNotFoundException;
import org.bonitasoft.engine.identity.SUserNotFoundException;
import org.bonitasoft.engine.identity.model.SGroup;
import org.bonitasoft.engine.identity.model.SRole;
import org.bonitasoft.engine.identity.model.SUser;
import org.bonitasoft.engine.profile.ProfileService;
import org.bonitasoft.engine.profile.builder.SProfileBuilderFactory;
import org.bonitasoft.engine.profile.builder.SProfileEntryBuilderFactory;
import org.bonitasoft.engine.profile.impl.ExportedParentProfileEntry;
import org.bonitasoft.engine.profile.impl.ExportedProfile;
import org.bonitasoft.engine.profile.impl.ExportedProfileEntry;
import org.bonitasoft.engine.profile.impl.ExportedProfileMapping;
import org.bonitasoft.engine.profile.model.SProfile;
import org.bonitasoft.engine.profile.model.SProfileEntry;

public class ImportProfiles
implements TransactionContentWithResult<List<String>> {
    private final ProfileService profileService;
    private final IdentityService identityService;
    private final List<ExportedProfile> exportedProfiles;
    private final long importer;
    private final List<String> warnings = new ArrayList<String>();

    public ImportProfiles(ProfileService profileService, IdentityService identityService, List<ExportedProfile> exportedProfiles, long importer) {
        this.profileService = profileService;
        this.identityService = identityService;
        this.exportedProfiles = exportedProfiles;
        this.importer = importer;
    }

    @Override
    public void execute() throws SBonitaException {
        for (ExportedProfile exportedProfile : this.exportedProfiles) {
            if (exportedProfile.getName() == null || "".equals(exportedProfile.getName())) continue;
            long creationDate = System.currentTimeMillis();
            SProfile sprofile = BuilderFactory.get(SProfileBuilderFactory.class).createNewInstance(exportedProfile.getName(), exportedProfile.isDefault(), creationDate, this.importer, creationDate, this.importer).setDescription(exportedProfile.getDescription()).setIconPath(exportedProfile.getIconPath()).done();
            SProfile newProfile = this.profileService.createProfile(sprofile);
            List<ExportedParentProfileEntry> parentProfileEntries = exportedProfile.getParentProfileEntries();
            for (ExportedParentProfileEntry parentprofileEntry : parentProfileEntries) {
                SProfileEntry sproEntry = BuilderFactory.get(SProfileEntryBuilderFactory.class).createNewInstance(parentprofileEntry.getName(), newProfile.getId()).setDescription(parentprofileEntry.getDescription()).setIndex(parentprofileEntry.getIndex()).setPage(parentprofileEntry.getPage()).setParentId(0L).setType(parentprofileEntry.getType()).done();
                SProfileEntry parentEntry = this.profileService.createProfileEntry(sproEntry);
                List<ExportedProfileEntry> childrenProEn = parentprofileEntry.getChildProfileEntries();
                if (childrenProEn == null || childrenProEn.size() <= 0) continue;
                for (ExportedProfileEntry childProfileEntry : childrenProEn) {
                    SProfileEntry sproEntrytp = BuilderFactory.get(SProfileEntryBuilderFactory.class).createNewInstance(childProfileEntry.getName(), newProfile.getId()).setDescription(childProfileEntry.getDescription()).setIndex(childProfileEntry.getIndex()).setPage(childProfileEntry.getPage()).setParentId(parentEntry.getId()).setType(childProfileEntry.getType()).done();
                    this.profileService.createProfileEntry(sproEntrytp);
                }
            }
            ExportedProfileMapping profileMapp = exportedProfile.getProfileMapping();
            long profileId = newProfile.getId();
            List<String> userNames = profileMapp.getUsers();
            for (String userName : userNames) {
                SUser user = null;
                try {
                    user = this.identityService.getUserByUserName(userName);
                }
                catch (SUserNotFoundException e) {
                    this.warnings.add("User with name " + userName + " not found.");
                    continue;
                }
                this.profileService.addUserToProfile(profileId, user.getId(), user.getFirstName(), user.getLastName(), user.getUserName());
            }
            List<String> roleNames = profileMapp.getRoles();
            for (String roleName : roleNames) {
                SRole role = null;
                try {
                    role = this.identityService.getRoleByName(roleName);
                }
                catch (SRoleNotFoundException e) {
                    this.warnings.add("Role with name " + roleName + " not found.");
                    continue;
                }
                this.profileService.addRoleToProfile(profileId, role.getId(), role.getName());
            }
            List<String> groupPaths = profileMapp.getGroups();
            for (String groupPath : groupPaths) {
                SGroup group = null;
                try {
                    group = this.identityService.getGroupByPath(groupPath);
                }
                catch (SGroupNotFoundException e) {
                    this.warnings.add("Group with path " + groupPath + " not found.");
                    continue;
                }
                this.profileService.addGroupToProfile(profileId, group.getId(), group.getName(), group.getParentPath());
            }
            List<XMLProcessDefinition.BEntry<String, String>> memberships = profileMapp.getMemberships();
            boolean hasGroup = false;
            boolean hasRole = false;
            for (XMLProcessDefinition.BEntry<String, String> membership : memberships) {
                SGroup group = null;
                try {
                    group = this.identityService.getGroupByPath((String)membership.getKey());
                }
                catch (SGroupNotFoundException e) {
                    this.warnings.add("Group with path " + (String)membership.getKey() + " not found in profile memberShip.");
                    hasGroup = true;
                }
                SRole role = null;
                try {
                    role = this.identityService.getRoleByName((String)membership.getValue());
                }
                catch (SRoleNotFoundException e) {
                    this.warnings.add("Role with name " + (String)membership.getValue() + " not found in profile memberShip.");
                    hasRole = true;
                }
                if (hasGroup || hasRole) {
                    hasGroup = false;
                    hasRole = false;
                    continue;
                }
                this.profileService.addRoleAndGroupToProfile(profileId, role.getId(), group.getId(), role.getName(), group.getName(), group.getParentPath());
            }
        }
    }

    @Override
    public List<String> getResult() {
        return this.warnings;
    }
}

