/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.api.impl.transaction.task;

import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.commons.transaction.TransactionContent;
import org.bonitasoft.engine.core.process.comment.api.SCommentService;
import org.bonitasoft.engine.core.process.comment.api.SystemCommentType;
import org.bonitasoft.engine.core.process.definition.model.SFlowNodeType;
import org.bonitasoft.engine.core.process.instance.api.ActivityInstanceService;
import org.bonitasoft.engine.core.process.instance.model.SActivityInstance;
import org.bonitasoft.engine.execution.SUnreleasableTaskException;
import org.bonitasoft.engine.identity.IdentityService;
import org.bonitasoft.engine.identity.model.SUser;

public final class AssignOrUnassignUserTask
implements TransactionContent {
    private final long userId;
    private final long userTaskId;
    private final ActivityInstanceService activityInstanceService;
    private final SCommentService commentService;
    private final IdentityService identityService;

    public AssignOrUnassignUserTask(long userId, long userTaskId, ActivityInstanceService activityInstanceService, SCommentService commentService, IdentityService identityService) {
        this.userId = userId;
        this.userTaskId = userTaskId;
        this.activityInstanceService = activityInstanceService;
        this.commentService = commentService;
        this.identityService = identityService;
    }

    @Override
    public void execute() throws SBonitaException {
        SActivityInstance activityInstance = this.activityInstanceService.getActivityInstance(this.userTaskId);
        if (this.userId == 0L && SFlowNodeType.MANUAL_TASK.equals((Object)activityInstance.getType())) {
            throw new SUnreleasableTaskException("The activity with id " + activityInstance.getId() + " can't be assigned because it is a manual sub task");
        }
        this.activityInstanceService.assignHumanTask(this.userTaskId, this.userId);
        if (this.userId > 0L) {
            this.activityInstanceService.deleteHiddenTasksForActivity(activityInstance.getId());
            SUser user = this.identityService.getUser(this.userId);
            if (this.commentService.isCommentEnabled(SystemCommentType.STATE_CHANGE)) {
                this.commentService.addSystemComment(activityInstance.getRootContainerId(), "The task \"" + activityInstance.getDisplayName() + "\" is now assigned to " + user.getUserName());
            }
        }
    }
}

