/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.core.process.definition.model.bindings;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.bonitasoft.engine.core.process.definition.model.SFlowNodeDefinition;
import org.bonitasoft.engine.core.process.definition.model.bindings.SFlowNodeDefinitionBinding;
import org.bonitasoft.engine.core.process.definition.model.event.impl.SCatchEventDefinitionImpl;
import org.bonitasoft.engine.core.process.definition.model.event.trigger.SCatchMessageEventTriggerDefinition;
import org.bonitasoft.engine.core.process.definition.model.event.trigger.SCatchSignalEventTriggerDefinition;
import org.bonitasoft.engine.core.process.definition.model.event.trigger.STimerEventTriggerDefinition;

public abstract class SCatchEventDefinitionBinding
extends SFlowNodeDefinitionBinding {
    private final List<STimerEventTriggerDefinition> timerEventTriggers = new ArrayList<STimerEventTriggerDefinition>(1);
    private final List<SCatchMessageEventTriggerDefinition> messageEventTriggers = new ArrayList<SCatchMessageEventTriggerDefinition>(1);
    private final List<SCatchSignalEventTriggerDefinition> signalEventTriggers = new ArrayList<SCatchSignalEventTriggerDefinition>(1);
    private boolean isInterrupting;

    @Override
    public void setAttributes(Map<String, String> attributes) {
        super.setAttributes(attributes);
        this.isInterrupting = Boolean.parseBoolean(attributes.get("interrupting"));
    }

    @Override
    public void setChildElement(String name, String value, Map<String, String> attributes) {
        super.setChildElement(name, value, attributes);
    }

    @Override
    public void setChildObject(String name, Object value) {
        super.setChildObject(name, value);
        if ("timerEventTrigger".equals(name)) {
            this.timerEventTriggers.add((STimerEventTriggerDefinition)value);
        }
        if ("catchMessageEventTrigger".equals(name)) {
            this.messageEventTriggers.add((SCatchMessageEventTriggerDefinition)value);
        }
        if ("catchSignalEventTrigger".equals(name)) {
            this.signalEventTriggers.add((SCatchSignalEventTriggerDefinition)value);
        }
    }

    @Override
    protected void fillNode(SFlowNodeDefinition flowNode) {
        super.fillNode(flowNode);
        SCatchEventDefinitionImpl catchEventDefinition = (SCatchEventDefinitionImpl)flowNode;
        for (STimerEventTriggerDefinition timerEventTrigger : this.timerEventTriggers) {
            catchEventDefinition.addTimerEventTrigger(timerEventTrigger);
        }
        for (SCatchMessageEventTriggerDefinition messageEventTrigger : this.messageEventTriggers) {
            catchEventDefinition.addMessageEventTrigger(messageEventTrigger);
        }
        for (SCatchSignalEventTriggerDefinition signalEventTrigger : this.signalEventTriggers) {
            catchEventDefinition.addSignalEventTrigger(signalEventTrigger);
        }
        catchEventDefinition.setInterrupting(this.isInterrupting);
    }
}

