/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.execution;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bonitasoft.engine.actor.mapping.ActorMappingService;
import org.bonitasoft.engine.actor.mapping.SActorNotFoundException;
import org.bonitasoft.engine.actor.mapping.model.SActor;
import org.bonitasoft.engine.bpm.bar.xml.XMLProcessDefinition;
import org.bonitasoft.engine.bpm.connector.ConnectorEvent;
import org.bonitasoft.engine.bpm.connector.ConnectorState;
import org.bonitasoft.engine.bpm.model.impl.BPMInstancesCreator;
import org.bonitasoft.engine.builder.BuilderFactory;
import org.bonitasoft.engine.classloader.ClassLoaderException;
import org.bonitasoft.engine.classloader.ClassLoaderService;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.core.connector.ConnectorInstanceService;
import org.bonitasoft.engine.core.connector.exception.SConnectorInstanceModificationException;
import org.bonitasoft.engine.core.connector.exception.SConnectorInstanceReadException;
import org.bonitasoft.engine.core.expression.control.api.ExpressionResolverService;
import org.bonitasoft.engine.core.expression.control.model.SExpressionContext;
import org.bonitasoft.engine.core.filter.FilterResult;
import org.bonitasoft.engine.core.filter.UserFilterService;
import org.bonitasoft.engine.core.filter.exception.SUserFilterExecutionException;
import org.bonitasoft.engine.core.operation.OperationService;
import org.bonitasoft.engine.core.operation.model.SOperation;
import org.bonitasoft.engine.core.process.comment.api.SCommentAddException;
import org.bonitasoft.engine.core.process.comment.api.SCommentService;
import org.bonitasoft.engine.core.process.comment.api.SystemCommentType;
import org.bonitasoft.engine.core.process.definition.ProcessDefinitionService;
import org.bonitasoft.engine.core.process.definition.exception.SProcessDefinitionReadException;
import org.bonitasoft.engine.core.process.definition.model.SActivityDefinition;
import org.bonitasoft.engine.core.process.definition.model.SCallActivityDefinition;
import org.bonitasoft.engine.core.process.definition.model.SConnectorDefinition;
import org.bonitasoft.engine.core.process.definition.model.SFlowElementContainerDefinition;
import org.bonitasoft.engine.core.process.definition.model.SFlowNodeDefinition;
import org.bonitasoft.engine.core.process.definition.model.SFlowNodeType;
import org.bonitasoft.engine.core.process.definition.model.SHumanTaskDefinition;
import org.bonitasoft.engine.core.process.definition.model.SLoopCharacteristics;
import org.bonitasoft.engine.core.process.definition.model.SMultiInstanceLoopCharacteristics;
import org.bonitasoft.engine.core.process.definition.model.SProcessDefinition;
import org.bonitasoft.engine.core.process.definition.model.SReceiveTaskDefinition;
import org.bonitasoft.engine.core.process.definition.model.SSendTaskDefinition;
import org.bonitasoft.engine.core.process.definition.model.SUserFilterDefinition;
import org.bonitasoft.engine.core.process.definition.model.event.SBoundaryEventDefinition;
import org.bonitasoft.engine.core.process.definition.model.event.SCatchEventDefinition;
import org.bonitasoft.engine.core.process.definition.model.event.SIntermediateCatchEventDefinition;
import org.bonitasoft.engine.core.process.definition.model.event.SThrowEventDefinition;
import org.bonitasoft.engine.core.process.instance.api.ActivityInstanceService;
import org.bonitasoft.engine.core.process.instance.api.event.EventInstanceService;
import org.bonitasoft.engine.core.process.instance.api.exceptions.SActivityCreationException;
import org.bonitasoft.engine.core.process.instance.api.exceptions.SActivityExecutionException;
import org.bonitasoft.engine.core.process.instance.api.exceptions.SActivityModificationException;
import org.bonitasoft.engine.core.process.instance.api.exceptions.SActivityStateExecutionException;
import org.bonitasoft.engine.core.process.instance.api.exceptions.SFlowNodeModificationException;
import org.bonitasoft.engine.core.process.instance.api.exceptions.SFlowNodeNotFoundException;
import org.bonitasoft.engine.core.process.instance.api.exceptions.SFlowNodeReadException;
import org.bonitasoft.engine.core.process.instance.api.exceptions.SProcessInstanceCreationException;
import org.bonitasoft.engine.core.process.instance.api.exceptions.event.trigger.SWaitingEventModificationException;
import org.bonitasoft.engine.core.process.instance.model.SActivityInstance;
import org.bonitasoft.engine.core.process.instance.model.SCallActivityInstance;
import org.bonitasoft.engine.core.process.instance.model.SConnectorInstance;
import org.bonitasoft.engine.core.process.instance.model.SFlowElementsContainerType;
import org.bonitasoft.engine.core.process.instance.model.SFlowNodeInstance;
import org.bonitasoft.engine.core.process.instance.model.SPendingActivityMapping;
import org.bonitasoft.engine.core.process.instance.model.SReceiveTaskInstance;
import org.bonitasoft.engine.core.process.instance.model.SSendTaskInstance;
import org.bonitasoft.engine.core.process.instance.model.SStateCategory;
import org.bonitasoft.engine.core.process.instance.model.archive.builder.SAAutomaticTaskInstanceBuilderFactory;
import org.bonitasoft.engine.core.process.instance.model.builder.SPendingActivityMappingBuilderFactory;
import org.bonitasoft.engine.core.process.instance.model.builder.SUserTaskInstanceBuilderFactory;
import org.bonitasoft.engine.core.process.instance.model.builder.event.SBoundaryEventInstanceBuilderFactory;
import org.bonitasoft.engine.core.process.instance.model.builder.event.handling.SWaitingEventKeyProviderBuilderFactory;
import org.bonitasoft.engine.core.process.instance.model.event.SBoundaryEventInstance;
import org.bonitasoft.engine.core.process.instance.model.event.SCatchEventInstance;
import org.bonitasoft.engine.core.process.instance.model.event.SIntermediateCatchEventInstance;
import org.bonitasoft.engine.core.process.instance.model.event.SThrowEventInstance;
import org.bonitasoft.engine.core.process.instance.model.event.handling.SWaitingEvent;
import org.bonitasoft.engine.data.instance.api.DataInstanceContainer;
import org.bonitasoft.engine.data.instance.api.DataInstanceService;
import org.bonitasoft.engine.data.instance.model.SDataInstance;
import org.bonitasoft.engine.execution.ContainerRegistry;
import org.bonitasoft.engine.execution.ProcessExecutor;
import org.bonitasoft.engine.execution.event.EventsHandler;
import org.bonitasoft.engine.execution.event.OperationsWithContext;
import org.bonitasoft.engine.execution.job.JobNameBuilder;
import org.bonitasoft.engine.execution.state.EndingIntermediateCatchEventExceptionStateImpl;
import org.bonitasoft.engine.execution.work.WorkFactory;
import org.bonitasoft.engine.expression.exception.SExpressionDependencyMissingException;
import org.bonitasoft.engine.expression.exception.SExpressionEvaluationException;
import org.bonitasoft.engine.expression.exception.SExpressionTypeUnknownException;
import org.bonitasoft.engine.expression.exception.SInvalidExpressionException;
import org.bonitasoft.engine.expression.model.SExpression;
import org.bonitasoft.engine.identity.IdentityService;
import org.bonitasoft.engine.identity.SUserNotFoundException;
import org.bonitasoft.engine.identity.model.SUser;
import org.bonitasoft.engine.log.technical.TechnicalLogSeverity;
import org.bonitasoft.engine.log.technical.TechnicalLoggerService;
import org.bonitasoft.engine.persistence.FilterOption;
import org.bonitasoft.engine.persistence.OrderByOption;
import org.bonitasoft.engine.persistence.OrderByType;
import org.bonitasoft.engine.persistence.QueryOptions;
import org.bonitasoft.engine.persistence.SBonitaSearchException;
import org.bonitasoft.engine.recorder.model.EntityUpdateDescriptor;
import org.bonitasoft.engine.scheduler.SchedulerService;
import org.bonitasoft.engine.scheduler.exception.SSchedulerException;
import org.bonitasoft.engine.work.WorkRegisterException;
import org.bonitasoft.engine.work.WorkService;

public class StateBehaviors {
    public static final int BEFORE_ON_ENTER = 1;
    public static final int DURING_ON_ENTER = 2;
    public static final int BEFORE_ON_FINISH = 4;
    public static final int DURING_ON_FINISH = 8;
    public static final int AFTER_ON_FINISH = 16;
    private static final int BATCH_SIZE = 20;
    private static final int MAX_NUMBER_OF_RESULTS = 100;
    private final BPMInstancesCreator bpmInstancesCreator;
    private final EventsHandler eventsHandler;
    private final ActivityInstanceService activityInstanceService;
    private final UserFilterService userFilterService;
    private final ClassLoaderService classLoaderService;
    private final ActorMappingService actorMappingService;
    private final ExpressionResolverService expressionResolverService;
    private final ProcessDefinitionService processDefinitionService;
    private final DataInstanceService dataInstanceService;
    private final OperationService operationService;
    private final WorkService workService;
    private final ContainerRegistry containerRegistry;
    private final EventInstanceService eventInstanceService;
    private final SchedulerService schedulerService;
    private final TechnicalLoggerService logger;
    private final ConnectorInstanceService connectorInstanceService;
    private ProcessExecutor processExecutor;
    private final SCommentService commentService;
    private final IdentityService identityService;

    public StateBehaviors(BPMInstancesCreator bpmInstancesCreator, EventsHandler eventsHandler, ActivityInstanceService activityInstanceService, UserFilterService userFilterService, ClassLoaderService classLoaderService, ActorMappingService actorMappingService, ConnectorInstanceService connectorInstanceService, ExpressionResolverService expressionResolverService, ProcessDefinitionService processDefinitionService, DataInstanceService dataInstanceService, OperationService operationService, WorkService workService, ContainerRegistry containerRegistry, EventInstanceService eventInstanceSevice, SchedulerService schedulerService, SCommentService commentService, IdentityService identityService, TechnicalLoggerService logger) {
        this.bpmInstancesCreator = bpmInstancesCreator;
        this.eventsHandler = eventsHandler;
        this.activityInstanceService = activityInstanceService;
        this.userFilterService = userFilterService;
        this.classLoaderService = classLoaderService;
        this.actorMappingService = actorMappingService;
        this.connectorInstanceService = connectorInstanceService;
        this.expressionResolverService = expressionResolverService;
        this.processDefinitionService = processDefinitionService;
        this.dataInstanceService = dataInstanceService;
        this.operationService = operationService;
        this.workService = workService;
        this.containerRegistry = containerRegistry;
        this.eventInstanceService = eventInstanceSevice;
        this.schedulerService = schedulerService;
        this.commentService = commentService;
        this.identityService = identityService;
        this.logger = logger;
    }

    public void setProcessExecutor(ProcessExecutor processExecutor) {
        this.processExecutor = processExecutor;
    }

    public DataInstanceContainer getParentContainerType(SFlowNodeInstance flowNodeInstance) {
        DataInstanceContainer parentContainerType = flowNodeInstance.getLogicalGroup(2) <= 0L ? DataInstanceContainer.PROCESS_INSTANCE : DataInstanceContainer.ACTIVITY_INSTANCE;
        return parentContainerType;
    }

    public void mapDataOutputOfMultiInstance(SProcessDefinition processDefinition, SFlowNodeInstance flowNodeInstance) throws SActivityStateExecutionException {
        SFlowElementContainerDefinition processContainer;
        SActivityDefinition activityDefinition;
        if (flowNodeInstance instanceof SActivityInstance && !SFlowNodeType.MULTI_INSTANCE_ACTIVITY.equals((Object)flowNodeInstance.getType()) && (activityDefinition = (SActivityDefinition)(processContainer = processDefinition.getProcessContainer()).getFlowNode(flowNodeInstance.getFlowNodeDefinitionId())) != null) {
            try {
                SLoopCharacteristics loopCharacteristics = activityDefinition.getLoopCharacteristics();
                if (loopCharacteristics instanceof SMultiInstanceLoopCharacteristics && ((SMultiInstanceLoopCharacteristics)loopCharacteristics).getDataOutputItemRef() != null) {
                    SMultiInstanceLoopCharacteristics miLoop = (SMultiInstanceLoopCharacteristics)loopCharacteristics;
                    SDataInstance outputData = this.dataInstanceService.getDataInstance(miLoop.getDataOutputItemRef(), flowNodeInstance.getId(), DataInstanceContainer.ACTIVITY_INSTANCE.name());
                    SDataInstance loopData = this.dataInstanceService.getDataInstance(miLoop.getLoopDataOutputRef(), flowNodeInstance.getId(), DataInstanceContainer.ACTIVITY_INSTANCE.name());
                    if (outputData != null && loopData != null) {
                        Serializable value = loopData.getValue();
                        int index = flowNodeInstance.getLoopCounter();
                        if (!(value instanceof List)) {
                            throw new SActivityExecutionException("unable to map the ouput of the multi instanciated activity " + flowNodeInstance.getName() + " the output loop data named " + loopData.getName() + " is not a list but " + loopData.getClassName());
                        }
                        List list = (List)((Object)value);
                        list.set(index, outputData.getValue());
                        EntityUpdateDescriptor entityUpdateDescriptor = new EntityUpdateDescriptor();
                        entityUpdateDescriptor.addField("value", value);
                        this.dataInstanceService.updateDataInstance(loopData, entityUpdateDescriptor);
                    }
                }
            }
            catch (SBonitaException e) {
                throw new SActivityStateExecutionException(e);
            }
        }
    }

    public void mapActors(SFlowNodeInstance flowNodeInstance, SFlowElementContainerDefinition processContainer) throws SActivityStateExecutionException {
        if (SFlowNodeType.USER_TASK.equals((Object)flowNodeInstance.getType()) || SFlowNodeType.MANUAL_TASK.equals((Object)flowNodeInstance.getType())) {
            try {
                SHumanTaskDefinition humanTaskDefinition = (SHumanTaskDefinition)processContainer.getFlowNode(flowNodeInstance.getFlowNodeDefinitionId());
                if (humanTaskDefinition != null) {
                    String actorName = humanTaskDefinition.getActorName();
                    long processDefinitionId = flowNodeInstance.getLogicalGroup(0);
                    SUserFilterDefinition sUserFilterDefinition = humanTaskDefinition.getSUserFilterDefinition();
                    if (sUserFilterDefinition != null) {
                        this.mapUsingUserFilters(flowNodeInstance, humanTaskDefinition, actorName, processDefinitionId, sUserFilterDefinition);
                    } else {
                        this.mapUsingActors(flowNodeInstance, actorName, processDefinitionId);
                    }
                }
            }
            catch (SActivityStateExecutionException e) {
                throw e;
            }
            catch (Exception e) {
                throw new SActivityStateExecutionException(e);
            }
        }
    }

    private void mapUsingActors(SFlowNodeInstance flowNodeInstance, String actorName, long processDefinitionId) throws SActorNotFoundException, SActivityCreationException {
        SActor actor = this.actorMappingService.getActor(actorName, processDefinitionId);
        SPendingActivityMapping mapping = BuilderFactory.get(SPendingActivityMappingBuilderFactory.class).createNewInstanceForActor(flowNodeInstance.getId(), actor.getId()).done();
        this.activityInstanceService.addPendingActivityMappings(mapping);
    }

    private void mapUsingUserFilters(SFlowNodeInstance flowNodeInstance, SHumanTaskDefinition humanTaskDefinition, String actorName, long processDefinitionId, SUserFilterDefinition sUserFilterDefinition) throws ClassLoaderException, SUserFilterExecutionException, SActivityStateExecutionException, SActivityCreationException, SFlowNodeNotFoundException, SFlowNodeReadException, SActivityModificationException, SCommentAddException, SUserNotFoundException {
        ClassLoader processClassloader = this.classLoaderService.getLocalClassLoader("process", processDefinitionId);
        SExpressionContext expressionContext = new SExpressionContext((Long)flowNodeInstance.getId(), DataInstanceContainer.ACTIVITY_INSTANCE.name(), flowNodeInstance.getLogicalGroup(0));
        FilterResult result = this.userFilterService.executeFilter(processDefinitionId, sUserFilterDefinition, sUserFilterDefinition.getInputs(), processClassloader, expressionContext, actorName);
        List<Long> userIds = result.getResult();
        if (userIds == null || userIds.isEmpty() || userIds.contains(0L) || userIds.contains(-1L)) {
            throw new SActivityStateExecutionException("no user id returned by the user filter " + sUserFilterDefinition + " on activity " + humanTaskDefinition.getName());
        }
        for (Long userId : userIds) {
            SPendingActivityMapping mapping = BuilderFactory.get(SPendingActivityMappingBuilderFactory.class).createNewInstanceForUser(flowNodeInstance.getId(), userId).done();
            this.activityInstanceService.addPendingActivityMappings(mapping);
        }
        if (userIds.size() == 1 && result.shouldAutoAssignTaskIfSingleResult()) {
            Long userId = userIds.get(0);
            this.activityInstanceService.assignHumanTask(flowNodeInstance.getId(), userId);
            SUser user = this.identityService.getUser(userId);
            if (this.commentService.isCommentEnabled(SystemCommentType.STATE_CHANGE)) {
                this.commentService.addSystemComment(flowNodeInstance.getRootContainerId(), "The task \"" + flowNodeInstance.getName() + "\" is now assigned to " + user.getUserName());
            }
        }
    }

    public void handleCatchEvents(SProcessDefinition processDefinition, SFlowNodeInstance flowNodeInstance) throws SActivityStateExecutionException {
        if (flowNodeInstance instanceof SIntermediateCatchEventInstance) {
            SCatchEventInstance intermediateCatchEventInstance = (SCatchEventInstance)flowNodeInstance;
            SFlowElementContainerDefinition processContainer = processDefinition.getProcessContainer();
            SIntermediateCatchEventDefinition intermediateCatchEventDefinition = (SIntermediateCatchEventDefinition)processContainer.getFlowNode(intermediateCatchEventInstance.getFlowNodeDefinitionId());
            try {
                this.eventsHandler.handleCatchEvent(processDefinition, intermediateCatchEventDefinition, intermediateCatchEventInstance);
            }
            catch (SBonitaException e) {
                throw new SActivityStateExecutionException("unable to handle catch event " + flowNodeInstance, e);
            }
        }
        if (flowNodeInstance instanceof SReceiveTaskInstance) {
            SReceiveTaskInstance receiveTaskInstance = (SReceiveTaskInstance)flowNodeInstance;
            SFlowElementContainerDefinition processContainer = processDefinition.getProcessContainer();
            SReceiveTaskDefinition receiveTaskIDefinition = (SReceiveTaskDefinition)processContainer.getFlowNode(receiveTaskInstance.getFlowNodeDefinitionId());
            try {
                this.eventsHandler.handleCatchMessage(processDefinition, receiveTaskIDefinition, receiveTaskInstance);
            }
            catch (SBonitaException e) {
                throw new SActivityStateExecutionException("unable to handle catch event " + flowNodeInstance, e);
            }
        }
    }

    public void handleBoundaryEvent(SProcessDefinition processDefinition, SBoundaryEventInstance boundaryInstance) throws SActivityStateExecutionException {
        long activityInstanceId = boundaryInstance.getActivityInstanceId();
        try {
            SActivityInstance activityInstance = this.activityInstanceService.getActivityInstance(activityInstanceId);
            SActivityDefinition activityDefinition = (SActivityDefinition)processDefinition.getProcessContainer().getFlowNode(activityInstance.getFlowNodeDefinitionId());
            SBoundaryEventDefinition boundaryEventDefinition = activityDefinition.getBoundaryEventDefinition(boundaryInstance.getName());
            this.eventsHandler.handleCatchEvent(processDefinition, boundaryEventDefinition, boundaryInstance);
        }
        catch (SBonitaException e) {
            throw new SActivityStateExecutionException("unable to handle catch event " + boundaryInstance, e);
        }
    }

    public XMLProcessDefinition.BEntry<Integer, XMLProcessDefinition.BEntry<SConnectorInstance, SConnectorDefinition>> getConnectorToExecuteAndFlag(SProcessDefinition processDefinition, SFlowNodeInstance flowNodeInstance, boolean executeConnectorsOnEnter, boolean executeConnectorsOnFinish) throws SActivityStateExecutionException {
        try {
            SFlowElementContainerDefinition processContainer = processDefinition.getProcessContainer();
            SFlowNodeDefinition flowNodeDefinition = processContainer.getFlowNode(flowNodeInstance.getFlowNodeDefinitionId());
            if (flowNodeDefinition != null) {
                List<SConnectorDefinition> connectorsOnFinish;
                boolean onEnterExecuted = false;
                List<SConnectorDefinition> connectorsOnEnter = flowNodeDefinition.getConnectors(ConnectorEvent.ON_ENTER);
                if (connectorsOnEnter.size() > 0 && executeConnectorsOnEnter) {
                    SConnectorInstance nextConnectorInstanceToExecute = this.getNextConnectorInstance(flowNodeInstance, ConnectorEvent.ON_ENTER);
                    if (nextConnectorInstanceToExecute != null) {
                        if (nextConnectorInstanceToExecute.getState().equals(ConnectorState.TO_BE_EXECUTED.name()) && connectorsOnEnter.get(0).getName().equals(nextConnectorInstanceToExecute.getName())) {
                            return this.getConnectorWithFlag(nextConnectorInstanceToExecute, connectorsOnEnter.get(0), 3);
                        }
                        for (SConnectorDefinition sConnectorDefinition : connectorsOnEnter) {
                            if (!sConnectorDefinition.getName().equals(nextConnectorInstanceToExecute.getName())) continue;
                            return this.getConnectorWithFlag(nextConnectorInstanceToExecute, sConnectorDefinition, 2);
                        }
                        throw new SActivityStateExecutionException("Connector definition of " + nextConnectorInstanceToExecute + " not found on " + flowNodeInstance);
                    }
                    onEnterExecuted = true;
                }
                if ((connectorsOnFinish = flowNodeDefinition.getConnectors(ConnectorEvent.ON_FINISH)).size() > 0 && executeConnectorsOnFinish) {
                    SConnectorInstance nextConnectorInstanceToExecute = this.getNextConnectorInstance(flowNodeInstance, ConnectorEvent.ON_FINISH);
                    if (nextConnectorInstanceToExecute != null) {
                        if (nextConnectorInstanceToExecute.getState().equals(ConnectorState.TO_BE_EXECUTED.name()) && connectorsOnFinish.get(0).getName().equals(nextConnectorInstanceToExecute.getName())) {
                            SConnectorDefinition connectorDefinition = connectorsOnFinish.get(0);
                            if (onEnterExecuted) {
                                return this.getConnectorWithFlag(nextConnectorInstanceToExecute, connectorDefinition, 12);
                            }
                            return this.getConnectorWithFlag(nextConnectorInstanceToExecute, connectorDefinition, 13);
                        }
                        for (SConnectorDefinition sConnectorDefinition : connectorsOnFinish) {
                            if (!sConnectorDefinition.getName().equals(nextConnectorInstanceToExecute.getName())) continue;
                            return this.getConnectorWithFlag(nextConnectorInstanceToExecute, sConnectorDefinition, 8);
                        }
                        throw new SActivityStateExecutionException("Connector definition of " + nextConnectorInstanceToExecute + " not found on " + flowNodeInstance);
                    }
                    return this.getConnectorWithFlag(null, null, 16);
                }
                if (flowNodeInstance.isStateExecuting()) {
                    return this.getConnectorWithFlag(null, null, 20);
                }
            }
            return this.getConnectorWithFlag(null, null, 21);
        }
        catch (SConnectorInstanceReadException e) {
            throw new SActivityStateExecutionException(e);
        }
    }

    private XMLProcessDefinition.BEntry<Integer, XMLProcessDefinition.BEntry<SConnectorInstance, SConnectorDefinition>> getConnectorWithFlag(SConnectorInstance nextConnectorInstance, SConnectorDefinition connectorDefinition, int flag) {
        return new XMLProcessDefinition.BEntry((Object)flag, (Object)new XMLProcessDefinition.BEntry((Object)nextConnectorInstance, (Object)connectorDefinition));
    }

    private SConnectorInstance getNextConnectorInstance(SFlowNodeInstance flowNodeInstance, ConnectorEvent event) throws SConnectorInstanceReadException {
        SConnectorInstance connectorInstance = this.connectorInstanceService.getNextExecutableConnectorInstance(flowNodeInstance.getId(), "flowNode", event);
        return connectorInstance;
    }

    public void createData(SProcessDefinition processDefinition, SFlowNodeInstance flowNodeInstance) throws SActivityStateExecutionException {
        SFlowNodeDefinition flowNodeDefinition;
        boolean childHaveData = false;
        if (flowNodeInstance instanceof SActivityInstance) {
            String containerType = this.getParentContainerType(flowNodeInstance).name();
            SExpressionContext sExpressionContext = new SExpressionContext((Long)flowNodeInstance.getParentContainerId(), containerType, processDefinition.getId());
            childHaveData = this.bpmInstancesCreator.createDataInstances(processDefinition, flowNodeInstance, sExpressionContext);
        }
        if (this.hasLocalOrInheritedData(processDefinition, childHaveData, flowNodeDefinition = processDefinition.getProcessContainer().getFlowNode(flowNodeInstance.getFlowNodeDefinitionId()))) {
            this.bpmInstancesCreator.addChildDataContainer(flowNodeInstance);
        }
    }

    private boolean hasLocalOrInheritedData(SProcessDefinition processDefinition, boolean childHaveData, SFlowNodeDefinition flowNodeDefinition) {
        boolean hasLocalOrInheritedData;
        boolean bl = hasLocalOrInheritedData = childHaveData || !processDefinition.getProcessContainer().getDataDefinitions().isEmpty();
        if (flowNodeDefinition != null) {
            hasLocalOrInheritedData = hasLocalOrInheritedData || !flowNodeDefinition.getParentContainer().getDataDefinitions().isEmpty();
        }
        return hasLocalOrInheritedData;
    }

    public void handleCallActivity(SProcessDefinition processDefinition, SFlowNodeInstance flowNodeInstance) throws SActivityStateExecutionException {
        if (this.isCallActivity(flowNodeInstance)) {
            SFlowElementContainerDefinition processContainer = processDefinition.getProcessContainer();
            try {
                SCallActivityDefinition callActivity = (SCallActivityDefinition)processContainer.getFlowNode(flowNodeInstance.getFlowNodeDefinitionId());
                if (callActivity == null) {
                    StringBuilder stb = new StringBuilder("unable to find call activity definition with name '");
                    stb.append(flowNodeInstance.getName());
                    stb.append("' in procecess definition '");
                    stb.append(processDefinition.getId());
                    stb.append("'");
                    throw new SActivityStateExecutionException(stb.toString());
                }
                SExpressionContext expressionContext = new SExpressionContext((Long)flowNodeInstance.getId(), DataInstanceContainer.ACTIVITY_INSTANCE.name(), processDefinition.getId());
                String callableElement = (String)this.expressionResolverService.evaluate(callActivity.getCallableElement(), expressionContext);
                String callableElementVersion = null;
                if (callActivity.getCallableElementVersion() != null) {
                    callableElementVersion = (String)this.expressionResolverService.evaluate(callActivity.getCallableElementVersion(), expressionContext);
                }
                long targetProcessDefinitionId = this.getTargetProcessDefinitionId(callableElement, callableElementVersion);
                this.instantiateProcess(processDefinition, callActivity, flowNodeInstance, targetProcessDefinitionId);
                SCallActivityInstance callActivityInstance = (SCallActivityInstance)flowNodeInstance;
                this.activityInstanceService.setTokenCount(callActivityInstance, callActivityInstance.getTokenCount() + 1);
            }
            catch (SBonitaException e) {
                throw new SActivityStateExecutionException(e);
            }
        }
    }

    private long getTargetProcessDefinitionId(String callableElement, String callableElementVersion) throws SProcessDefinitionReadException {
        if (callableElementVersion != null) {
            return this.processDefinitionService.getProcessDefinitionId(callableElement, callableElementVersion);
        }
        return this.processDefinitionService.getLatestProcessDefinitionId(callableElement);
    }

    private boolean isCallActivity(SFlowNodeInstance flowNodeInstance) {
        return SFlowNodeType.CALL_ACTIVITY.equals((Object)flowNodeInstance.getType());
    }

    private void instantiateProcess(SProcessDefinition callerProcessDefinition, SCallActivityDefinition callActivityDefinition, SFlowNodeInstance callActivityInstance, long targetProcessDefinitionId) throws SProcessInstanceCreationException {
        long callerProcessDefinitionId = callerProcessDefinition.getId();
        long callerId = callActivityInstance.getId();
        List<SOperation> operationList = callActivityDefinition.getDataInputOperations();
        SExpressionContext context = new SExpressionContext((Long)callerId, DataInstanceContainer.ACTIVITY_INSTANCE.name(), callerProcessDefinitionId);
        OperationsWithContext operations = new OperationsWithContext(context, operationList);
        this.processExecutor.start(targetProcessDefinitionId, -1L, 0L, 0L, operations.getContext(), operations.getOperations(), null, null, callerId, -1L);
    }

    public void updateDisplayNameAndDescription(SProcessDefinition processDefinition, SFlowNodeInstance flowNodeInstance) throws SActivityStateExecutionException {
        try {
            SFlowElementContainerDefinition processContainer = processDefinition.getProcessContainer();
            SFlowNodeDefinition flowNode = processContainer.getFlowNode(flowNodeInstance.getFlowNodeDefinitionId());
            if (flowNode != null) {
                SExpression displayNameExpression = flowNode.getDisplayName();
                SExpression displayDescriptionExpression = flowNode.getDisplayDescription();
                SExpressionContext sExpressionContext = new SExpressionContext((Long)flowNodeInstance.getId(), DataInstanceContainer.ACTIVITY_INSTANCE.name(), processDefinition.getId());
                String displayName = displayNameExpression != null ? (String)this.expressionResolverService.evaluate(displayNameExpression, sExpressionContext) : flowNode.getName();
                String displayDescription = displayDescriptionExpression != null ? (String)this.expressionResolverService.evaluate(displayDescriptionExpression, sExpressionContext) : flowNode.getDescription();
                this.activityInstanceService.updateDisplayName(flowNodeInstance, displayName);
                this.activityInstanceService.updateDisplayDescription(flowNodeInstance, displayDescription);
            }
        }
        catch (SFlowNodeModificationException e) {
            throw new SActivityStateExecutionException("error while updating display name and description", e);
        }
        catch (SExpressionTypeUnknownException e) {
            throw new SActivityStateExecutionException("error while updating display name and description", e);
        }
        catch (SExpressionEvaluationException e) {
            throw new SActivityStateExecutionException("error while updating display name and description", e);
        }
        catch (SExpressionDependencyMissingException e) {
            throw new SActivityStateExecutionException("error while updating display name and description", e);
        }
        catch (SInvalidExpressionException e) {
            throw new SActivityStateExecutionException("error while updating display name and description", e);
        }
    }

    public void updateDisplayDescriptionAfterCompletion(SProcessDefinition processDefinition, SFlowNodeInstance flowNodeInstance) throws SActivityStateExecutionException {
        try {
            SFlowElementContainerDefinition processContainer = processDefinition.getProcessContainer();
            SFlowNodeDefinition flowNode = processContainer.getFlowNode(flowNodeInstance.getFlowNodeDefinitionId());
            if (flowNode != null) {
                SExpression displayDescriptionAfterCompletionExpression = flowNode.getDisplayDescriptionAfterCompletion();
                SExpressionContext sExpressionContext = new SExpressionContext((Long)flowNodeInstance.getId(), DataInstanceContainer.ACTIVITY_INSTANCE.name(), processDefinition.getId());
                if (displayDescriptionAfterCompletionExpression != null) {
                    String displayDescriptionAfterCompletion = (String)this.expressionResolverService.evaluate(displayDescriptionAfterCompletionExpression, sExpressionContext);
                    this.activityInstanceService.updateDisplayDescription(flowNodeInstance, displayDescriptionAfterCompletion);
                }
            }
        }
        catch (SFlowNodeModificationException e) {
            throw new SActivityStateExecutionException("error while updating display name and description", e);
        }
        catch (SExpressionTypeUnknownException e) {
            throw new SActivityStateExecutionException("error while updating display name and description", e);
        }
        catch (SExpressionEvaluationException e) {
            throw new SActivityStateExecutionException("error while updating display name and description", e);
        }
        catch (SExpressionDependencyMissingException e) {
            throw new SActivityStateExecutionException("error while updating display name and description", e);
        }
        catch (SInvalidExpressionException e) {
            throw new SActivityStateExecutionException("error while updating display name and description", e);
        }
    }

    public void executeOperations(SProcessDefinition processDefinition, SActivityInstance activityInstance) throws SActivityStateExecutionException {
        try {
            SFlowElementContainerDefinition processContainer = processDefinition.getProcessContainer();
            SFlowNodeDefinition flowNode = processContainer.getFlowNode(activityInstance.getFlowNodeDefinitionId());
            if (flowNode instanceof SActivityDefinition) {
                SActivityDefinition activityDefinition = (SActivityDefinition)flowNode;
                List<SOperation> sOperations = activityDefinition.getSOperations();
                SExpressionContext sExpressionContext = new SExpressionContext((Long)activityInstance.getId(), DataInstanceContainer.ACTIVITY_INSTANCE.name(), processDefinition.getId());
                this.operationService.execute(sOperations, sExpressionContext);
            }
        }
        catch (SBonitaException e) {
            throw new SActivityStateExecutionException(e);
        }
    }

    public void handleThrowEvent(SProcessDefinition processDefinition, SFlowNodeInstance flowNodeInstance) throws SActivityStateExecutionException {
        if (flowNodeInstance instanceof SThrowEventInstance) {
            SThrowEventInstance throwEventInstance = (SThrowEventInstance)flowNodeInstance;
            SFlowElementContainerDefinition processContainer = processDefinition.getProcessContainer();
            SThrowEventDefinition eventDefinition = (SThrowEventDefinition)processContainer.getFlowNode(throwEventInstance.getFlowNodeDefinitionId());
            try {
                this.eventsHandler.handleThrowEvent(processDefinition, eventDefinition, throwEventInstance);
            }
            catch (SBonitaException e) {
                throw new SActivityStateExecutionException("unable to handle throw event " + flowNodeInstance, e);
            }
        }
        if (SFlowNodeType.SEND_TASK.equals((Object)flowNodeInstance.getType())) {
            SSendTaskInstance sendTaskInstance = (SSendTaskInstance)flowNodeInstance;
            SFlowElementContainerDefinition processContainer = processDefinition.getProcessContainer();
            SSendTaskDefinition sendTaskDefinition = (SSendTaskDefinition)processContainer.getFlowNode(sendTaskInstance.getFlowNodeDefinitionId());
            try {
                this.eventsHandler.handleThrowMessage(processDefinition, sendTaskDefinition, sendTaskInstance);
            }
            catch (SBonitaException e) {
                throw new SActivityStateExecutionException("unable to handle throw message " + flowNodeInstance, e);
            }
        }
    }

    public void executeChildrenActivities(SFlowNodeInstance flowNodeInstance) throws SActivityExecutionException {
        try {
            List<SActivityInstance> childrenOfAnActivity;
            int i = 0;
            do {
                childrenOfAnActivity = this.activityInstanceService.getChildrenOfAnActivity(flowNodeInstance.getId(), i, 20);
                for (SActivityInstance sActivityInstance : childrenOfAnActivity) {
                    this.containerRegistry.executeFlowNode(sActivityInstance.getId(), null, null, SFlowElementsContainerType.FLOWNODE.name(), sActivityInstance.getLogicalGroup(BuilderFactory.get(SAAutomaticTaskInstanceBuilderFactory.class).getParentProcessInstanceIndex()));
                }
                i += 20;
            } while (childrenOfAnActivity.size() == 20);
        }
        catch (SBonitaException e) {
            throw new SActivityExecutionException(e);
        }
    }

    public void interruptSubActivities(long parentActivityInstanceId, SStateCategory stateCategory) throws SBonitaException {
        List<SActivityInstance> childrenToEnd;
        int numberOfResults = 100;
        SUserTaskInstanceBuilderFactory flowNodeKeyProvider = BuilderFactory.get(SUserTaskInstanceBuilderFactory.class);
        ArrayList<FilterOption> filters = new ArrayList<FilterOption>(3);
        filters.add(new FilterOption(SActivityInstance.class, flowNodeKeyProvider.getParentActivityInstanceKey(), parentActivityInstanceId));
        filters.add(new FilterOption(SActivityInstance.class, flowNodeKeyProvider.getTerminalKey(), false));
        filters.add(new FilterOption(SActivityInstance.class, flowNodeKeyProvider.getStateCategoryKey(), SStateCategory.NORMAL.name()));
        OrderByOption orderByOption = new OrderByOption(SActivityInstance.class, flowNodeKeyProvider.getNameKey(), OrderByType.ASC);
        QueryOptions queryOptions = new QueryOptions(0, 100, Collections.singletonList(orderByOption), filters, null);
        do {
            childrenToEnd = this.activityInstanceService.searchActivityInstances(SActivityInstance.class, queryOptions);
            for (SActivityInstance child : childrenToEnd) {
                this.activityInstanceService.setStateCategory(child, stateCategory);
                if (!child.isStable()) continue;
                this.containerRegistry.executeFlowNode(child.getId(), null, null, SFlowElementsContainerType.FLOWNODE.name(), child.getLogicalGroup(BuilderFactory.get(SAAutomaticTaskInstanceBuilderFactory.class).getParentProcessInstanceIndex()));
            }
            queryOptions = QueryOptions.getNextPage(queryOptions);
        } while (childrenToEnd.size() == 100);
    }

    public void executeConnectorInWork(Long processDefinitionId, long flowNodeDefinitionId, long flowNodeInstanceId, SConnectorInstance connector, SConnectorDefinition sConnectorDefinition) throws SActivityStateExecutionException {
        long connectorInstanceId = connector.getId();
        String connectorDefinitionName = sConnectorDefinition.getName();
        try {
            this.connectorInstanceService.setState(connector, ConnectorState.EXECUTING.name());
            this.workService.registerWork(WorkFactory.createExecuteConnectorOfActivity(processDefinitionId, flowNodeDefinitionId, flowNodeInstanceId, connectorInstanceId, connectorDefinitionName));
        }
        catch (SConnectorInstanceModificationException e) {
            throw new SActivityStateExecutionException("Unable to set ConnectorState to EXECUTING", e);
        }
        catch (WorkRegisterException e) {
            throw new SActivityStateExecutionException("Unable to register the work that execute the connector " + connector + " on " + flowNodeInstanceId, e);
        }
    }

    public void createAttachedBoundaryEvents(SProcessDefinition processDefinition, SActivityInstance activityInstance) throws SActivityStateExecutionException {
        SActivityDefinition activityDefinition = (SActivityDefinition)processDefinition.getProcessContainer().getFlowNode(activityInstance.getFlowNodeDefinitionId());
        if (activityDefinition != null) {
            List<SBoundaryEventDefinition> boundaryEventDefinitions;
            boolean mustAddBoundaries = true;
            if (activityDefinition.getLoopCharacteristics() != null && !SFlowNodeType.MULTI_INSTANCE_ACTIVITY.equals((Object)activityInstance.getType()) && !SFlowNodeType.LOOP_ACTIVITY.equals((Object)activityInstance.getType())) {
                mustAddBoundaries = false;
            }
            if (mustAddBoundaries && !(boundaryEventDefinitions = activityDefinition.getBoundaryEventDefinitions()).isEmpty()) {
                try {
                    SBoundaryEventInstanceBuilderFactory boundaryEventInstanceBuilder = BuilderFactory.get(SBoundaryEventInstanceBuilderFactory.class);
                    long rootProcessInstanceId = activityInstance.getLogicalGroup(boundaryEventInstanceBuilder.getRootProcessInstanceIndex());
                    long parentProcessInstanceId = activityInstance.getLogicalGroup(boundaryEventInstanceBuilder.getParentProcessInstanceIndex());
                    SFlowElementsContainerType containerType = SFlowElementsContainerType.PROCESS;
                    long parentActivityInstanceId = activityInstance.getLogicalGroup(boundaryEventInstanceBuilder.getParentActivityInstanceIndex());
                    if (parentActivityInstanceId > 0L) {
                        containerType = SFlowElementsContainerType.FLOWNODE;
                    }
                    for (SBoundaryEventDefinition boundaryEventDefinition : boundaryEventDefinitions) {
                        SFlowNodeInstance boundaryEventInstance = this.bpmInstancesCreator.createFlowNodeInstance(processDefinition.getId(), rootProcessInstanceId, activityInstance.getParentContainerId(), containerType, boundaryEventDefinition, rootProcessInstanceId, parentProcessInstanceId, false, -1, SStateCategory.NORMAL, activityInstance.getId(), activityInstance.getTokenRefId());
                        this.containerRegistry.executeFlowNodeInSameThread(boundaryEventInstance.getId(), null, null, containerType.name(), parentProcessInstanceId);
                    }
                }
                catch (SBonitaException e) {
                    throw new SActivityStateExecutionException("Unable to create boundary events attached to activity " + activityInstance.getName(), e);
                }
            }
        }
    }

    public void interruptAttachedBoundaryEvent(SProcessDefinition processDefinition, SActivityInstance activityInstance, SStateCategory categoryState) throws SActivityStateExecutionException {
        SBoundaryEventInstanceBuilderFactory keyProvider = BuilderFactory.get(SBoundaryEventInstanceBuilderFactory.class);
        try {
            List<SBoundaryEventInstance> boundaryEventInstances = this.eventInstanceService.getActivityBoundaryEventInstances(activityInstance.getId());
            for (SBoundaryEventInstance boundaryEventInstance : boundaryEventInstances) {
                if (activityInstance.getAbortedByBoundary() == boundaryEventInstance.getId()) continue;
                boolean stable = boundaryEventInstance.isStable();
                SBoundaryEventDefinition catchEventDef = processDefinition.getProcessContainer().getBoundaryEvent(boundaryEventInstance.getName());
                this.interrupWaitinEvents(processDefinition, boundaryEventInstance, catchEventDef);
                this.activityInstanceService.setStateCategory(boundaryEventInstance, categoryState);
                if (!stable) continue;
                String containerType = SFlowElementsContainerType.PROCESS.name();
                long parentActivityInstanceId = boundaryEventInstance.getLogicalGroup(keyProvider.getParentActivityInstanceIndex());
                if (parentActivityInstanceId > 0L) {
                    containerType = SFlowElementsContainerType.FLOWNODE.name();
                }
                this.containerRegistry.executeFlowNode(boundaryEventInstance.getId(), null, null, containerType, boundaryEventInstance.getLogicalGroup(keyProvider.getParentProcessInstanceIndex()));
            }
        }
        catch (SBonitaException e) {
            throw new SActivityStateExecutionException("Unable cancel boundary events attached to activity " + activityInstance.getName(), e);
        }
    }

    public void interrupWaitinEvents(SProcessDefinition processDefinition, SCatchEventInstance catchEventInstance, SCatchEventDefinition catchEventDef) throws SBonitaException {
        this.interruptTimerEvent(processDefinition, catchEventInstance, catchEventDef);
        this.interruptWaitingEvents(catchEventInstance.getId(), catchEventDef);
    }

    private void interruptWaitingEvents(long instanceId, SCatchEventDefinition catchEventDef) throws SBonitaSearchException, SWaitingEventModificationException {
        if (!catchEventDef.getEventTriggers().isEmpty()) {
            this.interruptWaitingEvents(instanceId, SWaitingEvent.class);
        }
    }

    public void interrupWaitinEvents(SReceiveTaskInstance receiveTaskInstance) throws SBonitaException {
        this.interruptWaitingEvents(receiveTaskInstance.getId(), SWaitingEvent.class);
    }

    private QueryOptions getWaitingEventsCountOptions(long instanceId, Class<? extends SWaitingEvent> waitingEventClass) {
        List<FilterOption> filters = this.getFilterForWaitingEventsToInterrupt(instanceId, waitingEventClass);
        return new QueryOptions(filters, null);
    }

    private QueryOptions getWaitingEventsQueryOptions(long instanceId, Class<? extends SWaitingEvent> waitingEventClass) {
        OrderByOption orderByOption = new OrderByOption(waitingEventClass, BuilderFactory.get(SWaitingEventKeyProviderBuilderFactory.class).getIdKey(), OrderByType.ASC);
        List<FilterOption> filters = this.getFilterForWaitingEventsToInterrupt(instanceId, waitingEventClass);
        return new QueryOptions(0, 100, Collections.singletonList(orderByOption), filters, null);
    }

    private List<FilterOption> getFilterForWaitingEventsToInterrupt(long instanceId, Class<? extends SWaitingEvent> waitingEventClass) {
        SWaitingEventKeyProviderBuilderFactory waitingEventKeyProvider = BuilderFactory.get(SWaitingEventKeyProviderBuilderFactory.class);
        ArrayList<FilterOption> filters = new ArrayList<FilterOption>(2);
        filters.add(new FilterOption(waitingEventClass, waitingEventKeyProvider.getFlowNodeInstanceIdKey(), instanceId));
        filters.add(new FilterOption(waitingEventClass, waitingEventKeyProvider.getActiveKey(), true));
        return filters;
    }

    private <T extends SWaitingEvent> void interruptWaitingEvents(long instanceId, Class<T> waitingEventClass) throws SBonitaSearchException, SWaitingEventModificationException {
        List<T> waitingEvents;
        QueryOptions queryOptions = this.getWaitingEventsQueryOptions(instanceId, waitingEventClass);
        QueryOptions countOptions = this.getWaitingEventsCountOptions(instanceId, waitingEventClass);
        long count = 0L;
        do {
            waitingEvents = this.eventInstanceService.searchWaitingEvents(waitingEventClass, queryOptions);
            count = this.eventInstanceService.getNumberOfWaitingEvents(waitingEventClass, countOptions);
            this.deleWaitingEvents(waitingEvents);
        } while (count > (long)waitingEvents.size());
    }

    private void deleWaitingEvents(List<? extends SWaitingEvent> waitingEvents) throws SWaitingEventModificationException {
        for (SWaitingEvent sWaitingEvent : waitingEvents) {
            this.eventInstanceService.deleteWaitingEvent(sWaitingEvent);
        }
    }

    private void interruptTimerEvent(SProcessDefinition processDefinition, SCatchEventInstance catchEventInstance, SCatchEventDefinition catchEventDef) throws SSchedulerException {
        String jobName;
        boolean delete;
        if (!catchEventDef.getTimerEventTriggerDefinitions().isEmpty() && !(delete = this.schedulerService.delete(jobName = JobNameBuilder.getTimerEventJobName(processDefinition.getId(), catchEventDef, catchEventInstance))) && this.logger.isLoggable(EndingIntermediateCatchEventExceptionStateImpl.class, TechnicalLogSeverity.WARNING)) {
            this.logger.log(EndingIntermediateCatchEventExceptionStateImpl.class, TechnicalLogSeverity.WARNING, "No job found with name '" + jobName + "' when interrupting timer catch event named '" + catchEventDef.getName() + "' and id '" + catchEventInstance.getId() + "'. It was probably already triggered.");
        }
    }
}

