/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.execution.work;

import java.util.Map;
import org.bonitasoft.engine.core.process.definition.SProcessDefinitionNotFoundException;
import org.bonitasoft.engine.core.process.instance.api.exceptions.SFlowNodeNotFoundException;
import org.bonitasoft.engine.core.process.instance.api.exceptions.SProcessInstanceNotFoundException;
import org.bonitasoft.engine.execution.work.WrappingBonitaWork;
import org.bonitasoft.engine.incident.Incident;
import org.bonitasoft.engine.incident.IncidentService;
import org.bonitasoft.engine.log.technical.TechnicalLogSeverity;
import org.bonitasoft.engine.log.technical.TechnicalLoggerService;
import org.bonitasoft.engine.service.TenantServiceAccessor;
import org.bonitasoft.engine.service.TenantServiceSingleton;
import org.bonitasoft.engine.sessionaccessor.SessionAccessor;
import org.bonitasoft.engine.work.BonitaWork;

public class FailureHandlingBonitaWork
extends WrappingBonitaWork {
    private static final long serialVersionUID = 1L;
    protected transient TechnicalLoggerService loggerService;
    private transient SessionAccessor sessionAccessor;

    public FailureHandlingBonitaWork(BonitaWork work) {
        super(work);
    }

    protected void logIncident(Throwable cause, Throwable exceptionWhenHandlingFailure) {
        Incident incident = new Incident(this.getDescription(), this.getRecoveryProcedure(), cause, exceptionWhenHandlingFailure);
        IncidentService incidentService = this.getTenantAccessor().getIncidentService();
        incidentService.report(this.getTenantId(), incident);
    }

    protected TenantServiceAccessor getTenantAccessor() {
        try {
            return TenantServiceSingleton.getInstance(this.getTenantId());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void work(Map<String, Object> context) {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        this.loggerService = tenantAccessor.getTechnicalLoggerService();
        this.sessionAccessor = tenantAccessor.getSessionAccessor();
        context.put("tenantAccessor", tenantAccessor);
        try {
            this.sessionAccessor.setTenantId(this.getTenantId());
            if (this.loggerService.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.loggerService.log(this.getClass(), TechnicalLogSeverity.TRACE, "Starting work: " + this.getDescription());
            }
            this.getWrappedWork().work(context);
        }
        catch (Throwable e) {
            Throwable cause = e.getCause();
            if (cause instanceof SFlowNodeNotFoundException || cause instanceof SProcessInstanceNotFoundException || cause instanceof SProcessDefinitionNotFoundException) {
                if (this.loggerService.isLoggable(this.getClass(), TechnicalLogSeverity.DEBUG)) {
                    this.loggerService.log(this.getClass(), TechnicalLogSeverity.DEBUG, "The work fails during its execution due to: " + this.getDescription(), cause);
                }
            } else {
                this.loggerService.log(this.getClass(), TechnicalLogSeverity.WARNING, "A work failed, The failure will be handled, work is:  " + this.getDescription());
                this.loggerService.log(this.getClass(), TechnicalLogSeverity.WARNING, "Exception was:" + e.getMessage(), e);
                try {
                    this.getWrappedWork().handleFailure(e, context);
                }
                catch (Throwable e1) {
                    this.loggerService.log(this.getClass(), TechnicalLogSeverity.ERROR, "Unexpected error while executing work " + this.getDescription() + ". You may consider restarting the system. This will restart all works.", e);
                    this.loggerService.log(this.getClass(), TechnicalLogSeverity.ERROR, "Unable to handle the failure ", e);
                    this.logIncident(e, e1);
                }
            }
        }
        finally {
            this.sessionAccessor.deleteTenantId();
        }
    }
}

