/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.external.process;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.bonitasoft.engine.api.impl.transaction.process.GetProcessDefinition;
import org.bonitasoft.engine.command.SCommandExecutionException;
import org.bonitasoft.engine.command.SCommandParameterizationException;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.core.expression.control.model.SExpressionContext;
import org.bonitasoft.engine.core.operation.OperationService;
import org.bonitasoft.engine.core.operation.model.SOperation;
import org.bonitasoft.engine.core.process.definition.ProcessDefinitionService;
import org.bonitasoft.engine.core.process.definition.SProcessDefinitionNotFoundException;
import org.bonitasoft.engine.external.process.UpdateVariableValuesThroughOperations;
import org.bonitasoft.engine.operation.Operation;
import org.bonitasoft.engine.service.ModelConvertor;
import org.bonitasoft.engine.service.TenantServiceAccessor;

public class GetUpdatedVariableValuesForProcessDefinition
extends UpdateVariableValuesThroughOperations {
    private static final String PROCESS_DEFINITION_ID_KEY = "PROCESS_DEFINITION_ID_KEY";
    private TenantServiceAccessor serviceAccessor;

    @Override
    public Serializable execute(Map<String, Serializable> parameters, TenantServiceAccessor serviceAccessor) throws SCommandParameterizationException, SCommandExecutionException {
        long processDefinitionId;
        Map currentVariableValues;
        Map operationsInputValues;
        List operations;
        this.serviceAccessor = serviceAccessor;
        try {
            operations = (List)((Object)parameters.get("OPERATIONS_LIST_KEY"));
            operationsInputValues = (Map)((Object)parameters.get("OPERATIONS_INPUT_KEY"));
            currentVariableValues = (Map)((Object)parameters.get("CURRENT_VARIABLE_VALUES_MAP_KEY"));
            processDefinitionId = (Long)parameters.get(PROCESS_DEFINITION_ID_KEY);
        }
        catch (Exception e) {
            throw new SCommandParameterizationException("One mandatory parameter OPERATIONS_LIST_KEY/OPERATIONS_INPUT_KEY/CURRENT_VARIABLE_VALUES_MAP_KEY/PROCESS_DEFINITION_ID_KEY is missing.");
        }
        if (operations == null || operationsInputValues == null || currentVariableValues == null) {
            throw new SCommandParameterizationException("One mandatory parameter OPERATIONS_LIST_KEY/OPERATIONS_INPUT_KEY/CURRENT_VARIABLE_VALUES_MAP_KEY/PROCESS_DEFINITION_ID_KEY is not convertible.");
        }
        try {
            this.checkProcessDef(processDefinitionId);
        }
        catch (SProcessDefinitionNotFoundException e) {
            throw new SCommandExecutionException(e);
        }
        try {
            this.updateVariablesThroughOperations(operations, operationsInputValues, currentVariableValues, processDefinitionId);
        }
        catch (SBonitaException e) {
            throw new SCommandExecutionException(e);
        }
        return (Serializable)((Object)currentVariableValues);
    }

    private void checkProcessDef(long processDefinitionId) throws SProcessDefinitionNotFoundException {
        ProcessDefinitionService processDefinitionService = this.serviceAccessor.getProcessDefinitionService();
        GetProcessDefinition transaction = new GetProcessDefinition(processDefinitionId, processDefinitionService);
        try {
            transaction.execute();
        }
        catch (SBonitaException e) {
            throw new SProcessDefinitionNotFoundException(e);
        }
    }

    @Override
    protected void executeOperation(Operation operation, Map<String, Serializable> operationsInputValues, Map<String, Serializable> currentVariableValues, long processDefinitionId) throws SBonitaException {
        if (currentVariableValues != null) {
            SOperation sOperation = ModelConvertor.constructSOperation(operation);
            Map<String, Serializable> inputValues = operationsInputValues;
            inputValues.putAll(currentVariableValues);
            SExpressionContext sec = new SExpressionContext();
            sec.setSerializableInputValues(inputValues);
            sec.setProcessDefinitionId(processDefinitionId);
            OperationService operationService = this.serviceAccessor.getOperationService();
            operationService.execute(sOperation, -1L, null, sec);
            for (Map.Entry<String, Serializable> variable : currentVariableValues.entrySet()) {
                Object updatedValue = sec.getInputValues().get(variable.getKey());
                variable.setValue((Serializable)updatedValue);
            }
        }
    }

    @Override
    public TenantServiceAccessor getServiceAccessor() {
        return this.serviceAccessor;
    }

    @Override
    public long getProcessDefinitionId(long containerInstanceId) {
        return containerInstanceId;
    }
}

