/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.external.web.forms;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bonitasoft.engine.api.impl.transaction.activity.GetActivityInstance;
import org.bonitasoft.engine.api.impl.transaction.process.GetProcessDefinition;
import org.bonitasoft.engine.api.impl.transaction.process.GetProcessInstance;
import org.bonitasoft.engine.bpm.flownode.ActivityInstanceNotFoundException;
import org.bonitasoft.engine.bpm.process.InvalidProcessDefinitionException;
import org.bonitasoft.engine.bpm.process.ProcessInstance;
import org.bonitasoft.engine.bpm.process.ProcessInstanceNotFoundException;
import org.bonitasoft.engine.builder.BuilderFactory;
import org.bonitasoft.engine.classloader.ClassLoaderException;
import org.bonitasoft.engine.classloader.ClassLoaderService;
import org.bonitasoft.engine.command.system.CommandWithParameters;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.core.operation.model.SLeftOperand;
import org.bonitasoft.engine.core.operation.model.SOperation;
import org.bonitasoft.engine.core.operation.model.SOperatorType;
import org.bonitasoft.engine.core.operation.model.builder.SLeftOperandBuilderFactory;
import org.bonitasoft.engine.core.operation.model.builder.SOperationBuilderFactory;
import org.bonitasoft.engine.core.process.definition.ProcessDefinitionService;
import org.bonitasoft.engine.core.process.definition.SProcessDefinitionNotFoundException;
import org.bonitasoft.engine.core.process.definition.exception.SProcessDefinitionReadException;
import org.bonitasoft.engine.core.process.definition.model.SProcessDefinition;
import org.bonitasoft.engine.core.process.instance.api.ActivityInstanceService;
import org.bonitasoft.engine.core.process.instance.api.ProcessInstanceService;
import org.bonitasoft.engine.core.process.instance.model.SActivityInstance;
import org.bonitasoft.engine.exception.BonitaRuntimeException;
import org.bonitasoft.engine.expression.Expression;
import org.bonitasoft.engine.expression.exception.SInvalidExpressionException;
import org.bonitasoft.engine.expression.model.SExpression;
import org.bonitasoft.engine.expression.model.builder.SExpressionBuilderFactory;
import org.bonitasoft.engine.log.technical.TechnicalLogSeverity;
import org.bonitasoft.engine.log.technical.TechnicalLoggerService;
import org.bonitasoft.engine.operation.LeftOperand;
import org.bonitasoft.engine.operation.Operation;
import org.bonitasoft.engine.search.descriptor.SearchProcessInstanceDescriptor;
import org.bonitasoft.engine.service.TenantServiceAccessor;
import org.bonitasoft.engine.service.TenantServiceSingleton;
import org.bonitasoft.engine.service.impl.ServiceAccessorFactory;
import org.bonitasoft.engine.sessionaccessor.SessionAccessor;
import org.bonitasoft.engine.sessionaccessor.TenantIdNotSetException;

public abstract class ExecuteActionsBaseEntry
extends CommandWithParameters {
    protected static final String ACTIVITY_INSTANCE_ID_KEY = "ACTIVITY_INSTANCE_ID_KEY";
    protected static final String PROCESS_DEFINITION_ID_KEY = "PROCESS_DEFINITION_ID_KEY";
    protected static final String OPERATIONS_LIST_KEY = "OPERATIONS_LIST_KEY";
    protected static final String OPERATIONS_INPUT_KEY = "OPERATIONS_INPUT_KEY";
    protected static final String CONNECTORS_LIST_KEY = "CONNECTORS_LIST_KEY";
    protected static final String USER_ID_KEY = "USER_ID_KEY";

    protected static TenantServiceAccessor getTenantAccessor() {
        try {
            SessionAccessor sessionAccessor = ServiceAccessorFactory.getInstance().createSessionAccessor();
            long tenantId = sessionAccessor.getTenantId();
            return TenantServiceSingleton.getInstance(tenantId);
        }
        catch (Exception e) {
            throw new BonitaRuntimeException((Throwable)e);
        }
    }

    protected void log(TenantServiceAccessor tenantAccessor, Exception e) {
        TechnicalLoggerService logger = tenantAccessor.getTechnicalLoggerService();
        logger.log(this.getClass(), TechnicalLogSeverity.DEBUG, e);
    }

    protected long getTenantId() {
        SessionAccessor sessionAccessor = null;
        try {
            sessionAccessor = ServiceAccessorFactory.getInstance().createSessionAccessor();
        }
        catch (Exception e) {
            throw new BonitaRuntimeException((Throwable)e);
        }
        try {
            return sessionAccessor.getTenantId();
        }
        catch (TenantIdNotSetException e) {
            throw new BonitaRuntimeException((Throwable)e);
        }
    }

    protected SOperation toSOperation(Operation operation) throws SInvalidExpressionException {
        SExpression rightOperand = this.toSExpression(operation.getRightOperand());
        SOperatorType operatorType = SOperatorType.valueOf(operation.getType().name());
        SLeftOperand sLeftOperand = this.toSLeftOperand(operation.getLeftOperand());
        SOperation sOperation = BuilderFactory.get(SOperationBuilderFactory.class).createNewInstance().setOperator(operation.getOperator()).setRightOperand(rightOperand).setType(operatorType).setLeftOperand(sLeftOperand).done();
        return sOperation;
    }

    protected SLeftOperand toSLeftOperand(LeftOperand variableToSet) {
        return BuilderFactory.get(SLeftOperandBuilderFactory.class).createNewInstance().setName(variableToSet.getName()).done();
    }

    protected SExpression toSExpression(Expression exp) throws SInvalidExpressionException {
        ArrayList<SExpression> dependencies = new ArrayList<SExpression>(exp.getDependencies().size());
        if (!exp.getDependencies().isEmpty()) {
            for (Expression dependency : exp.getDependencies()) {
                dependencies.add(this.toSExpression(dependency));
            }
        }
        SExpression sExpression = BuilderFactory.get(SExpressionBuilderFactory.class).createNewInstance().setName(exp.getName()).setContent(exp.getContent()).setExpressionType(exp.getExpressionType()).setInterpreter(exp.getInterpreter()).setReturnType(exp.getReturnType()).setDependencies(dependencies).done();
        return sExpression;
    }

    protected List<SOperation> toSOperation(List<Operation> operations) throws SInvalidExpressionException {
        if (operations == null) {
            return null;
        }
        if (operations.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<SOperation> sOperations = new ArrayList<SOperation>(operations.size());
        for (Operation operation : operations) {
            SOperation sOperation = this.toSOperation(operation);
            sOperations.add(sOperation);
        }
        return sOperations;
    }

    protected SActivityInstance getActivityInstance(TenantServiceAccessor tenantAccessor, long activityInstanceId) throws ActivityInstanceNotFoundException {
        ActivityInstanceService activityInstanceService = tenantAccessor.getActivityInstanceService();
        GetActivityInstance getActivityInstance = new GetActivityInstance(activityInstanceService, activityInstanceId);
        try {
            getActivityInstance.execute();
        }
        catch (SBonitaException e) {
            throw new ActivityInstanceNotFoundException(activityInstanceId);
        }
        return getActivityInstance.getResult();
    }

    protected ProcessInstance getProcessInstance(TenantServiceAccessor tenantAccessor, long processInstanceId) throws ProcessInstanceNotFoundException {
        ProcessInstanceService processInstanceService = tenantAccessor.getProcessInstanceService();
        ProcessDefinitionService processDefinitionService = tenantAccessor.getProcessDefinitionService();
        SearchProcessInstanceDescriptor searchProcessInstanceDescriptor = tenantAccessor.getSearchEntitiesDescriptor().getSearchProcessInstanceDescriptor();
        GetProcessInstance getProcessInstance = new GetProcessInstance(processInstanceService, processDefinitionService, searchProcessInstanceDescriptor, processInstanceId);
        try {
            getProcessInstance.execute();
        }
        catch (SBonitaException e) {
            throw new ProcessInstanceNotFoundException(processInstanceId);
        }
        return getProcessInstance.getResult();
    }

    protected ClassLoader getLocalClassLoader(TenantServiceAccessor tenantAccessor, long processDefinitionId) throws org.bonitasoft.engine.exception.ClassLoaderException {
        ClassLoaderService classLoaderService = tenantAccessor.getClassLoaderService();
        try {
            return classLoaderService.getLocalClassLoader("process", processDefinitionId);
        }
        catch (ClassLoaderException e) {
            throw new org.bonitasoft.engine.exception.ClassLoaderException((Throwable)e);
        }
    }

    protected SProcessDefinition getServerProcessDefinition(long processDefinitionUUID, ProcessDefinitionService processDefinitionService) throws SProcessDefinitionNotFoundException, SProcessDefinitionReadException {
        GetProcessDefinition transactionContentWithResult = new GetProcessDefinition(processDefinitionUUID, processDefinitionService);
        try {
            transactionContentWithResult.execute();
            return (SProcessDefinition)transactionContentWithResult.getResult();
        }
        catch (SProcessDefinitionNotFoundException e) {
            throw e;
        }
        catch (SProcessDefinitionReadException e) {
            throw e;
        }
        catch (SBonitaException e) {
            throw new SProcessDefinitionNotFoundException(e);
        }
    }

    protected SProcessDefinition getProcessDefinition(TenantServiceAccessor tenantAccessor, long processDefinitionId) throws InvalidProcessDefinitionException {
        ProcessDefinitionService processDefinitionService = tenantAccessor.getProcessDefinitionService();
        GetProcessDefinition getProcessDefinition = new GetProcessDefinition(processDefinitionId, processDefinitionService);
        try {
            getProcessDefinition.execute();
        }
        catch (SBonitaException e) {
            throw new InvalidProcessDefinitionException("invalid processDefinition with id:" + processDefinitionId);
        }
        return getProcessDefinition.getResult();
    }
}

