/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.persistence;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.bonitasoft.engine.persistence.HibernateConfigurationProvider;
import org.bonitasoft.engine.persistence.HibernateResourcesConfigurationProvider;
import org.bonitasoft.engine.persistence.PersistentObject;
import org.bonitasoft.engine.services.SPersistenceException;
import org.hibernate.cfg.Configuration;
import org.hibernate.mapping.PersistentClass;

public class HibernateConfigurationProviderImpl
implements HibernateConfigurationProvider {
    protected final HibernateResourcesConfigurationProvider hibernateResourcesConfigurationProvider;
    protected final Properties properties;
    protected final Map<String, Class<? extends PersistentObject>> interfaceToClassMapping;
    protected final List<String> mappingExclusions;
    protected final Configuration configuration;

    public HibernateConfigurationProviderImpl(Properties properties, HibernateResourcesConfigurationProvider hibernateResourcesConfigurationProvider, Map<String, String> interfaceToClassMapping, List<String> mappingExclusions) throws SPersistenceException {
        this.properties = properties;
        this.hibernateResourcesConfigurationProvider = hibernateResourcesConfigurationProvider;
        this.configuration = this.buildConfiguration(properties, hibernateResourcesConfigurationProvider);
        Iterator it = this.configuration.getClassMappings();
        StringBuilder sb = new StringBuilder();
        sb.append("\n");
        sb.append("\n");
        sb.append("FOUND MAPPING FOR CLASS: ");
        sb.append("\n");
        while (it.hasNext()) {
            sb.append(((PersistentClass)it.next()).getEntityName());
            sb.append("\n");
        }
        sb.append("\n");
        this.interfaceToClassMapping = new HashMap<String, Class<? extends PersistentObject>>();
        for (Map.Entry<String, String> entry : interfaceToClassMapping.entrySet()) {
            String classSimpleName;
            String interfaceClassName = entry.getKey();
            String mappedClassName = entry.getValue();
            PersistentClass persistentClass = this.configuration.getClassMapping(mappedClassName);
            if (persistentClass == null && (persistentClass = this.configuration.getClassMapping(classSimpleName = mappedClassName.substring(mappedClassName.lastIndexOf(46) + 1))) == null) {
                throw new SPersistenceException("Unable to locate a class mapping for class: " + mappedClassName + ", found mappings are: " + sb.toString());
            }
            Class mappedClass = persistentClass.getMappedClass();
            this.interfaceToClassMapping.put(interfaceClassName, mappedClass);
        }
        this.mappingExclusions = mappingExclusions;
    }

    private Configuration buildConfiguration(Properties properties, HibernateResourcesConfigurationProvider hibernateResourcesConfigurationProvider) {
        Configuration configuration = new Configuration();
        configuration.addProperties(properties);
        for (String resource : hibernateResourcesConfigurationProvider.getResources()) {
            configuration.addResource(resource);
        }
        Map<String, String> cacheConcurrencyStrategies = hibernateResourcesConfigurationProvider.getCacheConcurrencyStrategies();
        if (cacheConcurrencyStrategies != null) {
            for (Map.Entry<String, String> cacheConcurrencyStrategy : cacheConcurrencyStrategies.entrySet()) {
                configuration.setCacheConcurrencyStrategy(cacheConcurrencyStrategy.getKey(), cacheConcurrencyStrategy.getValue());
            }
        }
        configuration.buildMappings();
        return configuration;
    }

    @Override
    public Configuration getConfiguration() {
        return this.configuration;
    }

    @Override
    public HibernateResourcesConfigurationProvider getResources() {
        return this.hibernateResourcesConfigurationProvider;
    }

    @Override
    public Map<String, String> getClassAliasMappings() {
        return this.hibernateResourcesConfigurationProvider.getClassAliasMappings();
    }

    @Override
    public Map<String, Class<? extends PersistentObject>> getInterfaceToClassMapping() {
        return Collections.unmodifiableMap(this.interfaceToClassMapping);
    }

    @Override
    public List<String> getMappingExclusions() {
        return Collections.unmodifiableList(this.mappingExclusions);
    }

    @Override
    public Map<String, String> getCacheQueries() {
        return null;
    }
}

