/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.services.impl;

import org.bonitasoft.engine.log.technical.TechnicalLogSeverity;
import org.bonitasoft.engine.log.technical.TechnicalLoggerService;
import org.bonitasoft.engine.services.QueriableLogSessionProvider;
import org.bonitasoft.engine.session.SSessionNotFoundException;
import org.bonitasoft.engine.session.SessionService;
import org.bonitasoft.engine.session.model.SSession;
import org.bonitasoft.engine.sessionaccessor.ReadSessionAccessor;
import org.bonitasoft.engine.sessionaccessor.SessionIdNotSetException;

public class QueriableLogSessionProviderImpl
implements QueriableLogSessionProvider {
    private final SessionService sessionService;
    private final ReadSessionAccessor sessionAccessor;
    private final TechnicalLoggerService technicalLoggerService;
    private final ThreadLocal<SSession> localSession = new ThreadLocal();

    public QueriableLogSessionProviderImpl(SessionService sessionService, ReadSessionAccessor sessionAccessor, TechnicalLoggerService technicalLoggerService) {
        this.sessionService = sessionService;
        this.sessionAccessor = sessionAccessor;
        this.technicalLoggerService = technicalLoggerService;
    }

    private SSession getSession() {
        SSession session;
        block4: {
            session = this.localSession.get();
            try {
                if (session == null || session.getId() != this.sessionAccessor.getSessionId()) {
                    long sessionId = this.sessionAccessor.getSessionId();
                    session = this.sessionService.getSession(sessionId);
                    this.localSession.set(session);
                }
            }
            catch (SessionIdNotSetException e) {
                return null;
            }
            catch (SSessionNotFoundException e) {
                if (!this.technicalLoggerService.isLoggable(this.getClass(), TechnicalLogSeverity.WARNING)) break block4;
                this.technicalLoggerService.log(this.getClass(), TechnicalLogSeverity.WARNING, e);
            }
        }
        return session;
    }

    @Override
    public String getUserId() {
        SSession session = this.getSession();
        if (session != null) {
            return session.getUserName();
        }
        return "system";
    }

    @Override
    public String getClusterNode() {
        SSession session = this.getSession();
        if (session != null) {
            return session.getClusterNode();
        }
        return "";
    }
}

