/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.services.impl;

import java.util.List;
import org.bonitasoft.engine.log.technical.TechnicalLogSeverity;
import org.bonitasoft.engine.log.technical.TechnicalLoggerService;
import org.bonitasoft.engine.platform.PlatformService;
import org.bonitasoft.engine.queriablelogger.model.SQueriableLog;
import org.bonitasoft.engine.services.PersistenceService;
import org.bonitasoft.engine.services.QueriableLogSessionProvider;
import org.bonitasoft.engine.services.QueriableLoggerStrategy;
import org.bonitasoft.engine.services.SPersistenceException;
import org.bonitasoft.engine.services.impl.AbstractQueriableLoggerImpl;

public class SyncQueriableLoggerServiceImpl
extends AbstractQueriableLoggerImpl {
    private final TechnicalLoggerService logger;

    public SyncQueriableLoggerServiceImpl(PersistenceService persistenceService, QueriableLoggerStrategy loggerStrategy, QueriableLogSessionProvider sessionProvider, TechnicalLoggerService logger, PlatformService platformService) {
        super(persistenceService, loggerStrategy, sessionProvider, platformService);
        this.logger = logger;
    }

    @Override
    protected void log(List<SQueriableLog> loggableLogs) {
        block5: {
            try {
                if (this.logger != null && this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                    this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, "persisting log");
                }
                for (SQueriableLog log : loggableLogs) {
                    this.getPersitenceService().insert(log);
                }
                if (this.logger != null && this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                    this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, "log persisted");
                }
            }
            catch (SPersistenceException e) {
                String message = "Error while persisting logs transaction: \n Logs" + loggableLogs;
                if (this.logger == null || !this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.ERROR)) break block5;
                this.logger.log(this.getClass(), TechnicalLogSeverity.ERROR, message, e);
            }
        }
    }
}

