/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.session.impl;

import java.util.Date;
import org.bonitasoft.engine.builder.BuilderFactory;
import org.bonitasoft.engine.commons.ClassReflector;
import org.bonitasoft.engine.commons.LogUtil;
import org.bonitasoft.engine.log.technical.TechnicalLogSeverity;
import org.bonitasoft.engine.log.technical.TechnicalLoggerService;
import org.bonitasoft.engine.session.SSessionException;
import org.bonitasoft.engine.session.SSessionNotFoundException;
import org.bonitasoft.engine.session.SessionProvider;
import org.bonitasoft.engine.session.SessionService;
import org.bonitasoft.engine.session.impl.SessionIdGenerator;
import org.bonitasoft.engine.session.model.SSession;
import org.bonitasoft.engine.session.model.builder.SSessionBuilderFactory;

public class SessionServiceImpl
implements SessionService {
    private final long DEFAULT_SESSION_DURATION = 3600000L;
    private long sessionDuration = 3600000L;
    private final SessionProvider sessionProvider;
    private final String applicationName;
    private final TechnicalLoggerService logger;

    public SessionServiceImpl(SessionProvider sessionProvider, String applicationName, TechnicalLoggerService logger) {
        this.sessionProvider = sessionProvider;
        this.applicationName = applicationName;
        this.logger = logger;
    }

    @Override
    public SSession createSession(long tenantId, String userName) throws SSessionException {
        return this.createSession(tenantId, -1L, userName, false);
    }

    @Override
    public SSession createSession(long tenantId, long userId, String userName, boolean isTechnicalUser) throws SSessionException {
        long id = SessionIdGenerator.getNextId();
        long duration = this.getSessionDuration();
        SSession session = BuilderFactory.get(SSessionBuilderFactory.class).createNewInstance(id, tenantId, duration, userName, this.applicationName, userId).technicalUser(isTechnicalUser).done();
        this.sessionProvider.addSession(session);
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, "createSession with tenantId=" + tenantId + " username = " + userName + " Id = " + id);
        }
        return session;
    }

    @Override
    public void deleteSession(long sessionId) throws SSessionNotFoundException {
        this.sessionProvider.removeSession(sessionId);
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, "deleteSession with sessionId=" + sessionId);
        }
    }

    @Override
    public boolean isValid(long sessionId) throws SSessionNotFoundException {
        boolean isValid;
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), "isValid"));
        }
        SSession session = null;
        try {
            session = this.sessionProvider.getSession(sessionId);
        }
        catch (SSessionNotFoundException e) {
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.DEBUG)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.DEBUG, "Session with id '" + sessionId + "' is invalid because it does not exist.");
            }
            throw e;
        }
        Date now = new Date();
        boolean bl = isValid = session.getExpirationDate().getTime() > now.getTime();
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "isValid"));
        }
        return isValid;
    }

    @Override
    public SSession getSession(long sessionId) throws SSessionNotFoundException {
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), "getSession"));
        }
        SSession session = this.sessionProvider.getSession(sessionId);
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "getSession"));
        }
        return BuilderFactory.get(SSessionBuilderFactory.class).copy(session);
    }

    @Override
    public void setSessionDuration(long duration) {
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), "setSessionDuration"));
        }
        if (duration <= 0L) {
            throw new IllegalArgumentException("The duration must be greater then 0");
        }
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "setSessionDuration"));
        }
        this.sessionDuration = duration;
    }

    @Override
    public long getDefaultSessionDuration() {
        return 3600000L;
    }

    @Override
    public long getSessionDuration() {
        return this.sessionDuration;
    }

    @Override
    public void renewSession(long sessionId) throws SSessionException {
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), "renewSession"));
        }
        SSession session = this.getSession(sessionId);
        try {
            ClassReflector.invokeSetter(session, "setLastRenewDate", Date.class, new Date());
            this.sessionProvider.updateSession(session);
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "renewSession"));
            }
        }
        catch (Exception e) {
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), "renewSession", e));
            }
            throw new SSessionException(e);
        }
    }

    @Override
    public void cleanInvalidSessions() {
        this.sessionProvider.cleanInvalidSessions();
    }

    @Override
    public void deleteSessionsOfTenant(long tenantId) {
        this.sessionProvider.deleteSessionsOfTenant(tenantId);
    }

    @Override
    public void deleteSessions() {
        this.sessionProvider.removeSessions();
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, "Sessions were deleted.");
        }
    }
}

