/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.actor.mapping.persistence;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.bonitasoft.engine.actor.mapping.model.SActor;
import org.bonitasoft.engine.actor.mapping.model.SActorMember;
import org.bonitasoft.engine.persistence.OrderByType;
import org.bonitasoft.engine.persistence.PersistentObject;
import org.bonitasoft.engine.persistence.QueryOptions;
import org.bonitasoft.engine.persistence.SelectByIdDescriptor;
import org.bonitasoft.engine.persistence.SelectListDescriptor;
import org.bonitasoft.engine.persistence.SelectOneDescriptor;

public class SelectDescriptorBuilder {
    public static SelectByIdDescriptor<SActor> getActor(long actorId) {
        return new SelectByIdDescriptor<SActor>("getActorById", SActor.class, actorId);
    }

    public static SelectOneDescriptor<SActor> getActor(String actorName, long scopeId) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("name", actorName);
        parameters.put("scopeId", scopeId);
        return new SelectOneDescriptor<SActor>("getActorFromNameAndScopeId", parameters, SActor.class);
    }

    public static SelectByIdDescriptor<SActorMember> getActorMember(long actorMmeberId) {
        return new SelectByIdDescriptor<SActorMember>("getActorMemberById", SActorMember.class, actorMmeberId);
    }

    public static SelectListDescriptor<SActorMember> getActorMembers(int fromIndex, int numberOfElements) {
        QueryOptions queryOptions = new QueryOptions(fromIndex, numberOfElements, SActorMember.class, "id", OrderByType.ASC);
        Map<String, Object> parameters = Collections.emptyMap();
        return new SelectListDescriptor<SActorMember>("getActorMembers", parameters, SActorMember.class, queryOptions);
    }

    public static SelectListDescriptor<SActorMember> getActorMembers(long actorId, int fromIndex, int numberOfElements) {
        QueryOptions queryOptions = new QueryOptions(fromIndex, numberOfElements, SActorMember.class, "id", OrderByType.ASC);
        Map<String, Object> parameters = Collections.singletonMap("actorId", actorId);
        return new SelectListDescriptor<SActorMember>("getActorMembersOfActor", parameters, SActorMember.class, queryOptions);
    }

    public static SelectListDescriptor<SActorMember> getActorMembersOfGroup(long groupId) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("groupId", groupId);
        QueryOptions queryOptions = new QueryOptions(SActorMember.class, "id", OrderByType.ASC);
        return new SelectListDescriptor<SActorMember>("getActorMembersOfGroup", parameters, SActorMember.class, queryOptions);
    }

    public static SelectListDescriptor<SActorMember> getActorMembersOfRole(long roleId) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("roleId", roleId);
        QueryOptions queryOptions = new QueryOptions(SActorMember.class, "id", OrderByType.ASC);
        return new SelectListDescriptor<SActorMember>("getActorMembersOfRole", parameters, SActorMember.class, queryOptions);
    }

    public static SelectListDescriptor<SActorMember> getActorMembersOfUser(long userId) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("userId", userId);
        QueryOptions queryOptions = new QueryOptions(SActorMember.class, "id", OrderByType.ASC);
        return new SelectListDescriptor<SActorMember>("getActorMembersOfUser", parameters, SActorMember.class, queryOptions);
    }

    public static SelectListDescriptor<SActor> getActors(Set<Long> scopeIds) {
        Map<String, Object> parameters = Collections.singletonMap("scopeIds", scopeIds);
        QueryOptions queryOptions = new QueryOptions(SActor.class, "name", OrderByType.ASC);
        return new SelectListDescriptor<SActor>("getActorsOfScopes", parameters, SActor.class, queryOptions);
    }

    public static SelectListDescriptor<SActor> getActorsOfScope(long scopeId, int index, int numberPerPage, String field, OrderByType order) {
        Map<String, Object> parameters = Collections.singletonMap("scopeId", scopeId);
        QueryOptions queryOptions = new QueryOptions(index, numberPerPage, SActor.class, field, order);
        return new SelectListDescriptor<SActor>("getActorsOfScope", parameters, SActor.class, queryOptions);
    }

    public static SelectListDescriptor<SActor> getActorsOfUserCanStartProcessDefinition(long userId, long processDefinitionid) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("userId", userId);
        parameters.put("processDefinitionid", processDefinitionid);
        QueryOptions queryOptions = new QueryOptions(SActor.class, "name", OrderByType.ASC);
        return new SelectListDescriptor<SActor>("getActorsOfUserCanStartProcessDefinition", parameters, SActor.class, queryOptions);
    }

    public static <T extends PersistentObject> SelectListDescriptor<T> getElementsByIds(Class<T> clazz, String elementName, Collection<Long> ids) {
        Map<String, Object> parameters = Collections.singletonMap("ids", ids);
        return new SelectListDescriptor("get" + elementName + "sByIds", parameters, clazz);
    }

    public static SelectListDescriptor<SActor> getFullActorsListOfUser(Set<Long> scopeIds, long userId) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("scopeIds", scopeIds);
        parameters.put("userId", userId);
        QueryOptions queryOptions = new QueryOptions(SActor.class, "name", OrderByType.ASC);
        return new SelectListDescriptor<SActor>("getActorsOfUser", parameters, SActor.class, queryOptions);
    }

    public static SelectOneDescriptor<Long> getNumberOfActorMembers(long actorId) {
        Map<String, Object> parameters = Collections.singletonMap("actorId", actorId);
        return new SelectOneDescriptor<Long>("getNumberOfActorMembersOfActor", parameters, SActorMember.class);
    }

    public static SelectOneDescriptor<Long> getNumberOfActorMembersOfGroupWithActor(long groupId, long actorId) {
        HashMap<String, Object> parameters = new HashMap<String, Object>(2);
        parameters.put("groupId", groupId);
        parameters.put("actorId", actorId);
        return new SelectOneDescriptor<Long>("getNumberOfActorMembersOfGroupWithActor", parameters, SActorMember.class);
    }

    public static SelectOneDescriptor<Long> getNumberOfGroupsOfActor(long actorId) {
        Map<String, Object> parameters = Collections.singletonMap("actorId", actorId);
        return new SelectOneDescriptor<Long>("getNumberOfGroupsOfActor", parameters, SActorMember.class);
    }

    public static SelectOneDescriptor<Long> getNumberOfMembershipsOfActor(long actorId) {
        Map<String, Object> parameters = Collections.singletonMap("actorId", actorId);
        return new SelectOneDescriptor<Long>("getNumberOfMembershipsOfActor", parameters, SActorMember.class);
    }

    public static SelectOneDescriptor<Long> getNumberOfRolesOfActor(long actorId) {
        Map<String, Object> parameters = Collections.singletonMap("actorId", actorId);
        return new SelectOneDescriptor<Long>("getNumberOfRolesOfActor", parameters, SActorMember.class);
    }

    public static SelectOneDescriptor<Long> getNumberOfUsersOfActor(long actorId) {
        Map<String, Object> parameters = Collections.singletonMap("actorId", actorId);
        return new SelectOneDescriptor<Long>("getNumberOfUsersOfActor", parameters, SActorMember.class);
    }
}

