/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.api.impl.transaction.identity;

import java.util.List;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.commons.transaction.TransactionContentWithResult;
import org.bonitasoft.engine.identity.IdentityService;
import org.bonitasoft.engine.identity.model.SUser;
import org.bonitasoft.engine.persistence.OrderByType;

public class GetUsersInGroup
implements TransactionContentWithResult<List<SUser>> {
    private final long groupId;
    private final int startIndex;
    private final int maxResults;
    private final OrderByType orderExecutor;
    private final String fieldExecutor;
    private final IdentityService identityService;
    private List<SUser> userList;

    public GetUsersInGroup(long groupId, int startIndex, int maxResults, OrderByType orderExecutor, String fieldExecutor, IdentityService identityService) {
        this.groupId = groupId;
        this.startIndex = startIndex;
        this.maxResults = maxResults;
        this.orderExecutor = orderExecutor;
        this.fieldExecutor = fieldExecutor;
        this.identityService = identityService;
    }

    @Override
    public void execute() throws SBonitaException {
        this.userList = this.fieldExecutor == null ? this.identityService.getUsersByGroup(this.groupId, this.startIndex, this.maxResults) : this.identityService.getUsersByGroup(this.groupId, this.startIndex, this.maxResults, this.fieldExecutor, this.orderExecutor);
    }

    @Override
    public List<SUser> getResult() {
        return this.userList;
    }
}

