/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.api.impl.transaction.platform;

import java.util.List;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.commons.transaction.TransactionContent;
import org.bonitasoft.engine.persistence.OrderByType;
import org.bonitasoft.engine.persistence.QueryOptions;
import org.bonitasoft.engine.platform.PlatformService;
import org.bonitasoft.engine.platform.model.STenant;

public class DeleteAllTenants
implements TransactionContent {
    private final PlatformService platformService;

    public DeleteAllTenants(PlatformService platformService) {
        this.platformService = platformService;
    }

    @Override
    public void execute() throws SBonitaException {
        List<STenant> tenants;
        do {
            tenants = this.platformService.getTenants(new QueryOptions(0, 20, STenant.class, "id", OrderByType.ASC));
            for (STenant sTenant : tenants) {
                this.platformService.deactiveTenant(sTenant.getId());
                this.platformService.deleteTenant(sTenant.getId());
            }
        } while (tenants.size() > 0);
    }
}

