/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.core.operation.impl;

import org.bonitasoft.engine.core.expression.control.model.SExpressionContext;
import org.bonitasoft.engine.core.operation.OperationExecutorStrategy;
import org.bonitasoft.engine.core.operation.exception.SOperationExecutionException;
import org.bonitasoft.engine.core.operation.model.SOperation;

public class AssignmentOperationExecutorStrategy
implements OperationExecutorStrategy {
    public static final String TYPE_ASSIGNMENT = "ASSIGNMENT";

    @Override
    public Object computeNewValueForLeftOperand(SOperation operation, Object value, SExpressionContext expressionContext) throws SOperationExecutionException {
        if (operation.getLeftOperand().getType().equals("DATA")) {
            this.checkReturnType(value, operation, expressionContext);
        }
        return value;
    }

    private void checkReturnType(Object value, SOperation operation, SExpressionContext expressionContext) throws SOperationExecutionException {
        if (value != null) {
            Class<?> evaluatedReturnedType;
            Class<?> dataEffectiveType;
            String name = operation.getLeftOperand().getName();
            Object object = expressionContext.getInputValues().get(name);
            if (object != null && !(dataEffectiveType = object.getClass()).isAssignableFrom(evaluatedReturnedType = value.getClass()) && !dataEffectiveType.equals(evaluatedReturnedType)) {
                throw new SOperationExecutionException("Incompatible assignment operation type: Left operand " + dataEffectiveType + " is not compatible with right operand " + evaluatedReturnedType + " for expression with name '" + expressionContext + "'");
            }
        }
    }

    @Override
    public String getOperationType() {
        return TYPE_ASSIGNMENT;
    }
}

