/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.core.operation.impl;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.core.expression.control.api.ExpressionResolverService;
import org.bonitasoft.engine.core.expression.control.model.SExpressionContext;
import org.bonitasoft.engine.core.operation.LeftOperandHandler;
import org.bonitasoft.engine.core.operation.LeftOperandHandlerProvider;
import org.bonitasoft.engine.core.operation.OperationExecutorStrategy;
import org.bonitasoft.engine.core.operation.OperationExecutorStrategyProvider;
import org.bonitasoft.engine.core.operation.OperationService;
import org.bonitasoft.engine.core.operation.exception.SOperationExecutionException;
import org.bonitasoft.engine.core.operation.model.SLeftOperand;
import org.bonitasoft.engine.core.operation.model.SOperation;
import org.bonitasoft.engine.core.operation.model.SOperatorType;
import org.bonitasoft.engine.expression.model.SExpression;
import org.bonitasoft.engine.log.technical.TechnicalLogSeverity;
import org.bonitasoft.engine.log.technical.TechnicalLoggerService;
import org.bonitasoft.engine.persistence.SBonitaReadException;

public class OperationServiceImpl
implements OperationService {
    private final Map<String, LeftOperandHandler> leftOperandHandlersMap;
    private final ExpressionResolverService expressionResolverService;
    private final TechnicalLoggerService logger;
    private final OperationExecutorStrategyProvider operationExecutorStrategyProvider;

    public OperationServiceImpl(OperationExecutorStrategyProvider operationExecutorStrategyProvider, LeftOperandHandlerProvider leftOperandHandlerProvider, ExpressionResolverService expressionResolverService, TechnicalLoggerService logger) {
        this.operationExecutorStrategyProvider = operationExecutorStrategyProvider;
        this.expressionResolverService = expressionResolverService;
        this.logger = logger;
        List<LeftOperandHandler> leftOperandHandlers = leftOperandHandlerProvider.getLeftOperandHandlers();
        this.leftOperandHandlersMap = new HashMap<String, LeftOperandHandler>(leftOperandHandlers.size());
        for (LeftOperandHandler leftOperandHandler : leftOperandHandlers) {
            this.leftOperandHandlersMap.put(leftOperandHandler.getType(), leftOperandHandler);
        }
    }

    @Override
    public void execute(SOperation operation, long containerId, String containerType, SExpressionContext expressionContext) throws SOperationExecutionException {
        this.execute(Arrays.asList(operation), containerId, containerType, expressionContext);
    }

    @Override
    public void execute(List<SOperation> operations, SExpressionContext expressionContext) throws SOperationExecutionException {
        this.execute(operations, (long)expressionContext.getContainerId(), expressionContext.getContainerType(), expressionContext);
    }

    @Override
    public void execute(List<SOperation> operations, long leftOperandContainerId, String leftOperandContainerType, SExpressionContext expressionContext) throws SOperationExecutionException {
        this.retrieveLeftOperandsAndPutItInExpressionContextIfNotIn(operations, leftOperandContainerId, leftOperandContainerType, expressionContext);
        Map<SLeftOperand, Boolean> leftOperandUpdates = this.executeOperators(operations, expressionContext);
        this.updateLeftOperands(leftOperandUpdates, leftOperandContainerId, leftOperandContainerType, expressionContext);
    }

    Map<SLeftOperand, Boolean> executeOperators(List<SOperation> operations, SExpressionContext expressionContext) throws SOperationExecutionException {
        HashMap<SLeftOperand, Boolean> updateLeftOperands = new HashMap<SLeftOperand, Boolean>();
        for (SOperation operation : operations) {
            Boolean isAlreadyUpdated;
            boolean update;
            SLeftOperand leftOperand = operation.getLeftOperand();
            SOperatorType operatorType = operation.getType();
            boolean bl = update = operatorType != SOperatorType.DELETION;
            if (update) {
                Object rightOperandValue = this.getOperationValue(operation, expressionContext, operation.getRightOperand());
                OperationExecutorStrategy operationExecutorStrategy = this.operationExecutorStrategyProvider.getOperationExecutorStrategy(operation);
                Object value = operationExecutorStrategy.computeNewValueForLeftOperand(operation, rightOperandValue, expressionContext);
                expressionContext.getInputValues().put(leftOperand.getName(), value);
                this.logOperation(TechnicalLogSeverity.DEBUG, operation, rightOperandValue, expressionContext);
            }
            if ((isAlreadyUpdated = (Boolean)updateLeftOperands.get(leftOperand)) != null && (!isAlreadyUpdated.booleanValue() || update)) continue;
            updateLeftOperands.put(leftOperand, update);
        }
        return updateLeftOperands;
    }

    void updateLeftOperands(Map<SLeftOperand, Boolean> leftOperandUpdates, long leftOperandContainerId, String leftOperandContainerType, SExpressionContext expressionContext) throws SOperationExecutionException {
        for (Map.Entry<SLeftOperand, Boolean> update : leftOperandUpdates.entrySet()) {
            SLeftOperand leftOperand = update.getKey();
            LeftOperandHandler leftOperandHandler = this.getLeftOperandHandler(leftOperand);
            if (update.getValue().booleanValue()) {
                leftOperandHandler.update(leftOperand, expressionContext.getInputValues().get(leftOperand.getName()), leftOperandContainerId, leftOperandContainerType);
                continue;
            }
            leftOperandHandler.delete(leftOperand, leftOperandContainerId, leftOperandContainerType);
        }
    }

    private LeftOperandHandler getLeftOperandHandler(SLeftOperand leftOperand) throws SOperationExecutionException {
        LeftOperandHandler leftOperandHandler = this.leftOperandHandlersMap.get(leftOperand.getType());
        if (leftOperandHandler == null) {
            throw new SOperationExecutionException("Left operand type not found: " + leftOperand.getType());
        }
        return leftOperandHandler;
    }

    void retrieveLeftOperandsAndPutItInExpressionContextIfNotIn(List<SOperation> operations, long dataContainerId, String dataContainerType, SExpressionContext expressionContext) throws SOperationExecutionException {
        Map<String, Object> inputValues = expressionContext.getInputValues();
        for (SOperation operation : operations) {
            Object retrieve;
            if (operation.getType() != SOperatorType.JAVA_METHOD && operation.getType() != SOperatorType.XPATH_UPDATE_QUERY) continue;
            SLeftOperand leftOperand = operation.getLeftOperand();
            try {
                retrieve = this.getLeftOperandHandler(leftOperand).retrieve(leftOperand, new SExpressionContext(dataContainerId, dataContainerType, expressionContext.getInputValues()));
            }
            catch (SBonitaReadException e) {
                throw new SOperationExecutionException("Unable to retrieve value for operation " + operation, e);
            }
            this.putRetrievedValueInContextifNotNullAndNotAlreadyIn(inputValues, leftOperand, retrieve);
        }
    }

    protected void putRetrievedValueInContextifNotNullAndNotAlreadyIn(Map<String, Object> context, SLeftOperand leftOperand, Object retrieve) {
        if (retrieve != null && !context.containsKey(leftOperand.getName())) {
            context.put(leftOperand.getName(), retrieve);
        }
    }

    protected Object getOperationValue(SOperation operation, SExpressionContext expressionContext, SExpression sExpression) throws SOperationExecutionException {
        if (sExpression == null) {
            return null;
        }
        try {
            return this.expressionResolverService.evaluate(sExpression, expressionContext);
        }
        catch (ClassCastException e) {
            throw new SOperationExecutionException("Unable to execute operation on " + operation.getLeftOperand().getName() + " with a new value which is not Serializable", e);
        }
        catch (SBonitaException e) {
            throw new SOperationExecutionException(e);
        }
    }

    private void logOperation(TechnicalLogSeverity severity, SOperation operation, Object operationValue, SExpressionContext expressionContext) {
        if (this.logger.isLoggable(this.getClass(), severity)) {
            String message = this.buildLogMessage(operation, operationValue, expressionContext);
            this.logger.log(this.getClass(), severity, message);
        }
    }

    private String buildLogMessage(SOperation operation, Object operationValue, SExpressionContext expressionContext) {
        StringBuilder stb = new StringBuilder();
        stb.append("Executed operation on container [id: '");
        stb.append(expressionContext.getContainerId());
        stb.append("', type: '");
        stb.append(expressionContext.getContainerType());
        stb.append("']. Operation: [left operand: '");
        stb.append(operation.getLeftOperand().getName());
        stb.append("', operator: '");
        stb.append(operation.getOperator());
        stb.append("', operation value: '");
        stb.append(operationValue);
        stb.append("']");
        return stb.toString();
    }
}

