/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.core.process.definition;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bonitasoft.engine.bpm.process.ActivationState;
import org.bonitasoft.engine.bpm.process.ConfigurationState;
import org.bonitasoft.engine.bpm.process.ProcessDeploymentInfoCriterion;
import org.bonitasoft.engine.builder.BuilderFactory;
import org.bonitasoft.engine.cache.CacheService;
import org.bonitasoft.engine.cache.SCacheException;
import org.bonitasoft.engine.commons.ClassReflector;
import org.bonitasoft.engine.commons.NullCheckingUtil;
import org.bonitasoft.engine.commons.exceptions.SReflectException;
import org.bonitasoft.engine.core.process.definition.ProcessDefinitionService;
import org.bonitasoft.engine.core.process.definition.exception.SDeletingEnabledProcessException;
import org.bonitasoft.engine.core.process.definition.exception.SProcessDefinitionException;
import org.bonitasoft.engine.core.process.definition.exception.SProcessDefinitionNotFoundException;
import org.bonitasoft.engine.core.process.definition.exception.SProcessDefinitionReadException;
import org.bonitasoft.engine.core.process.definition.exception.SProcessDeletionException;
import org.bonitasoft.engine.core.process.definition.exception.SProcessDeploymentInfoUpdateException;
import org.bonitasoft.engine.core.process.definition.exception.SProcessDisablementException;
import org.bonitasoft.engine.core.process.definition.exception.SProcessEnablementException;
import org.bonitasoft.engine.core.process.definition.model.SFlowElementContainerDefinition;
import org.bonitasoft.engine.core.process.definition.model.SFlowNodeDefinition;
import org.bonitasoft.engine.core.process.definition.model.SProcessDefinition;
import org.bonitasoft.engine.core.process.definition.model.SProcessDefinitionDeployInfo;
import org.bonitasoft.engine.core.process.definition.model.STransitionDefinition;
import org.bonitasoft.engine.core.process.definition.model.builder.SProcessDefinitionBuilderFactory;
import org.bonitasoft.engine.core.process.definition.model.builder.SProcessDefinitionDeployInfoBuilderFactory;
import org.bonitasoft.engine.core.process.definition.model.builder.SProcessDefinitionLogBuilder;
import org.bonitasoft.engine.core.process.definition.model.builder.SProcessDefinitionLogBuilderFactory;
import org.bonitasoft.engine.dependency.DependencyService;
import org.bonitasoft.engine.dependency.SDependencyDeletionException;
import org.bonitasoft.engine.dependency.SDependencyException;
import org.bonitasoft.engine.dependency.SDependencyNotFoundException;
import org.bonitasoft.engine.dependency.model.ScopeType;
import org.bonitasoft.engine.events.EventActionType;
import org.bonitasoft.engine.events.EventService;
import org.bonitasoft.engine.events.model.SDeleteEvent;
import org.bonitasoft.engine.events.model.SInsertEvent;
import org.bonitasoft.engine.events.model.SUpdateEvent;
import org.bonitasoft.engine.events.model.builders.SEventBuilderFactory;
import org.bonitasoft.engine.exception.BonitaRuntimeException;
import org.bonitasoft.engine.home.BonitaHomeServer;
import org.bonitasoft.engine.identity.model.SUser;
import org.bonitasoft.engine.persistence.OrderByOption;
import org.bonitasoft.engine.persistence.OrderByType;
import org.bonitasoft.engine.persistence.PersistentObject;
import org.bonitasoft.engine.persistence.QueryOptions;
import org.bonitasoft.engine.persistence.ReadPersistenceService;
import org.bonitasoft.engine.persistence.SBonitaReadException;
import org.bonitasoft.engine.persistence.SBonitaSearchException;
import org.bonitasoft.engine.persistence.SelectListDescriptor;
import org.bonitasoft.engine.persistence.SelectOneDescriptor;
import org.bonitasoft.engine.queriablelogger.model.SQueriableLog;
import org.bonitasoft.engine.queriablelogger.model.SQueriableLogSeverity;
import org.bonitasoft.engine.queriablelogger.model.builder.ActionType;
import org.bonitasoft.engine.queriablelogger.model.builder.HasCRUDEAction;
import org.bonitasoft.engine.queriablelogger.model.builder.SLogBuilder;
import org.bonitasoft.engine.queriablelogger.model.builder.SPersistenceLogBuilder;
import org.bonitasoft.engine.recorder.Recorder;
import org.bonitasoft.engine.recorder.SRecorderException;
import org.bonitasoft.engine.recorder.model.DeleteRecord;
import org.bonitasoft.engine.recorder.model.EntityUpdateDescriptor;
import org.bonitasoft.engine.recorder.model.InsertRecord;
import org.bonitasoft.engine.recorder.model.UpdateRecord;
import org.bonitasoft.engine.services.QueriableLoggerService;
import org.bonitasoft.engine.session.SSessionNotFoundException;
import org.bonitasoft.engine.session.SessionService;
import org.bonitasoft.engine.session.model.SSession;
import org.bonitasoft.engine.sessionaccessor.ReadSessionAccessor;
import org.bonitasoft.engine.sessionaccessor.SessionIdNotSetException;
import org.bonitasoft.engine.xml.ElementBindingsFactory;
import org.bonitasoft.engine.xml.Parser;
import org.bonitasoft.engine.xml.ParserFactory;
import org.bonitasoft.engine.xml.XMLWriter;

public class ProcessDefinitionServiceImpl
implements ProcessDefinitionService {
    private static final String SERVER_PROCESS_DEFINITION_XML = "server-process-definition.xml";
    private final CacheService cacheService;
    private final Recorder recorder;
    private final ReadPersistenceService persistenceService;
    private final EventService eventService;
    private final SessionService sessionService;
    private final ReadSessionAccessor sessionAccessor;
    private final Parser parser;
    private final XMLWriter xmlWriter;
    private final QueriableLoggerService queriableLoggerService;
    private final DependencyService dependencyService;

    public ProcessDefinitionServiceImpl(CacheService cacheService, Recorder recorder, ReadPersistenceService persistenceService, EventService eventService, SessionService sessionService, ReadSessionAccessor sessionAccessor, ParserFactory parserFactory, XMLWriter xmlWriter, QueriableLoggerService queriableLoggerService, DependencyService dependencyService) {
        this.cacheService = cacheService;
        this.recorder = recorder;
        this.persistenceService = persistenceService;
        this.eventService = eventService;
        this.sessionService = sessionService;
        this.sessionAccessor = sessionAccessor;
        this.xmlWriter = xmlWriter;
        this.queriableLoggerService = queriableLoggerService;
        this.dependencyService = dependencyService;
        ElementBindingsFactory bindings = BuilderFactory.get(SProcessDefinitionBuilderFactory.class).getElementsBindings();
        this.parser = parserFactory.createParser(bindings);
        InputStream schemaStream = BuilderFactory.get(SProcessDefinitionBuilderFactory.class).getModelSchema();
        try {
            this.parser.setSchema(schemaStream);
        }
        catch (Exception e) {
            throw new BonitaRuntimeException("Unable to configure process definition service", (Throwable)e);
        }
    }

    @Override
    public void delete(long processId) throws SProcessDefinitionNotFoundException, SProcessDeletionException, SDeletingEnabledProcessException {
        SProcessDefinitionDeployInfo processDefinitionDeployInfo;
        SProcessDefinitionLogBuilder logBuilder = this.getQueriableLog(ActionType.DELETED, "Deleting a Process definition");
        try {
            processDefinitionDeployInfo = this.getProcessDeploymentInfo(processId);
            if (ActivationState.ENABLED.name().equals(processDefinitionDeployInfo.getActivationState())) {
                throw new SDeletingEnabledProcessException("Process is enabled.", processDefinitionDeployInfo);
            }
        }
        catch (SProcessDefinitionReadException e) {
            this.initiateLogBuilder(processId, 0, logBuilder, "delete");
            throw new SProcessDeletionException((Throwable)e, processId);
        }
        try {
            this.cacheService.remove("_PROCESSDEF", processId);
            SDeleteEvent deleteEvent = null;
            if (this.eventService.hasHandlers("PROCESSDEFINITION", EventActionType.DELETED)) {
                deleteEvent = (SDeleteEvent)BuilderFactory.get(SEventBuilderFactory.class).createDeleteEvent("PROCESSDEFINITION").setObject(processDefinitionDeployInfo).done();
            }
            DeleteRecord deleteRecord = new DeleteRecord(processDefinitionDeployInfo);
            this.recorder.recordDelete(deleteRecord, deleteEvent);
            this.initiateLogBuilder(processId, 1, logBuilder, "delete");
            this.dependencyService.deleteDependencies(processId, ScopeType.PROCESS);
        }
        catch (SCacheException e) {
            this.initiateLogBuilder(processId, 0, logBuilder, "delete");
            throw new SProcessDefinitionNotFoundException((Throwable)e, processDefinitionDeployInfo);
        }
        catch (SRecorderException e) {
            this.initiateLogBuilder(processId, 0, logBuilder, "delete");
            throw new SProcessDeletionException((Throwable)e, processDefinitionDeployInfo);
        }
        catch (SDependencyNotFoundException e) {
            this.initiateLogBuilder(processId, 0, logBuilder, "delete");
            throw new SProcessDeletionException((Throwable)e, processDefinitionDeployInfo);
        }
        catch (SDependencyDeletionException e) {
            this.initiateLogBuilder(processId, 0, logBuilder, "delete");
            throw new SProcessDeletionException((Throwable)e, processDefinitionDeployInfo);
        }
        catch (SDependencyException e) {
            this.initiateLogBuilder(processId, 0, logBuilder, "delete");
            throw new SProcessDeletionException((Throwable)e, processDefinitionDeployInfo);
        }
    }

    @Override
    public void disableProcessDeploymentInfo(long processId) throws SProcessDefinitionNotFoundException, SProcessDisablementException {
        SProcessDefinitionDeployInfo processDefinitionDeployInfo;
        try {
            processDefinitionDeployInfo = this.getProcessDeploymentInfo(processId);
        }
        catch (SProcessDefinitionReadException e) {
            throw new SProcessDisablementException(e);
        }
        if (ActivationState.DISABLED.name().equals(processDefinitionDeployInfo.getActivationState())) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Process ");
            stringBuilder.append(processDefinitionDeployInfo.getName());
            stringBuilder.append(" with version ");
            stringBuilder.append(processDefinitionDeployInfo.getVersion());
            stringBuilder.append(" is already disabled");
            throw new SProcessDisablementException(stringBuilder.toString());
        }
        EntityUpdateDescriptor descriptor = new EntityUpdateDescriptor();
        descriptor.addField(BuilderFactory.get(SProcessDefinitionDeployInfoBuilderFactory.class).getActivationStateKey(), ActivationState.DISABLED.name());
        UpdateRecord updateRecord = this.getUpdateRecord(descriptor, processDefinitionDeployInfo);
        SProcessDefinitionLogBuilder logBuilder = this.getQueriableLog(ActionType.UPDATED, "Disabling the process");
        SUpdateEvent updateEvent = null;
        if (this.eventService.hasHandlers("PROCESSDEFINITION_IS_DISABLED", EventActionType.UPDATED)) {
            updateEvent = (SUpdateEvent)BuilderFactory.get(SEventBuilderFactory.class).createUpdateEvent("PROCESSDEFINITION_IS_DISABLED").setObject(processDefinitionDeployInfo).done();
        }
        try {
            this.recorder.recordUpdate(updateRecord, updateEvent);
            this.initiateLogBuilder(processDefinitionDeployInfo.getId(), 1, logBuilder, "disableProcess");
        }
        catch (SRecorderException e) {
            this.initiateLogBuilder(processDefinitionDeployInfo.getId(), 0, logBuilder, "disableProcess");
            throw new SProcessDisablementException(e);
        }
    }

    @Override
    public void enableProcessDeploymentInfo(long processId) throws SProcessDefinitionNotFoundException, SProcessEnablementException {
        SProcessDefinitionDeployInfo processDefinitionDeployInfo;
        try {
            processDefinitionDeployInfo = this.getProcessDeploymentInfo(processId);
        }
        catch (SProcessDefinitionReadException e) {
            throw new SProcessEnablementException(e);
        }
        if (ActivationState.ENABLED.name().equals(processDefinitionDeployInfo.getActivationState())) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Process ");
            stringBuilder.append(processDefinitionDeployInfo.getName());
            stringBuilder.append(" with version ");
            stringBuilder.append(processDefinitionDeployInfo.getVersion());
            stringBuilder.append(" is already enabled");
            throw new SProcessEnablementException(stringBuilder.toString());
        }
        if (ConfigurationState.UNRESOLVED.name().equals(processDefinitionDeployInfo.getConfigurationState())) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Process ");
            stringBuilder.append(processDefinitionDeployInfo.getName());
            stringBuilder.append(" with version ");
            stringBuilder.append(processDefinitionDeployInfo.getVersion());
            stringBuilder.append(" can't be enabled since all dependencies are not resolved yet");
            throw new SProcessEnablementException(stringBuilder.toString());
        }
        EntityUpdateDescriptor descriptor = new EntityUpdateDescriptor();
        descriptor.addField(BuilderFactory.get(SProcessDefinitionDeployInfoBuilderFactory.class).getActivationStateKey(), ActivationState.ENABLED.name());
        UpdateRecord updateRecord = this.getUpdateRecord(descriptor, processDefinitionDeployInfo);
        SProcessDefinitionLogBuilder logBuilder = this.getQueriableLog(ActionType.UPDATED, "Enabling the process");
        SUpdateEvent updateEvent = null;
        if (this.eventService.hasHandlers("PROCESSDEFINITION_IS_ENABLED", EventActionType.UPDATED)) {
            updateEvent = (SUpdateEvent)BuilderFactory.get(SEventBuilderFactory.class).createUpdateEvent("PROCESSDEFINITION_IS_ENABLED").setObject(processDefinitionDeployInfo).done();
        }
        try {
            this.recorder.recordUpdate(updateRecord, updateEvent);
            this.initiateLogBuilder(processId, 1, logBuilder, "enableProcess");
        }
        catch (SRecorderException e) {
            this.initiateLogBuilder(processId, 0, logBuilder, "enableProcess");
            throw new SProcessEnablementException(e);
        }
    }

    private SProcessDefinitionLogBuilder getQueriableLog(ActionType actionType, String message) {
        SProcessDefinitionLogBuilder logBuilder = BuilderFactory.get(SProcessDefinitionLogBuilderFactory.class).createNewInstance();
        this.initializeLogBuilder(logBuilder, message);
        this.updateLog(actionType, logBuilder);
        return logBuilder;
    }

    @Override
    public List<SProcessDefinitionDeployInfo> getProcessDeploymentInfos(int fromIndex, int numberPerPage, String field, OrderByType order) throws SProcessDefinitionReadException {
        try {
            Map<String, Object> emptyMap = Collections.emptyMap();
            return this.persistenceService.selectList(new SelectListDescriptor("", emptyMap, SProcessDefinitionDeployInfo.class, new QueryOptions(fromIndex, numberPerPage, SProcessDefinitionDeployInfo.class, field, order)));
        }
        catch (SBonitaReadException e) {
            throw new SProcessDefinitionReadException(e);
        }
    }

    @Override
    public long getNumberOfProcessDeploymentInfos() throws SProcessDefinitionReadException {
        Map<String, Object> parameters = Collections.emptyMap();
        SelectOneDescriptor selectDescriptor = new SelectOneDescriptor("getNumberOfProcessDefinitions", parameters, SProcessDefinitionDeployInfo.class);
        try {
            return (Long)this.persistenceService.selectOne(selectDescriptor);
        }
        catch (SBonitaReadException bre) {
            throw new SProcessDefinitionReadException(bre);
        }
    }

    @Override
    public SProcessDefinition getProcessDefinition(long processId) throws SProcessDefinitionNotFoundException, SProcessDefinitionReadException {
        try {
            long tenantId = this.sessionAccessor.getTenantId();
            SProcessDefinition sProcessDefinition = null;
            sProcessDefinition = (SProcessDefinition)this.cacheService.get("_PROCESSDEF", processId);
            if (sProcessDefinition == null) {
                this.getProcessDeploymentInfo(processId);
                String processesFolder = BonitaHomeServer.getInstance().getProcessesFolder(tenantId);
                File processFolder = new File(processesFolder, String.valueOf(processId));
                File xmlFile = new File(processFolder, SERVER_PROCESS_DEFINITION_XML);
                this.parser.validate(xmlFile);
                sProcessDefinition = (SProcessDefinition)this.parser.getObjectFromXML(xmlFile);
                this.storeProcessDefinition(processId, sProcessDefinition);
            }
            return sProcessDefinition;
        }
        catch (SCacheException e) {
            throw new SProcessDefinitionNotFoundException((Throwable)e, processId);
        }
        catch (SProcessDefinitionNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SProcessDefinitionReadException(e);
        }
    }

    private long setIdOnProcessDefinition(SProcessDefinition sProcessDefinition) throws SReflectException {
        long id = this.generateId();
        ClassReflector.invokeSetter(sProcessDefinition, "setId", Long.class, id);
        return id;
    }

    protected long generateId() {
        return Math.abs(UUID.randomUUID().getLeastSignificantBits());
    }

    private void storeProcessDefinition(Long id, SProcessDefinition sProcessDefinition) throws SCacheException {
        this.cacheService.store("_PROCESSDEF", id, sProcessDefinition);
    }

    @Override
    public SProcessDefinitionDeployInfo getProcessDeploymentInfo(long processId) throws SProcessDefinitionNotFoundException, SProcessDefinitionReadException {
        try {
            Map<String, Object> parameters = Collections.singletonMap("processId", processId);
            SelectOneDescriptor descriptor = new SelectOneDescriptor("getDeployInfoByProcessDefId", parameters, SProcessDefinitionDeployInfo.class);
            SProcessDefinitionDeployInfo processDefinitionDeployInfo = (SProcessDefinitionDeployInfo)this.persistenceService.selectOne(descriptor);
            if (processDefinitionDeployInfo == null) {
                throw new SProcessDefinitionNotFoundException("Unable to find the process definition deployment info.", processId);
            }
            return processDefinitionDeployInfo;
        }
        catch (SBonitaReadException e) {
            throw new SProcessDefinitionReadException(e);
        }
    }

    private <T extends SLogBuilder> void initializeLogBuilder(T logBuilder, String message) {
        logBuilder.actionStatus(0).severity(SQueriableLogSeverity.INTERNAL).rawMessage(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SProcessDefinition store(SProcessDefinition definition, String displayName, String displayDescription) throws SProcessDefinitionException {
        NullCheckingUtil.checkArgsNotNull(definition);
        SProcessDefinitionLogBuilder logBuilder = this.getQueriableLog(ActionType.CREATED, "Creating a new Process definition");
        try {
            SSession session = this.getSession();
            long tenantId = this.sessionAccessor.getTenantId();
            long processId = this.setIdOnProcessDefinition(definition);
            String processesFolder = BonitaHomeServer.getInstance().getProcessesFolder(tenantId);
            File processFolder = new File(processesFolder, String.valueOf(processId));
            if (!processFolder.exists()) {
                processFolder.mkdirs();
                processFolder.mkdir();
            }
            FileOutputStream outputStream = new FileOutputStream(new File(processFolder, SERVER_PROCESS_DEFINITION_XML));
            try {
                this.xmlWriter.write(BuilderFactory.get(SProcessDefinitionBuilderFactory.class).getXMLProcessDefinition(definition), outputStream);
            }
            finally {
                outputStream.close();
            }
            if (displayName == null || displayName.isEmpty()) {
                displayName = definition.getName();
            }
            if (displayDescription == null || displayDescription.isEmpty()) {
                displayDescription = definition.getDescription();
            }
            SProcessDefinitionDeployInfo definitionDeployInfo = BuilderFactory.get(SProcessDefinitionDeployInfoBuilderFactory.class).createNewInstance(definition.getName(), definition.getVersion()).setProcessId(processId).setDescription(definition.getDescription()).setDeployedBy(session.getUserId()).setDeploymentDate(System.currentTimeMillis()).setActivationState(ActivationState.DISABLED.name()).setConfigurationState(ConfigurationState.UNRESOLVED.name()).setDisplayName(displayName).setDisplayDescription(displayDescription).done();
            InsertRecord record = new InsertRecord(definitionDeployInfo);
            SInsertEvent insertEvent = null;
            if (this.eventService.hasHandlers("PROCESSDEFINITION", EventActionType.CREATED)) {
                insertEvent = (SInsertEvent)BuilderFactory.get(SEventBuilderFactory.class).createInsertEvent("PROCESSDEFINITION").setObject(definitionDeployInfo).done();
            }
            this.recorder.recordInsert(record, insertEvent);
            this.initiateLogBuilder(definition.getId(), 1, logBuilder, "store");
        }
        catch (SRecorderException e) {
            this.initiateLogBuilder(definition.getId(), 0, logBuilder, "store");
            throw new SProcessDefinitionException(e);
        }
        catch (Exception e) {
            this.initiateLogBuilder(definition.getId(), 0, logBuilder, "store");
            throw new SProcessDefinitionException(e);
        }
        return definition;
    }

    private SSession getSession() throws SSessionNotFoundException {
        long sessionId;
        try {
            sessionId = this.sessionAccessor.getSessionId();
        }
        catch (SessionIdNotSetException e) {
            return null;
        }
        return this.sessionService.getSession(sessionId);
    }

    private <T extends HasCRUDEAction> void updateLog(ActionType actionType, T logBuilder) {
        logBuilder.setActionType(actionType);
    }

    @Override
    public void resolveProcess(long processId) throws SProcessDefinitionNotFoundException, SProcessDisablementException {
        SProcessDefinitionDeployInfo processDefinitionDeployInfo;
        try {
            processDefinitionDeployInfo = this.getProcessDeploymentInfo(processId);
        }
        catch (SProcessDefinitionReadException e) {
            throw new SProcessDisablementException(e);
        }
        if (!ConfigurationState.UNRESOLVED.name().equals(processDefinitionDeployInfo.getConfigurationState())) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Process ");
            stringBuilder.append(processDefinitionDeployInfo.getName());
            stringBuilder.append(" with version");
            stringBuilder.append(processDefinitionDeployInfo.getVersion());
            stringBuilder.append(" is not unresolved");
            throw new SProcessDisablementException(stringBuilder.toString());
        }
        EntityUpdateDescriptor descriptor = new EntityUpdateDescriptor();
        descriptor.addField(BuilderFactory.get(SProcessDefinitionDeployInfoBuilderFactory.class).getConfigurationStateKey(), ConfigurationState.RESOLVED.name());
        UpdateRecord updateRecord = this.getUpdateRecord(descriptor, processDefinitionDeployInfo);
        SProcessDefinitionLogBuilder logBuilder = this.getQueriableLog(ActionType.UPDATED, "Resolved the process");
        SUpdateEvent updateEvent = null;
        if (this.eventService.hasHandlers("PROCESSDEFINITION_IS_RESOLVED", EventActionType.UPDATED)) {
            updateEvent = (SUpdateEvent)BuilderFactory.get(SEventBuilderFactory.class).createUpdateEvent("PROCESSDEFINITION_IS_RESOLVED").setObject(processDefinitionDeployInfo).done();
        }
        try {
            this.recorder.recordUpdate(updateRecord, updateEvent);
            this.initiateLogBuilder(processDefinitionDeployInfo.getId(), 1, logBuilder, "resolveProcess");
        }
        catch (SRecorderException e) {
            this.initiateLogBuilder(processDefinitionDeployInfo.getId(), 0, logBuilder, "resolveProcess");
            throw new SProcessDisablementException(e);
        }
    }

    @Override
    public long getNumberOfProcessDeploymentInfo(ActivationState activationState) throws SProcessDefinitionReadException {
        Map<String, Object> parameters = Collections.singletonMap("activationState", activationState.name());
        SelectOneDescriptor selectDescriptor = new SelectOneDescriptor("getNumberOfProcessDefinitionsInActivationState", parameters, SProcessDefinitionDeployInfo.class);
        try {
            return (Long)this.persistenceService.selectOne(selectDescriptor);
        }
        catch (SBonitaReadException e) {
            throw new SProcessDefinitionReadException(e);
        }
    }

    @Override
    public List<Long> getProcessDefinitionIds(ActivationState activationState, int fromIndex, int numberOfResults) throws SProcessDefinitionReadException {
        Map<String, Object> parameters = Collections.singletonMap("activationState", activationState.name());
        List<OrderByOption> orderByOptions = Arrays.asList(new OrderByOption(SProcessDefinitionDeployInfo.class, "id", OrderByType.ASC));
        SelectListDescriptor selectDescriptor = new SelectListDescriptor("getProcessDefinitionsIdsInActivationState", parameters, SProcessDefinitionDeployInfo.class, new QueryOptions(fromIndex, numberOfResults, orderByOptions));
        try {
            return this.persistenceService.selectList(selectDescriptor);
        }
        catch (SBonitaReadException e) {
            throw new SProcessDefinitionReadException(e);
        }
    }

    @Override
    public List<Long> getProcessDefinitionIds(int fromIndex, int numberOfResults) throws SProcessDefinitionReadException {
        Map<String, Object> parameters = Collections.emptyMap();
        List<OrderByOption> orderByOptions = Arrays.asList(new OrderByOption(SProcessDefinitionDeployInfo.class, "id", OrderByType.ASC));
        SelectListDescriptor selectDescriptor = new SelectListDescriptor("getProcessDefinitionsIds", parameters, SProcessDefinitionDeployInfo.class, new QueryOptions(fromIndex, numberOfResults, orderByOptions));
        try {
            return this.persistenceService.selectList(selectDescriptor);
        }
        catch (SBonitaReadException e) {
            throw new SProcessDefinitionReadException(e);
        }
    }

    @Override
    public SFlowNodeDefinition getNextFlowNode(SProcessDefinition definition, String source) {
        SFlowElementContainerDefinition processContainer = definition.getProcessContainer();
        STransitionDefinition sourceNode = processContainer.getTransition(source);
        long targetId = sourceNode.getTarget();
        return processContainer.getFlowNode(targetId);
    }

    @Override
    public List<SProcessDefinitionDeployInfo> getProcessDeploymentInfos(List<Long> processIds, int fromIndex, int numberOfProcesses, String field, OrderByType order) throws SProcessDefinitionReadException {
        if (processIds == null || processIds.size() == 0) {
            return Collections.emptyList();
        }
        try {
            Map<String, Object> emptyMap = Collections.singletonMap("processIds", processIds);
            QueryOptions queryOptions = new QueryOptions(fromIndex, numberOfProcesses, SProcessDefinitionDeployInfo.class, field, order);
            List<SProcessDefinitionDeployInfo> results = this.persistenceService.selectList(new SelectListDescriptor("getSubSetOfProcessDefinitionDeployInfos", emptyMap, SProcessDefinitionDeployInfo.class, queryOptions));
            return results;
        }
        catch (SBonitaReadException e) {
            throw new SProcessDefinitionReadException(e);
        }
    }

    @Override
    public List<SProcessDefinitionDeployInfo> getProcessDeploymentInfos(List<Long> processIds) throws SProcessDefinitionReadException {
        if (processIds == null || processIds.size() == 0) {
            return Collections.emptyList();
        }
        try {
            Map<String, Object> emptyMap = Collections.singletonMap("processIds", processIds);
            return this.persistenceService.selectList(new SelectListDescriptor("getSubSetOfProcessDefinitionDeployInfos", emptyMap, SProcessDefinitionDeployInfo.class));
        }
        catch (SBonitaReadException e) {
            throw new SProcessDefinitionReadException(e);
        }
    }

    @Override
    public long getLatestProcessDefinitionId(String processName) throws SProcessDefinitionReadException {
        return this.getProcessDeploymentInfosByTimeDesc(processName).get(0).getProcessId();
    }

    private List<SProcessDefinitionDeployInfo> getProcessDeploymentInfosByTimeDesc(String processName) throws SProcessDefinitionReadException {
        try {
            Map<String, Object> parameters = Collections.singletonMap("name", processName);
            SelectListDescriptor selectDescriptor = new SelectListDescriptor("getProcessDefinitionDeployInfosByTimeDesc", parameters, SProcessDefinitionDeployInfo.class);
            List<SProcessDefinitionDeployInfo> processDefinitionDeployInfos = this.persistenceService.selectList(selectDescriptor);
            if (processDefinitionDeployInfos != null && processDefinitionDeployInfos.size() > 0) {
                return processDefinitionDeployInfos;
            }
            SProcessDefinitionReadException exception = new SProcessDefinitionReadException("Unable to find the process definition deployment info.");
            exception.setProcessDefinitionNameOnContext(processName);
            throw exception;
        }
        catch (SBonitaReadException e) {
            throw new SProcessDefinitionReadException(e);
        }
    }

    @Override
    public long getProcessDefinitionId(String name, String version) throws SProcessDefinitionReadException {
        try {
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            parameters.put("name", name);
            parameters.put("version", version);
            Long processDefId = this.persistenceService.selectOne(new SelectOneDescriptor<Long>("getProcessDefinitionIdByNameAndVersion", parameters, SProcessDefinitionDeployInfo.class, Long.class));
            if (processDefId != null) {
                return processDefId;
            }
            SProcessDefinitionReadException exception = new SProcessDefinitionReadException("Process definition id not found.");
            exception.setProcessDefinitionNameOnContext(name);
            exception.setProcessDefinitionVersionOnContext(version);
            throw exception;
        }
        catch (SBonitaReadException e) {
            throw new SProcessDefinitionReadException(e);
        }
    }

    @Override
    public void updateProcessDefinitionDeployInfo(long processId, EntityUpdateDescriptor descriptor) throws SProcessDefinitionNotFoundException, SProcessDeploymentInfoUpdateException {
        SProcessDefinitionDeployInfo processDefinitionDeployInfo;
        try {
            processDefinitionDeployInfo = this.getProcessDeploymentInfo(processId);
        }
        catch (SProcessDefinitionReadException e) {
            throw new SProcessDefinitionNotFoundException((Throwable)e, processId);
        }
        SProcessDefinitionLogBuilder logBuilder = this.getQueriableLog(ActionType.UPDATED, "Updating a processDefinitionDeployInfo");
        UpdateRecord updateRecord = this.getUpdateRecord(descriptor, processDefinitionDeployInfo);
        SUpdateEvent updateEvent = null;
        if (this.eventService.hasHandlers("PROCESSDEFINITION_DEPLOY_INFO", EventActionType.UPDATED)) {
            updateEvent = (SUpdateEvent)BuilderFactory.get(SEventBuilderFactory.class).createUpdateEvent("PROCESSDEFINITION_DEPLOY_INFO").setObject(processDefinitionDeployInfo).done();
        }
        try {
            this.recorder.recordUpdate(updateRecord, updateEvent);
            this.initiateLogBuilder(processId, 1, logBuilder, "updateProcessDeploymentInfo");
        }
        catch (SRecorderException e) {
            this.initiateLogBuilder(processId, 0, logBuilder, "updateProcessDeploymentInfo");
            throw new SProcessDeploymentInfoUpdateException(e);
        }
    }

    private UpdateRecord getUpdateRecord(EntityUpdateDescriptor descriptor, SProcessDefinitionDeployInfo processDefinitionDeployInfo) {
        long now = System.currentTimeMillis();
        descriptor.addField(BuilderFactory.get(SProcessDefinitionDeployInfoBuilderFactory.class).getLastUpdateDateKey(), now);
        return UpdateRecord.buildSetFields((PersistentObject)processDefinitionDeployInfo, descriptor);
    }

    @Override
    public List<SProcessDefinitionDeployInfo> searchProcessDeploymentInfosStartedBy(long startedBy, QueryOptions searchOptions) throws SBonitaSearchException {
        try {
            Map<String, Object> parameters = Collections.singletonMap("startedBy", startedBy);
            return this.persistenceService.searchEntity(SProcessDefinitionDeployInfo.class, "StartedBy", searchOptions, parameters);
        }
        catch (SBonitaReadException bre) {
            throw new SBonitaSearchException(bre);
        }
    }

    @Override
    public long getNumberOfProcessDeploymentInfosStartedBy(long startedBy, QueryOptions countOptions) throws SBonitaSearchException {
        try {
            Map<String, Object> parameters = Collections.singletonMap("startedBy", startedBy);
            return this.persistenceService.getNumberOfEntities(SProcessDefinitionDeployInfo.class, "StartedBy", countOptions, parameters);
        }
        catch (SBonitaReadException bre) {
            throw new SBonitaSearchException(bre);
        }
    }

    @Override
    public List<SProcessDefinitionDeployInfo> searchProcessDeploymentInfos(QueryOptions searchOptions) throws SBonitaSearchException {
        try {
            return this.persistenceService.searchEntity(SProcessDefinitionDeployInfo.class, searchOptions, null);
        }
        catch (SBonitaReadException bre) {
            throw new SBonitaSearchException(bre);
        }
    }

    @Override
    public long getNumberOfProcessDeploymentInfos(QueryOptions countOptions) throws SBonitaSearchException {
        try {
            return this.persistenceService.getNumberOfEntities(SProcessDefinitionDeployInfo.class, countOptions, null);
        }
        catch (SBonitaReadException bre) {
            throw new SBonitaSearchException(bre);
        }
    }

    @Override
    public List<SProcessDefinitionDeployInfo> searchProcessDeploymentInfos(long userId, QueryOptions searchOptions) throws SBonitaSearchException {
        try {
            return this.persistenceService.searchEntity(SProcessDefinitionDeployInfo.class, "UserCanStart", searchOptions, Collections.singletonMap("userId", userId));
        }
        catch (SBonitaReadException bre) {
            throw new SBonitaSearchException(bre);
        }
    }

    @Override
    public long getNumberOfProcessDeploymentInfos(long userId, QueryOptions countOptions) throws SBonitaSearchException {
        try {
            return this.persistenceService.getNumberOfEntities(SProcessDefinitionDeployInfo.class, "UserCanStart", countOptions, Collections.singletonMap("userId", userId));
        }
        catch (SBonitaReadException bre) {
            throw new SBonitaSearchException(bre);
        }
    }

    @Override
    public List<SProcessDefinitionDeployInfo> searchProcessDeploymentInfosUsersManagedByCanStart(long managerUserId, QueryOptions searchOptions) throws SBonitaSearchException {
        try {
            return this.persistenceService.searchEntity(SProcessDefinitionDeployInfo.class, "UsersManagedByCanStart", searchOptions, Collections.singletonMap("managerUserId", managerUserId));
        }
        catch (SBonitaReadException bre) {
            throw new SBonitaSearchException(bre);
        }
    }

    @Override
    public long getNumberOfProcessDeploymentInfosUsersManagedByCanStart(long managerUserId, QueryOptions countOptions) throws SBonitaSearchException {
        try {
            return this.persistenceService.getNumberOfEntities(SProcessDefinitionDeployInfo.class, "UsersManagedByCanStart", countOptions, Collections.singletonMap("managerUserId", managerUserId));
        }
        catch (SBonitaReadException bre) {
            throw new SBonitaSearchException(bre);
        }
    }

    @Override
    public List<SProcessDefinitionDeployInfo> searchProcessDeploymentInfos(long userId, QueryOptions searchOptions, String querySuffix) throws SBonitaSearchException {
        try {
            return this.persistenceService.searchEntity(SProcessDefinitionDeployInfo.class, querySuffix, searchOptions, Collections.singletonMap("userId", userId));
        }
        catch (SBonitaReadException bre) {
            throw new SBonitaSearchException(bre);
        }
    }

    @Override
    public long getNumberOfProcessDeploymentInfos(long userId, QueryOptions countOptions, String querySuffix) throws SBonitaSearchException {
        try {
            return this.persistenceService.getNumberOfEntities(SProcessDefinitionDeployInfo.class, querySuffix, countOptions, Collections.singletonMap("userId", userId));
        }
        catch (SBonitaReadException bre) {
            throw new SBonitaSearchException(bre);
        }
    }

    @Override
    public long getNumberOfUncategorizedProcessDeploymentInfos(QueryOptions countOptions) throws SBonitaSearchException {
        try {
            return this.persistenceService.getNumberOfEntities(SProcessDefinitionDeployInfo.class, "Uncategorized", countOptions, null);
        }
        catch (SBonitaReadException bre) {
            throw new SBonitaSearchException(bre);
        }
    }

    @Override
    public List<SProcessDefinitionDeployInfo> searchUncategorizedProcessDeploymentInfos(QueryOptions searchOptions) throws SBonitaSearchException {
        try {
            return this.persistenceService.searchEntity(SProcessDefinitionDeployInfo.class, "Uncategorized", searchOptions, null);
        }
        catch (SBonitaReadException bre) {
            throw new SBonitaSearchException(bre);
        }
    }

    @Override
    public long getNumberOfUncategorizedProcessDeploymentInfosSupervisedBy(long userId, QueryOptions countOptions) throws SBonitaSearchException {
        try {
            return this.persistenceService.getNumberOfEntities(SProcessDefinitionDeployInfo.class, "UncategorizedAndWithSupervisor", countOptions, Collections.singletonMap("userId", userId));
        }
        catch (SBonitaReadException bre) {
            throw new SBonitaSearchException(bre);
        }
    }

    @Override
    public List<SProcessDefinitionDeployInfo> searchUncategorizedProcessDeploymentInfosSupervisedBy(long userId, QueryOptions searchOptions) throws SBonitaSearchException {
        try {
            return this.persistenceService.searchEntity(SProcessDefinitionDeployInfo.class, "UncategorizedAndWithSupervisor", searchOptions, Collections.singletonMap("userId", userId));
        }
        catch (SBonitaReadException bre) {
            throw new SBonitaSearchException(bre);
        }
    }

    @Override
    public List<SProcessDefinitionDeployInfo> searchUncategorizedProcessDeploymentInfosUserCanStart(long userId, QueryOptions searchOptions) throws SBonitaSearchException {
        try {
            return this.persistenceService.searchEntity(SProcessDefinitionDeployInfo.class, "UncategorizedUserCanStart", searchOptions, Collections.singletonMap("userId", userId));
        }
        catch (SBonitaReadException bre) {
            throw new SBonitaSearchException(bre);
        }
    }

    @Override
    public long getNumberOfUncategorizedProcessDeploymentInfosUserCanStart(long userId, QueryOptions countOptions) throws SBonitaSearchException {
        try {
            return this.persistenceService.getNumberOfEntities(SProcessDefinitionDeployInfo.class, "UncategorizedUserCanStart", countOptions, Collections.singletonMap("userId", userId));
        }
        catch (SBonitaReadException bre) {
            throw new SBonitaSearchException(bre);
        }
    }

    @Override
    public List<Map<String, String>> getProcessDeploymentInfosFromProcessInstanceIds(List<Long> processInstanceIds) throws SBonitaSearchException {
        if (processInstanceIds == null || processInstanceIds.size() == 0) {
            return Collections.emptyList();
        }
        try {
            Map<String, Object> parameters = Collections.singletonMap("processInstanceIds", processInstanceIds);
            return this.persistenceService.selectList(new SelectListDescriptor("getProcessDeploymentInfoFromProcessInstanceIds", parameters, SProcessDefinitionDeployInfo.class));
        }
        catch (SBonitaReadException e) {
            throw new SBonitaSearchException(e);
        }
    }

    @Override
    public Map<Long, SProcessDefinitionDeployInfo> getProcessDeploymentInfosFromArchivedProcessInstanceIds(List<Long> archivedProcessInstantsIds) throws SProcessDefinitionReadException {
        if (archivedProcessInstantsIds == null || archivedProcessInstantsIds.size() == 0) {
            return Collections.emptyMap();
        }
        try {
            Map<String, Object> parameters = Collections.singletonMap("archivedProcessInstanceIds", archivedProcessInstantsIds);
            List<Map<String, Object>> result = this.persistenceService.selectList(new SelectListDescriptor("getProcessDeploymentInfoFromArchivedProcessInstanceIds", parameters, SProcessDefinitionDeployInfo.class));
            if (result != null && result.size() > 0) {
                return this.getProcessDeploymentInfosFromMap(result);
            }
        }
        catch (SBonitaReadException e) {
            throw new SProcessDefinitionReadException(e);
        }
        return Collections.emptyMap();
    }

    private Map<Long, SProcessDefinitionDeployInfo> getProcessDeploymentInfosFromMap(List<Map<String, Object>> sProcessDeploymentInfos) {
        HashMap<Long, SProcessDefinitionDeployInfo> mProcessDeploymentInfos = new HashMap<Long, SProcessDefinitionDeployInfo>();
        long archivedProcessInstanceId = 0L;
        long id = 0L;
        long processId = 0L;
        String name = "";
        String version = "";
        String description = "";
        long deploymentDate = 0L;
        long deployedBy = 0L;
        String activationState = "";
        String configurationState = "";
        String displayName = "";
        long lastUpdateDate = 0L;
        String iconPath = "";
        String displayDescription = "";
        SProcessDefinitionDeployInfoBuilderFactory fact = BuilderFactory.get(SProcessDefinitionDeployInfoBuilderFactory.class);
        for (Map<String, Object> sProcessDeploymentInfo : sProcessDeploymentInfos) {
            fact.createNewInstance(displayName, version);
            for (Map.Entry<String, Object> entry : sProcessDeploymentInfo.entrySet()) {
                String key = entry.getKey();
                Object value = entry.getValue();
                if ("archivedProcessInstanceId".equals(key)) {
                    archivedProcessInstanceId = (Long)value;
                    continue;
                }
                if (fact.getIdKey().equals(key)) {
                    id = (Long)value;
                    continue;
                }
                if (fact.getProcessIdKey().equals(key)) {
                    processId = (Long)value;
                    continue;
                }
                if (fact.getNameKey().equals(key)) {
                    name = (String)value;
                    continue;
                }
                if (fact.getVersionKey().equals(key)) {
                    version = (String)value;
                    continue;
                }
                if (fact.getDescriptionKey().equals(key)) {
                    description = (String)value;
                    continue;
                }
                if (fact.getDeploymentDateKey().equals(key)) {
                    deploymentDate = (Long)value;
                    continue;
                }
                if (fact.getDeployedByKey().equals(key)) {
                    deployedBy = (Long)value;
                    continue;
                }
                if (fact.getActivationStateKey().equals(key)) {
                    activationState = (String)value;
                    continue;
                }
                if (fact.getConfigurationStateKey().equals(key)) {
                    configurationState = (String)value;
                    continue;
                }
                if (fact.getDisplayNameKey().equals(key)) {
                    displayName = (String)value;
                    continue;
                }
                if (fact.getLastUpdateDateKey().equals(key)) {
                    lastUpdateDate = (Long)value;
                    continue;
                }
                if (fact.getIconPathKey().equals(key)) {
                    iconPath = (String)value;
                    continue;
                }
                if (!fact.getDisplayDescriptionKey().equals(key)) continue;
                displayDescription = (String)value;
            }
            SProcessDefinitionDeployInfo info = fact.createNewInstance(name, version).setId(id).setDescription(description).setDisplayDescription(displayDescription).setActivationState(activationState).setConfigurationState(configurationState).setDeployedBy(deployedBy).setProcessId(processId).setLastUpdateDate(lastUpdateDate).setDisplayName(displayName).setDeploymentDate(deploymentDate).setIconPath(iconPath).done();
            mProcessDeploymentInfos.put(archivedProcessInstanceId, info);
        }
        return mProcessDeploymentInfos;
    }

    private void initiateLogBuilder(long objectId, int sQueriableLogStatus, SPersistenceLogBuilder logBuilder, String callerMethodName) {
        logBuilder.actionScope(String.valueOf(objectId));
        logBuilder.actionStatus(sQueriableLogStatus);
        logBuilder.objectId(objectId);
        SQueriableLog log = logBuilder.done();
        if (this.queriableLoggerService.isLoggable(log.getActionType(), log.getSeverity())) {
            this.queriableLoggerService.log(this.getClass().getName(), callerMethodName, log);
        }
    }

    @Override
    public List<SProcessDefinitionDeployInfo> getProcessDeploymentInfosUnrelatedToCategory(long categoryId, int pageIndex, int numberPerPage, ProcessDeploymentInfoCriterion pagingCriterion) throws SProcessDefinitionReadException {
        Map<String, Object> parameters = Collections.singletonMap("categoryId", categoryId);
        QueryOptions queryOptions = this.createQueryOptions(pageIndex, numberPerPage, pagingCriterion);
        SelectListDescriptor selectDescriptor = new SelectListDescriptor("searchSProcessDefinitionDeployInfoUnrelatedToCategory", parameters, SProcessDefinitionDeployInfo.class, queryOptions);
        try {
            return this.persistenceService.selectList(selectDescriptor);
        }
        catch (SBonitaReadException e) {
            throw new SProcessDefinitionReadException(e);
        }
    }

    @Override
    public Long getNumberOfProcessDeploymentInfosUnrelatedToCategory(long categoryId) throws SProcessDefinitionReadException {
        Map<String, Object> parameters = Collections.singletonMap("categoryId", categoryId);
        SelectOneDescriptor selectDescriptor = new SelectOneDescriptor("getNumberOfSProcessDefinitionDeployInfoUnrelatedToCategory", parameters, SProcessDefinitionDeployInfo.class);
        try {
            return (Long)this.persistenceService.selectOne(selectDescriptor);
        }
        catch (SBonitaReadException bre) {
            throw new SProcessDefinitionReadException(bre);
        }
    }

    private QueryOptions createQueryOptions(int pageIndex, int numberPerPage, ProcessDeploymentInfoCriterion pagingCriterion) {
        String field = null;
        OrderByType order = null;
        SProcessDefinitionDeployInfoBuilderFactory fact = BuilderFactory.get(SProcessDefinitionDeployInfoBuilderFactory.class);
        switch (pagingCriterion) {
            case DEFAULT: {
                break;
            }
            case LABEL_ASC: {
                break;
            }
            case LABEL_DESC: {
                break;
            }
            case NAME_ASC: {
                field = fact.getNameKey();
                order = OrderByType.ASC;
                break;
            }
            case NAME_DESC: {
                field = fact.getNameKey();
                order = OrderByType.DESC;
                break;
            }
            case ACTIVATION_STATE_ASC: {
                field = fact.getActivationStateKey();
                order = OrderByType.ASC;
                break;
            }
            case ACTIVATION_STATE_DESC: {
                field = fact.getActivationStateKey();
                order = OrderByType.DESC;
                break;
            }
            case CONFIGURATION_STATE_ASC: {
                field = fact.getConfigurationStateKey();
                order = OrderByType.ASC;
                break;
            }
            case CONFIGURATION_STATE_DESC: {
                field = fact.getConfigurationStateKey();
                order = OrderByType.DESC;
                break;
            }
            case VERSION_ASC: {
                field = fact.getVersionKey();
                order = OrderByType.ASC;
                break;
            }
            case VERSION_DESC: {
                field = fact.getVersionKey();
                order = OrderByType.DESC;
                break;
            }
        }
        QueryOptions queryOptions = field == null ? new QueryOptions(pageIndex, numberPerPage) : new QueryOptions(pageIndex, numberPerPage, SProcessDefinitionDeployInfo.class, field, order);
        return queryOptions;
    }

    @Override
    public List<SProcessDefinitionDeployInfo> getProcessDeploymentInfos(QueryOptions queryOptions) throws SProcessDefinitionReadException {
        try {
            return this.persistenceService.selectList(new SelectListDescriptor("getProcessDefinitionDeployInfos", Collections.<String, Object>emptyMap(), SProcessDefinitionDeployInfo.class, queryOptions));
        }
        catch (SBonitaReadException e) {
            throw new SProcessDefinitionReadException(e);
        }
    }

    @Override
    public List<SProcessDefinitionDeployInfo> getProcessDeploymentInfosWithActorOnlyForGroup(long groupId, QueryOptions queryOptions) throws SProcessDefinitionReadException {
        Map<String, Object> parameters = Collections.singletonMap("groupId", groupId);
        SelectListDescriptor selectDescriptor = new SelectListDescriptor("getProcessesWithActorOnlyForGroup", parameters, SProcessDefinitionDeployInfo.class, queryOptions);
        try {
            return this.persistenceService.selectList(selectDescriptor);
        }
        catch (SBonitaReadException e) {
            throw new SProcessDefinitionReadException(e);
        }
    }

    @Override
    public List<SProcessDefinitionDeployInfo> getProcessDeploymentInfosWithActorOnlyForGroups(List<Long> groupIds, QueryOptions queryOptions) throws SProcessDefinitionReadException {
        Map<String, Object> parameters = Collections.singletonMap("groupIds", groupIds);
        SelectListDescriptor selectDescriptor = new SelectListDescriptor("getProcessesWithActorOnlyForGroups", parameters, SProcessDefinitionDeployInfo.class, queryOptions);
        try {
            return this.persistenceService.selectList(selectDescriptor);
        }
        catch (SBonitaReadException e) {
            throw new SProcessDefinitionReadException(e);
        }
    }

    @Override
    public List<SProcessDefinitionDeployInfo> getProcessDeploymentInfosWithActorOnlyForRole(long roleId, QueryOptions queryOptions) throws SProcessDefinitionReadException {
        Map<String, Object> parameters = Collections.singletonMap("roleId", roleId);
        SelectListDescriptor selectDescriptor = new SelectListDescriptor("getProcessesWithActorOnlyForRole", parameters, SProcessDefinitionDeployInfo.class, queryOptions);
        try {
            return this.persistenceService.selectList(selectDescriptor);
        }
        catch (SBonitaReadException e) {
            throw new SProcessDefinitionReadException(e);
        }
    }

    @Override
    public List<SProcessDefinitionDeployInfo> getProcessDeploymentInfosWithActorOnlyForRoles(List<Long> roleIds, QueryOptions queryOptions) throws SProcessDefinitionReadException {
        Map<String, Object> parameters = Collections.singletonMap("roleIds", roleIds);
        SelectListDescriptor selectDescriptor = new SelectListDescriptor("getProcessesWithActorOnlyForRoles", parameters, SProcessDefinitionDeployInfo.class, queryOptions);
        try {
            return this.persistenceService.selectList(selectDescriptor);
        }
        catch (SBonitaReadException e) {
            throw new SProcessDefinitionReadException(e);
        }
    }

    @Override
    public List<SProcessDefinitionDeployInfo> getProcessDeploymentInfosWithActorOnlyForUser(long userId, QueryOptions queryOptions) throws SProcessDefinitionReadException {
        Map<String, Object> parameters = Collections.singletonMap("userId", userId);
        SelectListDescriptor selectDescriptor = new SelectListDescriptor("getProcessesWithActorOnlyForUser", parameters, SProcessDefinitionDeployInfo.class, queryOptions);
        try {
            return this.persistenceService.selectList(selectDescriptor);
        }
        catch (SBonitaReadException e) {
            throw new SProcessDefinitionReadException(e);
        }
    }

    @Override
    public List<SProcessDefinitionDeployInfo> getProcessDeploymentInfosWithActorOnlyForUsers(List<Long> userIds, QueryOptions queryOptions) throws SProcessDefinitionReadException {
        Map<String, Object> parameters = Collections.singletonMap("userIds", userIds);
        SelectListDescriptor selectDescriptor = new SelectListDescriptor("getProcessesWithActorOnlyForUsers", parameters, SProcessDefinitionDeployInfo.class, queryOptions);
        try {
            return this.persistenceService.selectList(selectDescriptor);
        }
        catch (SBonitaReadException e) {
            throw new SProcessDefinitionReadException(e);
        }
    }

    @Override
    public long getNumberOfUsersWhoCanStartProcessDeploymentInfo(long processDefinitionId, QueryOptions searchOptions) throws SBonitaSearchException {
        try {
            Map<String, Object> parameters = Collections.singletonMap("processId", processDefinitionId);
            return this.persistenceService.getNumberOfEntities(SUser.class, "WhoCanStartProcess", searchOptions, parameters);
        }
        catch (SBonitaReadException bre) {
            throw new SBonitaSearchException(bre);
        }
    }

    @Override
    public List<SUser> searchUsersWhoCanStartProcessDeploymentInfo(long processDefinitionId, QueryOptions searchOptions) throws SBonitaSearchException {
        try {
            Map<String, Object> parameters = Collections.singletonMap("processId", processDefinitionId);
            return this.persistenceService.searchEntity(SUser.class, "WhoCanStartProcess", searchOptions, parameters);
        }
        catch (SBonitaReadException bre) {
            throw new SBonitaSearchException(bre);
        }
    }
}

