/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.execution.flowmerger;

import org.bonitasoft.engine.commons.exceptions.SObjectCreationException;
import org.bonitasoft.engine.commons.exceptions.SObjectNotFoundException;
import org.bonitasoft.engine.commons.exceptions.SObjectReadException;
import org.bonitasoft.engine.execution.TokenProvider;
import org.bonitasoft.engine.execution.flowmerger.FlowNodeTransitionsWrapper;
import org.bonitasoft.engine.execution.flowmerger.SFlowNodeWrapper;
import org.bonitasoft.engine.execution.flowmerger.TokenInfo;

public class FlowMerger {
    private final SFlowNodeWrapper flowNodewrapper;
    private final FlowNodeTransitionsWrapper transitionsWrapper;
    private final TokenProvider tokenProvider;

    public FlowMerger(SFlowNodeWrapper flowNodeWrapper, FlowNodeTransitionsWrapper transitionsDescriptor, TokenProvider tokenProvider) {
        this.flowNodewrapper = flowNodeWrapper;
        this.transitionsWrapper = transitionsDescriptor;
        this.tokenProvider = tokenProvider;
    }

    public boolean mustConsumeInputTokenOnTakingTransition() {
        return !this.flowNodewrapper.isBoundaryEvent() && this.flowNodewrapper.isParalleleOrInclusive() && !this.transitionsWrapper.isLastFlowNode() && this.transitionsWrapper.hasMultipleIncomingTransitions();
    }

    public boolean mustCreateTokenOnFinish() {
        if (this.flowNodewrapper.isNull() || this.flowNodewrapper.isBoundaryEvent() || this.flowNodewrapper.isExclusive() || this.transitionsWrapper.isLastFlowNode()) {
            return false;
        }
        return this.transitionsWrapper.hasMultipleOutgoingTransitions();
    }

    public boolean isImplicitEnd() {
        if (this.flowNodewrapper.isNull()) {
            return false;
        }
        return this.transitionsWrapper.isLastFlowNode();
    }

    public TokenInfo getOutputTokenInfo() throws SObjectReadException, SObjectNotFoundException, SObjectCreationException {
        return this.tokenProvider.getOutputTokenInfo();
    }
}

