/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.execution.work;

import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.core.process.instance.api.event.EventInstanceService;
import org.bonitasoft.engine.execution.work.RestartException;
import org.bonitasoft.engine.execution.work.TenantRestartHandler;
import org.bonitasoft.engine.log.technical.TechnicalLogSeverity;
import org.bonitasoft.engine.log.technical.TechnicalLoggerService;
import org.bonitasoft.engine.service.PlatformServiceAccessor;
import org.bonitasoft.engine.service.TenantServiceAccessor;

public class BPMEventWorksHandler
implements TenantRestartHandler {
    @Override
    public void handleRestart(PlatformServiceAccessor platformServiceAccessor, TenantServiceAccessor tenantServiceAccessor) throws RestartException {
        EventInstanceService eventInstanceService = tenantServiceAccessor.getEventInstanceService();
        TechnicalLoggerService technicalLoggerService = tenantServiceAccessor.getTechnicalLoggerService();
        try {
            this.logInfo(technicalLoggerService, "Reinitializing message instances in non-stable state to make them reworked by BPMEventHandlingJob");
            int nbMessagesReset = eventInstanceService.resetProgressMessageInstances();
            this.logInfo(technicalLoggerService, nbMessagesReset + " message instances found and reset.");
            this.logInfo(technicalLoggerService, "Reinitializing waiting message events in non-stable state to make them reworked by BPMEventHandlingJob");
            int nbWaitingEventsReset = eventInstanceService.resetInProgressWaitingEvents();
            this.logInfo(technicalLoggerService, nbWaitingEventsReset + " waiting message events found and reset.");
        }
        catch (SBonitaException e) {
            this.handleException("Unable to reset MessageInstances / WaitingMessageEvents that were 'In Progress' when the node stopped", e);
        }
    }

    protected void logInfo(TechnicalLoggerService technicalLoggerService, String msg) {
        technicalLoggerService.log(BPMEventWorksHandler.class, TechnicalLogSeverity.INFO, msg);
    }

    private void handleException(String message, Exception e) throws RestartException {
        throw new RestartException(message, e);
    }
}

