/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.execution.work;

import java.util.List;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.core.process.instance.api.ActivityInstanceService;
import org.bonitasoft.engine.core.process.instance.model.SFlowNodeInstance;
import org.bonitasoft.engine.execution.work.RestartException;
import org.bonitasoft.engine.execution.work.TenantRestartHandler;
import org.bonitasoft.engine.execution.work.WorkFactory;
import org.bonitasoft.engine.log.technical.TechnicalLogSeverity;
import org.bonitasoft.engine.log.technical.TechnicalLoggerService;
import org.bonitasoft.engine.persistence.QueryOptions;
import org.bonitasoft.engine.service.PlatformServiceAccessor;
import org.bonitasoft.engine.service.TenantServiceAccessor;
import org.bonitasoft.engine.work.SWorkRegisterException;
import org.bonitasoft.engine.work.WorkService;

public class RestartFlowNodesHandler
implements TenantRestartHandler {
    @Override
    public void handleRestart(PlatformServiceAccessor platformServiceAccessor, TenantServiceAccessor tenantServiceAccessor) throws RestartException {
        ActivityInstanceService activityInstanceService = tenantServiceAccessor.getActivityInstanceService();
        WorkService workService = tenantServiceAccessor.getWorkService();
        TechnicalLoggerService logger = tenantServiceAccessor.getTechnicalLoggerService();
        try {
            List<SFlowNodeInstance> sFlowNodeInstances;
            QueryOptions queryOptions = QueryOptions.defaultQueryOptions();
            this.logInfo(logger, "Restarting flow nodes...");
            do {
                sFlowNodeInstances = activityInstanceService.getFlowNodeInstancesToRestart(queryOptions);
                queryOptions = QueryOptions.getNextPage(queryOptions);
                for (SFlowNodeInstance sFlowNodeInstance : sFlowNodeInstances) {
                    if (sFlowNodeInstance.isTerminal()) {
                        this.createNotifyChildFinishedWork(workService, logger, sFlowNodeInstance);
                        continue;
                    }
                    this.createExecuteFlowNodeWork(workService, logger, sFlowNodeInstance);
                }
            } while (sFlowNodeInstances.size() == queryOptions.getNumberOfResults());
        }
        catch (SWorkRegisterException e) {
            throw new RestartException("Unable to restart flowNodes: can't register work", e);
        }
        catch (SBonitaException e) {
            throw new RestartException("Unable to restart flowNodes: can't read flow nodes", e);
        }
    }

    private void logInfo(TechnicalLoggerService logger, String message) {
        boolean isInfo = logger.isLoggable(this.getClass(), TechnicalLogSeverity.INFO);
        if (isInfo) {
            logger.log(this.getClass(), TechnicalLogSeverity.INFO, message);
        }
    }

    private void createExecuteFlowNodeWork(WorkService workService, TechnicalLoggerService logger, SFlowNodeInstance sFlowNodeInstance) throws SWorkRegisterException {
        this.logInfo(logger, "Restarting flow node (Execute ...) with name = <" + sFlowNodeInstance.getName() + ">, and id = <" + sFlowNodeInstance.getId() + "> in state = <" + sFlowNodeInstance.getStateName() + ">");
        workService.registerWork(WorkFactory.createExecuteFlowNodeWork(sFlowNodeInstance.getProcessDefinitionId(), sFlowNodeInstance.getParentProcessInstanceId(), sFlowNodeInstance.getId(), null, null));
    }

    private void createNotifyChildFinishedWork(WorkService workService, TechnicalLoggerService logger, SFlowNodeInstance sFlowNodeInstance) throws SWorkRegisterException {
        this.logInfo(logger, "Restarting flow node (Notify finished...) with name = <" + sFlowNodeInstance.getName() + ">, and id = <" + sFlowNodeInstance.getId() + " in state = <" + sFlowNodeInstance.getStateName() + ">");
        workService.registerWork(WorkFactory.createNotifyChildFinishedWork(sFlowNodeInstance.getProcessDefinitionId(), sFlowNodeInstance.getParentProcessInstanceId(), sFlowNodeInstance.getId(), sFlowNodeInstance.getParentContainerId(), sFlowNodeInstance.getParentContainerType().name()));
    }
}

