/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.execution.work;

import java.util.List;
import org.bonitasoft.engine.bpm.connector.ConnectorEvent;
import org.bonitasoft.engine.bpm.process.ProcessInstanceState;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.core.process.definition.ProcessDefinitionService;
import org.bonitasoft.engine.core.process.definition.exception.SProcessDefinitionNotFoundException;
import org.bonitasoft.engine.core.process.definition.exception.SProcessDefinitionReadException;
import org.bonitasoft.engine.core.process.definition.model.SProcessDefinition;
import org.bonitasoft.engine.core.process.instance.api.ActivityInstanceService;
import org.bonitasoft.engine.core.process.instance.api.ProcessInstanceService;
import org.bonitasoft.engine.core.process.instance.api.exceptions.SProcessInstanceReadException;
import org.bonitasoft.engine.core.process.instance.model.SActivityInstance;
import org.bonitasoft.engine.core.process.instance.model.SProcessInstance;
import org.bonitasoft.engine.execution.ProcessExecutor;
import org.bonitasoft.engine.execution.work.RestartException;
import org.bonitasoft.engine.execution.work.TenantRestartHandler;
import org.bonitasoft.engine.execution.work.WorkFactory;
import org.bonitasoft.engine.log.technical.TechnicalLogSeverity;
import org.bonitasoft.engine.log.technical.TechnicalLoggerService;
import org.bonitasoft.engine.persistence.QueryOptions;
import org.bonitasoft.engine.service.PlatformServiceAccessor;
import org.bonitasoft.engine.service.TenantServiceAccessor;
import org.bonitasoft.engine.work.WorkService;

public class RestartProcessHandler
implements TenantRestartHandler {
    @Override
    public void handleRestart(PlatformServiceAccessor platformServiceAccessor, TenantServiceAccessor tenantServiceAccessor) throws RestartException {
        QueryOptions queryOptions = null;
        ProcessExecutor processExecutor = tenantServiceAccessor.getProcessExecutor();
        ProcessInstanceService processInstanceService = tenantServiceAccessor.getProcessInstanceService();
        ActivityInstanceService activityInstanceService = tenantServiceAccessor.getActivityInstanceService();
        WorkService workService = tenantServiceAccessor.getWorkService();
        ProcessDefinitionService processDefinitionService = tenantServiceAccessor.getProcessDefinitionService();
        TechnicalLoggerService logger = tenantServiceAccessor.getTechnicalLoggerService();
        boolean isInfo = logger.isLoggable(this.getClass(), TechnicalLogSeverity.INFO);
        try {
            SProcessDefinition processDefinition;
            List<SProcessInstance> processInstances;
            this.logInfo(logger, isInfo, "Restarting connectors of process...");
            queryOptions = QueryOptions.defaultQueryOptions();
            do {
                processInstances = processInstanceService.getProcessInstancesInState(queryOptions, ProcessInstanceState.INITIALIZING);
                queryOptions = QueryOptions.getNextPage(queryOptions);
                for (SProcessInstance processInstance : processInstances) {
                    processDefinition = processDefinitionService.getProcessDefinition(processInstance.getProcessDefinitionId());
                    if (isInfo) {
                        logger.log(this.getClass(), TechnicalLogSeverity.INFO, "Executing 'on enter' connectors of process " + processInstance.getName());
                    }
                    processExecutor.executeConnectors(processDefinition, processInstance, ConnectorEvent.ON_ENTER);
                }
            } while (processInstances.size() == queryOptions.getNumberOfResults());
            queryOptions = QueryOptions.defaultQueryOptions();
            do {
                processInstances = processInstanceService.getProcessInstancesInState(queryOptions, ProcessInstanceState.COMPLETING);
                queryOptions = QueryOptions.getNextPage(queryOptions);
                for (SProcessInstance processInstance : processInstances) {
                    processDefinition = processDefinitionService.getProcessDefinition(processInstance.getProcessDefinitionId());
                    if (isInfo) {
                        logger.log(this.getClass(), TechnicalLogSeverity.INFO, "Executing 'on finish' connectors of process " + processInstance.getName());
                    }
                    processExecutor.executeConnectors(processDefinition, processInstance, ConnectorEvent.ON_FINISH);
                }
            } while (processInstances.size() == queryOptions.getNumberOfResults());
            this.logInfo(logger, isInfo, "Restarting notification of finished sub-processes of Call-Activities...");
            queryOptions = QueryOptions.defaultQueryOptions();
            do {
                processInstances = processInstanceService.getProcessInstancesInStates(queryOptions, ProcessInstanceState.COMPLETED, ProcessInstanceState.ABORTED, ProcessInstanceState.CANCELLED);
                queryOptions = QueryOptions.getNextPage(queryOptions);
                for (SProcessInstance processInstance : processInstances) {
                    long callerId;
                    ProcessInstanceState state = this.getState(processInstance.getStateId());
                    if (isInfo) {
                        logger.log(this.getClass(), TechnicalLogSeverity.INFO, "Restarting notification of finished process '" + processInstance.getName() + "' with id " + processInstance.getId() + " in state " + state);
                    }
                    if (processInstance.hasBeenInterruptedByEvent() || (callerId = processInstance.getCallerId()) <= 0L) continue;
                    SActivityInstance callActivityInstance = activityInstanceService.getActivityInstance(processInstance.getCallerId());
                    workService.registerWork(WorkFactory.createExecuteFlowNodeWork(callActivityInstance.getProcessDefinitionId(), callActivityInstance.getParentProcessInstanceId(), callActivityInstance.getId(), null, null));
                }
            } while (processInstances.size() == queryOptions.getNumberOfResults());
        }
        catch (SProcessInstanceReadException e) {
            this.handleException(e, "Unable to restart process: can't read process instances");
        }
        catch (SProcessDefinitionNotFoundException e) {
            this.handleException(e, "Unable to restart process: can't find process definition");
        }
        catch (SProcessDefinitionReadException e) {
            this.handleException(e, "Unable to restart process: can't read process definition");
        }
        catch (SBonitaException e) {
            this.handleException(e, "Unable to restart process: can't execute connectors");
        }
    }

    protected void logInfo(TechnicalLoggerService logger, boolean isInfo, String msg) {
        if (isInfo) {
            logger.log(this.getClass(), TechnicalLogSeverity.INFO, msg);
        }
    }

    private void handleException(Exception e, String message) throws RestartException {
        throw new RestartException(message, e);
    }

    private ProcessInstanceState getState(int stateId) {
        return ProcessInstanceState.getFromId((int)stateId);
    }
}

