/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.execution.work;

import java.util.List;
import org.bonitasoft.engine.bpm.connector.ConnectorEvent;
import org.bonitasoft.engine.core.expression.control.model.SExpressionContext;
import org.bonitasoft.engine.core.operation.model.SOperation;
import org.bonitasoft.engine.core.process.instance.model.event.handling.SMessageInstance;
import org.bonitasoft.engine.core.process.instance.model.event.handling.SWaitingMessageEvent;
import org.bonitasoft.engine.execution.work.ExecuteConnectorOfActivity;
import org.bonitasoft.engine.execution.work.ExecuteConnectorOfProcess;
import org.bonitasoft.engine.execution.work.ExecuteFlowNodeWork;
import org.bonitasoft.engine.execution.work.ExecuteMessageCoupleWork;
import org.bonitasoft.engine.execution.work.FailureHandlingBonitaWork;
import org.bonitasoft.engine.execution.work.LockProcessInstanceWork;
import org.bonitasoft.engine.execution.work.NotifyChildFinishedWork;
import org.bonitasoft.engine.execution.work.TenantAwareBonitaWork;
import org.bonitasoft.engine.execution.work.TxBonitaWork;
import org.bonitasoft.engine.execution.work.failurewrapping.ConnectorDefinitionAndInstanceContextWork;
import org.bonitasoft.engine.execution.work.failurewrapping.FlowNodeDefinitionAndInstanceContextWork;
import org.bonitasoft.engine.execution.work.failurewrapping.MessageInstanceContextWork;
import org.bonitasoft.engine.execution.work.failurewrapping.ProcessDefinitionContextWork;
import org.bonitasoft.engine.execution.work.failurewrapping.ProcessInstanceContextWork;
import org.bonitasoft.engine.work.BonitaWork;

public class WorkFactory {
    private WorkFactory() {
    }

    public static BonitaWork createExecuteConnectorOfActivity(long processDefinitionId, long processInstanceId, long flowNodeDefinitionId, long flowNodeInstanceId, long connectorInstanceId, String connectorDefinitionName) {
        BonitaWork wrappedWork = new ExecuteConnectorOfActivity(processDefinitionId, flowNodeDefinitionId, flowNodeInstanceId, connectorInstanceId, connectorDefinitionName);
        wrappedWork = new ConnectorDefinitionAndInstanceContextWork(wrappedWork, connectorDefinitionName, connectorInstanceId);
        wrappedWork = WorkFactory.buildFlowNodeDefinitionAndInstanceContextWork(processDefinitionId, processInstanceId, flowNodeInstanceId, wrappedWork);
        return new FailureHandlingBonitaWork(wrappedWork);
    }

    public static BonitaWork createExecuteConnectorOfProcess(long processDefinitionId, long processInstanceId, long rootProcessInstanceId, long connectorInstanceId, String connectorDefinitionName, ConnectorEvent activationEvent) {
        TenantAwareBonitaWork wrappedWork = new ExecuteConnectorOfProcess(processDefinitionId, connectorInstanceId, connectorDefinitionName, processInstanceId, rootProcessInstanceId, activationEvent);
        ProcessInstanceContextWork processInstanceContextWork = WorkFactory.buildProcessInstanceContextWork(processDefinitionId, processInstanceId, rootProcessInstanceId, wrappedWork);
        wrappedWork = new ConnectorDefinitionAndInstanceContextWork(processInstanceContextWork, connectorDefinitionName, connectorInstanceId, activationEvent);
        return new FailureHandlingBonitaWork(wrappedWork);
    }

    public static BonitaWork createExecuteFlowNodeWork(long processDefinitionId, long processInstanceId, long flowNodeInstanceId, List<SOperation> operations, SExpressionContext contextDependency) {
        if (processInstanceId <= 0L) {
            throw new RuntimeException("It is forbidden to create a ExecuteFlowNodeWork with a processInstanceId equals to " + processInstanceId);
        }
        BonitaWork wrappedWork = new ExecuteFlowNodeWork(flowNodeInstanceId, operations, contextDependency, processInstanceId);
        wrappedWork = new LockProcessInstanceWork(new TxBonitaWork(wrappedWork), processInstanceId);
        wrappedWork = WorkFactory.buildFlowNodeDefinitionAndInstanceContextWork(processDefinitionId, processInstanceId, flowNodeInstanceId, wrappedWork);
        return new FailureHandlingBonitaWork(wrappedWork);
    }

    public static BonitaWork createExecuteMessageCoupleWork(SMessageInstance messageInstance, SWaitingMessageEvent waitingMessage) {
        BonitaWork wrappedWork = new TxBonitaWork(new ExecuteMessageCoupleWork(messageInstance.getId(), waitingMessage.getId()));
        if (waitingMessage.getParentProcessInstanceId() > 0L) {
            wrappedWork = new LockProcessInstanceWork(wrappedWork, waitingMessage.getParentProcessInstanceId());
        }
        wrappedWork = new MessageInstanceContextWork(wrappedWork, messageInstance, waitingMessage);
        wrappedWork = WorkFactory.buildFlowNodeDefinitionAndInstanceContextWork(waitingMessage.getProcessDefinitionId(), waitingMessage.getParentProcessInstanceId(), waitingMessage.getRootProcessInstanceId(), waitingMessage.getFlowNodeInstanceId(), wrappedWork);
        return new FailureHandlingBonitaWork(wrappedWork);
    }

    public static BonitaWork createNotifyChildFinishedWork(long processDefinitionId, long processInstanceId, long flowNodeInstanceId, long parentId, String parentType) {
        BonitaWork wrappedWork = new NotifyChildFinishedWork(processDefinitionId, flowNodeInstanceId, parentId, parentType);
        wrappedWork = new LockProcessInstanceWork(new TxBonitaWork(wrappedWork), processInstanceId);
        wrappedWork = WorkFactory.buildFlowNodeDefinitionAndInstanceContextWork(processDefinitionId, processInstanceId, flowNodeInstanceId, wrappedWork);
        return new FailureHandlingBonitaWork(wrappedWork);
    }

    private static BonitaWork buildFlowNodeDefinitionAndInstanceContextWork(long processDefinitionId, long processInstanceId, long flowNodeInstanceId, BonitaWork wrappedWork) {
        ProcessDefinitionContextWork processDefinitionContextWork = new ProcessDefinitionContextWork(wrappedWork, processDefinitionId);
        ProcessInstanceContextWork processInstanceContextWork = new ProcessInstanceContextWork(processDefinitionContextWork, processInstanceId);
        return new FlowNodeDefinitionAndInstanceContextWork(processInstanceContextWork, flowNodeInstanceId);
    }

    private static BonitaWork buildFlowNodeDefinitionAndInstanceContextWork(long processDefinitionId, long processInstanceId, long rootProcessInstanceId, long flowNodeInstanceId, BonitaWork wrappedWork) {
        ProcessInstanceContextWork processInstanceContextWork = WorkFactory.buildProcessInstanceContextWork(processDefinitionId, processInstanceId, rootProcessInstanceId, wrappedWork);
        return new FlowNodeDefinitionAndInstanceContextWork(processInstanceContextWork, flowNodeInstanceId);
    }

    private static ProcessInstanceContextWork buildProcessInstanceContextWork(long processDefinitionId, long processInstanceId, long rootProcessInstanceId, BonitaWork wrappedWork) {
        ProcessDefinitionContextWork processDefinitionContextWork = new ProcessDefinitionContextWork(wrappedWork, processDefinitionId);
        return new ProcessInstanceContextWork(processDefinitionContextWork, processInstanceId, rootProcessInstanceId);
    }
}

