/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.external.web.forms;

import java.util.Collections;
import org.bonitasoft.engine.bpm.process.ProcessInstance;
import org.bonitasoft.engine.classloader.ClassLoaderService;
import org.bonitasoft.engine.classloader.SClassLoaderException;
import org.bonitasoft.engine.command.system.CommandWithParameters;
import org.bonitasoft.engine.core.process.definition.ProcessDefinitionService;
import org.bonitasoft.engine.core.process.definition.exception.SProcessDefinitionNotFoundException;
import org.bonitasoft.engine.core.process.definition.exception.SProcessDefinitionReadException;
import org.bonitasoft.engine.core.process.definition.model.SProcessDefinition;
import org.bonitasoft.engine.core.process.instance.api.ActivityInstanceService;
import org.bonitasoft.engine.core.process.instance.api.ProcessInstanceService;
import org.bonitasoft.engine.core.process.instance.api.exceptions.SActivityInstanceNotFoundException;
import org.bonitasoft.engine.core.process.instance.api.exceptions.SActivityReadException;
import org.bonitasoft.engine.core.process.instance.api.exceptions.SProcessInstanceNotFoundException;
import org.bonitasoft.engine.core.process.instance.api.exceptions.SProcessInstanceReadException;
import org.bonitasoft.engine.core.process.instance.model.SActivityInstance;
import org.bonitasoft.engine.core.process.instance.model.SProcessInstance;
import org.bonitasoft.engine.dependency.model.ScopeType;
import org.bonitasoft.engine.exception.BonitaRuntimeException;
import org.bonitasoft.engine.log.technical.TechnicalLogSeverity;
import org.bonitasoft.engine.log.technical.TechnicalLoggerService;
import org.bonitasoft.engine.service.ModelConvertor;
import org.bonitasoft.engine.service.TenantServiceAccessor;
import org.bonitasoft.engine.service.TenantServiceSingleton;
import org.bonitasoft.engine.service.impl.ServiceAccessorFactory;
import org.bonitasoft.engine.sessionaccessor.STenantIdNotSetException;
import org.bonitasoft.engine.sessionaccessor.SessionAccessor;

public abstract class ExecuteActionsBaseEntry
extends CommandWithParameters {
    protected static final String ACTIVITY_INSTANCE_ID_KEY = "ACTIVITY_INSTANCE_ID_KEY";
    protected static final String PROCESS_DEFINITION_ID_KEY = "PROCESS_DEFINITION_ID_KEY";
    protected static final String OPERATIONS_LIST_KEY = "OPERATIONS_LIST_KEY";
    protected static final String OPERATIONS_INPUT_KEY = "OPERATIONS_INPUT_KEY";
    protected static final String CONNECTORS_LIST_KEY = "CONNECTORS_LIST_KEY";
    protected static final String USER_ID_KEY = "USER_ID_KEY";

    protected static TenantServiceAccessor getTenantAccessor() {
        try {
            SessionAccessor sessionAccessor = ServiceAccessorFactory.getInstance().createSessionAccessor();
            long tenantId = sessionAccessor.getTenantId();
            return TenantServiceSingleton.getInstance(tenantId);
        }
        catch (BonitaRuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BonitaRuntimeException((Throwable)e);
        }
    }

    protected void log(TenantServiceAccessor tenantAccessor, Exception e) {
        TechnicalLoggerService logger = tenantAccessor.getTechnicalLoggerService();
        logger.log(this.getClass(), TechnicalLogSeverity.DEBUG, e);
    }

    protected long getTenantId() {
        try {
            SessionAccessor sessionAccessor = ServiceAccessorFactory.getInstance().createSessionAccessor();
            return sessionAccessor.getTenantId();
        }
        catch (STenantIdNotSetException e) {
            throw new BonitaRuntimeException((Throwable)e);
        }
        catch (BonitaRuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BonitaRuntimeException((Throwable)e);
        }
    }

    protected SActivityInstance getSActivityInstance(TenantServiceAccessor tenantAccessor, long activityInstanceId) throws SActivityReadException, SActivityInstanceNotFoundException {
        ActivityInstanceService activityInstanceService = tenantAccessor.getActivityInstanceService();
        return activityInstanceService.getActivityInstance(activityInstanceId);
    }

    protected ProcessInstance getProcessInstance(TenantServiceAccessor tenantAccessor, long processInstanceId) throws SProcessInstanceNotFoundException, SProcessInstanceReadException {
        ProcessInstanceService processInstanceService = tenantAccessor.getProcessInstanceService();
        ProcessDefinitionService processDefinitionService = tenantAccessor.getProcessDefinitionService();
        SProcessInstance sProcessInstance = processInstanceService.getProcessInstance(processInstanceId);
        return ModelConvertor.toProcessInstances(Collections.singletonList(sProcessInstance), processDefinitionService).get(0);
    }

    protected ClassLoader getLocalClassLoader(TenantServiceAccessor tenantAccessor, long processDefinitionId) throws SClassLoaderException {
        ClassLoaderService classLoaderService = tenantAccessor.getClassLoaderService();
        return classLoaderService.getLocalClassLoader(ScopeType.PROCESS.name(), processDefinitionId);
    }

    @Deprecated
    protected SProcessDefinition getServerProcessDefinition(long processDefinitionId, ProcessDefinitionService processDefinitionService) throws SProcessDefinitionNotFoundException, SProcessDefinitionReadException {
        return processDefinitionService.getProcessDefinition(processDefinitionId);
    }

    protected SProcessDefinition getProcessDefinition(TenantServiceAccessor tenantAccessor, long processDefinitionId) throws SProcessDefinitionNotFoundException, SProcessDefinitionReadException {
        ProcessDefinitionService processDefinitionService = tenantAccessor.getProcessDefinitionService();
        return processDefinitionService.getProcessDefinition(processDefinitionId);
    }
}

