/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.persistence;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.type.IntegerType;
import org.hibernate.usertype.ParameterizedType;
import org.hibernate.usertype.UserType;

public class IntegerEnumUserType
implements UserType,
ParameterizedType,
Serializable {
    private static final long serialVersionUID = 8455087214832419499L;
    private static final String DEFAULT_IDENTIFIER_METHOD_NAME = "order";
    private static final String DEFAULT_VALUE_OF_METHOD_NAME = "fromInt";
    private Class<? extends Enum> enumClass;
    private Class<?> identifierType;
    private Method identifierMethod;
    private Method valueOfMethod;
    private final IntegerType type = new IntegerType();
    private int[] sqlTypes;

    public void setParameterValues(Properties parameters) {
        String enumClassName = parameters.getProperty("enumClass");
        try {
            this.enumClass = Class.forName(enumClassName).asSubclass(Enum.class);
        }
        catch (ClassNotFoundException cfne) {
            String message = "Enum class not found";
            throw new HibernateException("Enum class not found", (Throwable)cfne);
        }
        String identifierMethodName = parameters.getProperty("identifierMethod", DEFAULT_IDENTIFIER_METHOD_NAME);
        try {
            this.identifierMethod = this.enumClass.getMethod(identifierMethodName, new Class[0]);
            this.identifierType = this.identifierMethod.getReturnType();
        }
        catch (Exception e) {
            String message = "Failed to obtain identifier method";
            throw new HibernateException("Failed to obtain identifier method", (Throwable)e);
        }
        this.sqlTypes = new int[]{this.type.sqlType()};
        String valueOfMethodName = parameters.getProperty("valueOfMethod", DEFAULT_VALUE_OF_METHOD_NAME);
        try {
            this.valueOfMethod = this.enumClass.getMethod(valueOfMethodName, this.identifierType);
        }
        catch (Exception e) {
            String message = "Failed to obtain valueOf method";
            throw new HibernateException("Failed to obtain valueOf method", (Throwable)e);
        }
    }

    public Class<?> returnedClass() {
        return this.enumClass;
    }

    public Object nullSafeGet(ResultSet rs, String[] names, SessionImplementor session, Object owner) throws HibernateException, SQLException {
        Object identifier = this.type.get(rs, names[0], session);
        if (identifier == null) {
            return null;
        }
        try {
            return this.valueOfMethod.invoke(null, identifier);
        }
        catch (Exception e) {
            StringBuilder stb = new StringBuilder("Exception while invoking valueOf method '");
            stb.append(this.valueOfMethod.getName());
            stb.append("' of enumeration class '");
            stb.append(this.enumClass);
            stb.append('\'');
            throw new HibernateException(stb.toString(), (Throwable)e);
        }
    }

    public void nullSafeSet(PreparedStatement st, Object value, int index, SessionImplementor session) throws HibernateException {
        try {
            if (value == null) {
                st.setNull(index, this.type.sqlType());
            } else {
                Integer identifier = (Integer)this.identifierMethod.invoke(value, new Object[0]);
                this.type.set(st, (Object)identifier, index, session);
            }
        }
        catch (Exception e) {
            StringBuilder stb = new StringBuilder("Exception while invoking identifierMethod '");
            stb.append(this.valueOfMethod.getName());
            stb.append("' of enumeration class '");
            stb.append(this.enumClass);
            stb.append('\'');
            throw new HibernateException(stb.toString(), (Throwable)e);
        }
    }

    public int[] sqlTypes() {
        return this.sqlTypes;
    }

    public Object assemble(Serializable cached, Object owner) {
        return cached;
    }

    public Object deepCopy(Object value) {
        return value;
    }

    public Serializable disassemble(Object value) {
        return (Serializable)value;
    }

    public boolean equals(Object x, Object y) {
        return x == y;
    }

    public int hashCode(Object x) {
        return x.hashCode();
    }

    public boolean isMutable() {
        return false;
    }

    public Object replace(Object original, Object target, Object owner) {
        return original;
    }
}

