/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.scheduler.impl;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.incident.Incident;
import org.bonitasoft.engine.incident.IncidentService;
import org.bonitasoft.engine.persistence.FilterOption;
import org.bonitasoft.engine.persistence.OrderByOption;
import org.bonitasoft.engine.persistence.OrderByType;
import org.bonitasoft.engine.persistence.QueryOptions;
import org.bonitasoft.engine.persistence.SBonitaSearchException;
import org.bonitasoft.engine.scheduler.JobService;
import org.bonitasoft.engine.scheduler.exception.SSchedulerException;
import org.bonitasoft.engine.scheduler.exception.jobDescriptor.SJobDescriptorNotFoundException;
import org.bonitasoft.engine.scheduler.exception.jobDescriptor.SJobDescriptorReadException;
import org.bonitasoft.engine.scheduler.exception.jobLog.SJobLogCreationException;
import org.bonitasoft.engine.scheduler.exception.jobLog.SJobLogDeletionException;
import org.bonitasoft.engine.scheduler.impl.AbstractJobListener;
import org.bonitasoft.engine.scheduler.model.SJobDescriptor;
import org.bonitasoft.engine.scheduler.model.SJobLog;
import org.bonitasoft.engine.scheduler.model.impl.SJobLogImpl;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class JDBCJobListener
extends AbstractJobListener {
    private final JobService jobService;
    private final IncidentService incidentService;

    public JDBCJobListener(JobService jobService, IncidentService incidentService) {
        this.jobService = jobService;
        this.incidentService = incidentService;
    }

    public String getName() {
        return "JDBCJobListener";
    }

    public void jobToBeExecuted(JobExecutionContext context) {
    }

    public void jobExecutionVetoed(JobExecutionContext context) {
    }

    public void jobWasExecuted(JobExecutionContext context, JobExecutionException jobException) {
        JobDetail jobDetail = context.getJobDetail();
        Long jobDescriptorId = Long.valueOf((String)jobDetail.getJobDataMap().getWrappedMap().get("jobId"));
        try {
            if (jobException != null) {
                List<SJobLog> jobLogs = this.getJobLogs(jobDescriptorId);
                if (!jobLogs.isEmpty()) {
                    this.updateJobLog(jobException, jobLogs);
                } else {
                    this.createJobLog(jobException, jobDescriptorId);
                }
            } else {
                this.cleanJobLogIfAny(jobDescriptorId);
                this.deleteJobIfNotScheduledAnyMore(jobDescriptorId);
            }
        }
        catch (SBonitaException sbe) {
            Long tenantId = Long.valueOf((String)jobDetail.getJobDataMap().getWrappedMap().get("tenantId"));
            Incident incident = new Incident("An exception occurs during the job execution of the job descriptor" + jobDescriptorId, "", (Throwable)jobException, sbe);
            this.incidentService.report(tenantId, incident);
        }
    }

    private void createJobLog(JobExecutionException jobException, Long jobDescriptorId) throws SJobLogCreationException {
        SJobLogImpl jobLog = new SJobLogImpl(jobDescriptorId);
        jobLog.setLastMessage(this.getStackTrace(jobException));
        jobLog.setRetryNumber(0L);
        jobLog.setLastUpdateDate(System.currentTimeMillis());
        this.jobService.createJobLog(jobLog);
    }

    private void updateJobLog(JobExecutionException jobException, List<SJobLog> jobLogs) {
        SJobLogImpl jobLog = (SJobLogImpl)jobLogs.get(0);
        jobLog.setLastMessage(this.getStackTrace(jobException));
        jobLog.setLastUpdateDate(System.currentTimeMillis());
        jobLog.setRetryNumber(jobLog.getRetryNumber() + 1L);
    }

    private void deleteJobIfNotScheduledAnyMore(Long jobDescriptorId) throws SJobDescriptorNotFoundException, SJobDescriptorReadException, SSchedulerException {
        SJobDescriptor jobDescriptor = this.jobService.getJobDescriptor(jobDescriptorId);
        if (!this.getSchedulerService().isStillScheduled(jobDescriptor)) {
            this.getSchedulerService().delete(jobDescriptor.getJobName());
        }
    }

    private void cleanJobLogIfAny(Long jobDescriptorId) throws SBonitaSearchException, SJobLogDeletionException {
        List<SJobLog> jobLogs = this.getJobLogs(jobDescriptorId);
        if (!jobLogs.isEmpty()) {
            this.jobService.deleteJobLog(jobLogs.get(0));
        }
    }

    private List<SJobLog> getJobLogs(long jobDescriptorId) throws SBonitaSearchException {
        ArrayList<FilterOption> filters = new ArrayList<FilterOption>(2);
        filters.add(new FilterOption(SJobLog.class, "jobDescriptorId", jobDescriptorId));
        OrderByOption orderByOption = new OrderByOption(SJobLog.class, "jobDescriptorId", OrderByType.ASC);
        QueryOptions options = new QueryOptions(0, 1, Arrays.asList(orderByOption), filters, null);
        return this.jobService.searchJobLogs(options);
    }

    private String getStackTrace(JobExecutionException jobException) {
        StringWriter exceptionWriter = new StringWriter();
        jobException.printStackTrace(new PrintWriter(exceptionWriter));
        return exceptionWriter.toString();
    }
}

