/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.scheduler.impl;

import org.bonitasoft.engine.scheduler.JobIdentifier;
import org.bonitasoft.engine.scheduler.exception.SSchedulerException;
import org.bonitasoft.engine.scheduler.impl.QuartzJob;
import org.bonitasoft.engine.scheduler.impl.SchedulerServiceImpl;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.simpl.SimpleJobFactory;
import org.quartz.spi.TriggerFiredBundle;

public final class TransactionalSimpleJobFactory
extends SimpleJobFactory {
    private final SchedulerServiceImpl schedulerService;

    public TransactionalSimpleJobFactory(SchedulerServiceImpl schedulerService) {
        this.schedulerService = schedulerService;
    }

    public Job newJob(TriggerFiredBundle bundle, Scheduler scheduler) throws SchedulerException {
        Job newJob = super.newJob(bundle, scheduler);
        if (newJob instanceof QuartzJob) {
            QuartzJob quartzJob = (QuartzJob)newJob;
            JobDataMap jobDataMap = bundle.getJobDetail().getJobDataMap();
            Long tenantId = Long.valueOf((String)jobDataMap.get((Object)"tenantId"));
            Long jobId = Long.valueOf((String)jobDataMap.get((Object)"jobId"));
            String jobName = (String)jobDataMap.get((Object)"jobName");
            JobIdentifier jobIdentifier = new JobIdentifier(jobId, tenantId, jobName);
            try {
                quartzJob.setBosJob(this.schedulerService.getPersistedJob(jobIdentifier));
            }
            catch (SSchedulerException e) {
                throw new SchedulerException("unable to create the BOS job", (Throwable)e);
            }
            return quartzJob;
        }
        return newJob;
    }
}

