/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.tracking.csv;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Scanner;

public class CSVUtil {
    public static List<List<String>> readCSV(boolean excludeHeader, File csvFile, String csvSeparator) throws FileNotFoundException {
        ArrayList<List<String>> array = new ArrayList<List<String>>();
        FileInputStream inputStream = new FileInputStream(csvFile);
        Scanner scanner = new Scanner(inputStream);
        while (scanner.hasNextLine()) {
            String line = scanner.nextLine();
            ArrayList<String> lineElements = new ArrayList<String>();
            lineElements.addAll(Arrays.asList(line.split(csvSeparator)));
            array.add(lineElements);
        }
        scanner.close();
        if (excludeHeader) {
            array.remove(0);
        }
        return array;
    }

    public static void writeCSV(File file, List<List<String>> array, String csvSeparator) throws IOException {
        FileWriter writer = new FileWriter(file);
        for (List<String> row : array) {
            boolean first = true;
            for (String value : row) {
                if (first) {
                    writer.append(value);
                    first = false;
                    continue;
                }
                writer.append(csvSeparator);
                writer.append(value);
            }
            writer.append("\n");
            writer.flush();
        }
        writer.close();
    }

    public static String getFileTimestamp(long time) {
        StringBuilder fileSuffix = new StringBuilder();
        GregorianCalendar c = new GregorianCalendar();
        c.setTimeInMillis(time);
        fileSuffix.append(CSVUtil.getIntOnTwoNumbers(c.get(1)));
        fileSuffix.append("_");
        fileSuffix.append(CSVUtil.getIntOnTwoNumbers(c.get(2) + 1));
        fileSuffix.append("_");
        fileSuffix.append(CSVUtil.getIntOnTwoNumbers(c.get(5)));
        fileSuffix.append("_");
        fileSuffix.append(CSVUtil.getIntOnTwoNumbers(c.get(11)));
        fileSuffix.append("h");
        fileSuffix.append(CSVUtil.getIntOnTwoNumbers(c.get(12)));
        fileSuffix.append("m");
        fileSuffix.append(CSVUtil.getIntOnTwoNumbers(c.get(13)));
        fileSuffix.append("s");
        return fileSuffix.toString();
    }

    public static String getIntOnTwoNumbers(int i) {
        if (i < 10) {
            return "0" + i;
        }
        return Integer.toString(i);
    }
}

