/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.classloader;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import org.bonitasoft.engine.classloader.BonitaClassLoader;

public class VirtualClassLoader
extends ClassLoader {
    private BonitaClassLoader classloader;
    protected final String artifactType;
    protected final long artifactId;

    protected VirtualClassLoader(String artifactType, long artifactId, ClassLoader parent) {
        super(parent);
        this.artifactType = artifactType;
        this.artifactId = artifactId;
    }

    void setClassLoader(BonitaClassLoader classloader) {
        this.classloader = classloader;
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        if (this.classloader != null) {
            return this.classloader.loadClass(name, false);
        }
        return this.getParent().loadClass(name);
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        if (this.classloader != null) {
            return this.classloader.loadClass(name, resolve);
        }
        return this.getParent().loadClass(name);
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        if (this.classloader != null) {
            return this.classloader.getResourceAsStream(name);
        }
        return this.getParent().getResourceAsStream(name);
    }

    public BonitaClassLoader getClassLoader() {
        return this.classloader;
    }

    @Override
    public URL getResource(String name) {
        if (this.classloader != null) {
            return this.classloader.getResource(name);
        }
        return this.getParent().getResource(name);
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        if (this.classloader != null) {
            return this.classloader.getResources(name);
        }
        return this.getParent().getResources(name);
    }

    public void destroy() {
        if (this.classloader != null) {
            this.classloader.destroy();
        }
    }

    public String toString() {
        return super.toString() + ", type=" + this.artifactType + ", id=" + this.artifactId + " delegate: " + (Object)((Object)this.classloader);
    }
}

