/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.core.category.model.builder.impl;

import org.bonitasoft.engine.core.category.model.SCategory;
import org.bonitasoft.engine.core.category.model.builder.SCategoryBuilder;
import org.bonitasoft.engine.core.category.model.builder.SCategoryBuilderFactory;
import org.bonitasoft.engine.core.category.model.builder.impl.SCategoryBuilderImpl;
import org.bonitasoft.engine.core.category.model.impl.SCategoryImpl;

public class SCategoryBuilderFactoryImpl
implements SCategoryBuilderFactory {
    static final String ID = "id";
    static final String NAME = "name";
    static final String DESCRIPTION = "description";
    static final String CREATOR = "creator";
    static final String CREATION_DATE = "creationDate";
    static final String LAST_UPDATE_DATE = "lastUpdateDate";

    @Override
    public SCategoryBuilder createNewInstance(String name, long creator) {
        SCategoryImpl category = new SCategoryImpl(name);
        category.setCreator(creator);
        long now = System.currentTimeMillis();
        category.setCreationDate(now);
        category.setLastUpdateDate(now);
        return new SCategoryBuilderImpl(category);
    }

    @Override
    public SCategoryBuilder createNewInstance(SCategory originalCategory) {
        SCategoryImpl category = new SCategoryImpl(originalCategory);
        long now = System.currentTimeMillis();
        category.setCreationDate(now);
        category.setLastUpdateDate(now);
        return new SCategoryBuilderImpl(category);
    }

    @Override
    public String getIdKey() {
        return ID;
    }

    @Override
    public String getNameKey() {
        return NAME;
    }

    @Override
    public String getDescriptionKey() {
        return DESCRIPTION;
    }

    @Override
    public String getCreatorKey() {
        return CREATOR;
    }

    @Override
    public String getCreationDateKey() {
        return CREATION_DATE;
    }

    @Override
    public String getLastUpdateDateKey() {
        return LAST_UPDATE_DATE;
    }
}

