/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.core.process.comment.api.impl;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.bonitasoft.engine.archive.ArchiveService;
import org.bonitasoft.engine.builder.BuilderFactory;
import org.bonitasoft.engine.commons.NullCheckingUtil;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.core.process.comment.api.SCommentAddException;
import org.bonitasoft.engine.core.process.comment.api.SCommentDeletionException;
import org.bonitasoft.engine.core.process.comment.api.SCommentNotFoundException;
import org.bonitasoft.engine.core.process.comment.api.SCommentService;
import org.bonitasoft.engine.core.process.comment.api.SystemCommentType;
import org.bonitasoft.engine.core.process.comment.model.SComment;
import org.bonitasoft.engine.core.process.comment.model.archive.SAComment;
import org.bonitasoft.engine.core.process.comment.model.archive.builder.SACommentBuilderFactory;
import org.bonitasoft.engine.core.process.comment.model.builder.SHumanCommentBuilderFactory;
import org.bonitasoft.engine.core.process.comment.model.builder.SSystemCommentBuilderFactory;
import org.bonitasoft.engine.events.EventActionType;
import org.bonitasoft.engine.events.EventService;
import org.bonitasoft.engine.events.model.SDeleteEvent;
import org.bonitasoft.engine.events.model.SInsertEvent;
import org.bonitasoft.engine.events.model.builders.SEventBuilderFactory;
import org.bonitasoft.engine.persistence.FilterOption;
import org.bonitasoft.engine.persistence.OrderByOption;
import org.bonitasoft.engine.persistence.OrderByType;
import org.bonitasoft.engine.persistence.QueryOptions;
import org.bonitasoft.engine.persistence.ReadPersistenceService;
import org.bonitasoft.engine.persistence.SBonitaReadException;
import org.bonitasoft.engine.persistence.SBonitaSearchException;
import org.bonitasoft.engine.persistence.SelectByIdDescriptor;
import org.bonitasoft.engine.persistence.SelectListDescriptor;
import org.bonitasoft.engine.recorder.Recorder;
import org.bonitasoft.engine.recorder.SRecorderException;
import org.bonitasoft.engine.recorder.model.DeleteRecord;
import org.bonitasoft.engine.recorder.model.InsertRecord;
import org.bonitasoft.engine.session.SSessionNotFoundException;
import org.bonitasoft.engine.session.SessionService;
import org.bonitasoft.engine.session.model.SSession;
import org.bonitasoft.engine.sessionaccessor.ReadSessionAccessor;
import org.bonitasoft.engine.sessionaccessor.SessionIdNotSetException;

public class SCommentServiceImpl
implements SCommentService {
    private static final String SUPERVISED_BY = "SupervisedBy";
    private static final String INVOLVING_USER = "InvolvingUser";
    private static final String MANAGED_BY = "ManagedBy";
    private final Recorder recorder;
    private final ReadPersistenceService persistenceService;
    private final SessionService sessionService;
    private final ReadSessionAccessor sessionAccessor;
    private final Map<SystemCommentType, Boolean> systemCommentType;
    private final EventService eventService;
    private final ArchiveService archiveService;

    public SCommentServiceImpl(Recorder recorder, ReadPersistenceService persistenceService, ArchiveService archiveService, SessionService sessionService, ReadSessionAccessor sessionAccessor, Map<SystemCommentType, Boolean> systemCommentType, EventService eventService) {
        this.recorder = recorder;
        this.persistenceService = persistenceService;
        this.sessionService = sessionService;
        this.sessionAccessor = sessionAccessor;
        this.systemCommentType = systemCommentType;
        this.eventService = eventService;
        this.archiveService = archiveService;
    }

    private SInsertEvent getInsertEvent(Object obj) {
        return (SInsertEvent)BuilderFactory.get(SEventBuilderFactory.class).createInsertEvent("COMMENT").setObject(obj).done();
    }

    private SDeleteEvent getDeleteEvent(Object obj) {
        return (SDeleteEvent)BuilderFactory.get(SEventBuilderFactory.class).createDeleteEvent("COMMENT").setObject(obj).done();
    }

    @Override
    public List<SComment> searchComments(QueryOptions options) throws SBonitaSearchException {
        try {
            return this.persistenceService.searchEntity(SComment.class, options, null);
        }
        catch (SBonitaReadException bre) {
            throw new SBonitaSearchException(bre);
        }
    }

    @Override
    public long getNumberOfComments(QueryOptions options) throws SBonitaSearchException {
        try {
            return this.persistenceService.getNumberOfEntities(SComment.class, options, null);
        }
        catch (SBonitaReadException bre) {
            throw new SBonitaSearchException(bre);
        }
    }

    @Override
    @Deprecated
    public List<SComment> getComments(long processInstanceId) throws SBonitaReadException {
        Map<String, Object> parameters = Collections.singletonMap("processInstanceId", processInstanceId);
        OrderByOption orderByOption = new OrderByOption(SComment.class, "id", OrderByType.ASC);
        QueryOptions queryOptions = new QueryOptions(Arrays.asList(orderByOption));
        SelectListDescriptor selectDescriptor = new SelectListDescriptor("getSComments", parameters, SComment.class, queryOptions);
        return this.persistenceService.selectList(selectDescriptor);
    }

    @Override
    public List<SComment> getComments(long processInstanceId, QueryOptions queryOptions) throws SBonitaReadException {
        Map<String, Object> parameters = Collections.singletonMap("processInstanceId", processInstanceId);
        SelectListDescriptor selectDescriptor = new SelectListDescriptor("getSComments", parameters, SComment.class, queryOptions);
        return this.persistenceService.selectList(selectDescriptor);
    }

    @Override
    public SComment addComment(long processInstanceId, String comment) throws SCommentAddException {
        NullCheckingUtil.checkArgsNotNull(processInstanceId);
        NullCheckingUtil.checkArgsNotNull(comment);
        try {
            long userId = this.getUserId();
            SComment sComment = BuilderFactory.get(SHumanCommentBuilderFactory.class).createNewInstance(processInstanceId, comment, userId).done();
            InsertRecord insertRecord = new InsertRecord(sComment);
            SInsertEvent insertEvent = null;
            if (this.eventService.hasHandlers("COMMENT", EventActionType.CREATED)) {
                insertEvent = this.getInsertEvent(sComment);
            }
            this.recorder.recordInsert(insertRecord, insertEvent);
            return sComment;
        }
        catch (SRecorderException e) {
            throw new SCommentAddException(processInstanceId, "human", e);
        }
        catch (SSessionNotFoundException e) {
            throw new SCommentAddException("Session is not found.", e);
        }
    }

    @Override
    public SComment addSystemComment(long processInstanceId, String comment) throws SCommentAddException {
        NullCheckingUtil.checkArgsNotNull(processInstanceId);
        NullCheckingUtil.checkArgsNotNull(comment);
        try {
            SComment sComment = BuilderFactory.get(SSystemCommentBuilderFactory.class).createNewInstance(processInstanceId, comment, null).done();
            InsertRecord insertRecord = new InsertRecord(sComment);
            SInsertEvent insertEvent = null;
            if (this.eventService.hasHandlers("COMMENT", EventActionType.CREATED)) {
                insertEvent = this.getInsertEvent(sComment);
            }
            this.recorder.recordInsert(insertRecord, insertEvent);
            return sComment;
        }
        catch (SRecorderException e) {
            throw new SCommentAddException(processInstanceId, "system", e);
        }
    }

    @Override
    public void delete(SComment comment) throws SCommentDeletionException {
        NullCheckingUtil.checkArgsNotNull(comment);
        try {
            DeleteRecord deleteRecord = new DeleteRecord(comment);
            SDeleteEvent deleteEvent = null;
            if (this.eventService.hasHandlers("COMMENT", EventActionType.DELETED)) {
                deleteEvent = this.getDeleteEvent(comment);
            }
            this.recorder.recordDelete(deleteRecord, deleteEvent);
        }
        catch (SRecorderException e) {
            throw new SCommentDeletionException("Can't delete the comment " + comment, e);
        }
    }

    @Override
    public void deleteComments(long processInstanceId) throws SBonitaException {
        List<SComment> sComments = null;
        do {
            if ((sComments = this.getComments(processInstanceId, new QueryOptions(0, 100))) == null) continue;
            for (SComment sComment : sComments) {
                this.delete(sComment);
            }
        } while (sComments != null && sComments.size() > 0);
    }

    private long getUserId() throws SSessionNotFoundException {
        long sessionId;
        try {
            sessionId = this.sessionAccessor.getSessionId();
        }
        catch (SessionIdNotSetException e) {
            return -1L;
        }
        SSession session = this.sessionService.getSession(sessionId);
        return session.getUserId();
    }

    @Override
    public long getNumberOfCommentsSupervisedBy(long supervisorId, QueryOptions queryOptions) throws SBonitaSearchException {
        try {
            Map<String, Object> parameters = Collections.singletonMap("supervisorId", supervisorId);
            return this.persistenceService.getNumberOfEntities(SComment.class, SUPERVISED_BY, queryOptions, parameters);
        }
        catch (SBonitaReadException bre) {
            throw new SBonitaSearchException(bre);
        }
    }

    @Override
    public List<SComment> searchCommentsSupervisedBy(long supervisorId, QueryOptions queryOptions) throws SBonitaSearchException {
        try {
            Map<String, Object> parameters = Collections.singletonMap("supervisorId", supervisorId);
            return this.persistenceService.searchEntity(SComment.class, SUPERVISED_BY, queryOptions, parameters);
        }
        catch (SBonitaReadException bre) {
            throw new SBonitaSearchException(bre);
        }
    }

    @Override
    public long getNumberOfCommentsInvolvingUser(long userId, QueryOptions searchOptions) throws SBonitaSearchException {
        try {
            Map<String, Object> parameters = Collections.singletonMap("userId", userId);
            return this.persistenceService.getNumberOfEntities(SComment.class, INVOLVING_USER, searchOptions, parameters);
        }
        catch (SBonitaReadException bre) {
            throw new SBonitaSearchException(bre);
        }
    }

    @Override
    public List<SComment> searchCommentsInvolvingUser(long userId, QueryOptions queryOptions) throws SBonitaSearchException {
        try {
            Map<String, Object> parameters = Collections.singletonMap("userId", userId);
            return this.persistenceService.searchEntity(SComment.class, INVOLVING_USER, queryOptions, parameters);
        }
        catch (SBonitaReadException bre) {
            throw new SBonitaSearchException(bre);
        }
    }

    @Override
    public long getNumberOfCommentsManagedBy(long managerUserId, QueryOptions searchOptions) throws SBonitaSearchException {
        try {
            Map<String, Object> parameters = Collections.singletonMap("managerUserId", managerUserId);
            return this.persistenceService.getNumberOfEntities(SComment.class, MANAGED_BY, searchOptions, parameters);
        }
        catch (SBonitaReadException bre) {
            throw new SBonitaSearchException(bre);
        }
    }

    @Override
    public List<SComment> searchCommentsManagedBy(long managerUserId, QueryOptions searchOptions) throws SBonitaSearchException {
        try {
            Map<String, Object> parameters = Collections.singletonMap("managerUserId", managerUserId);
            return this.persistenceService.searchEntity(SComment.class, MANAGED_BY, searchOptions, parameters);
        }
        catch (SBonitaReadException bre) {
            throw new SBonitaSearchException(bre);
        }
    }

    @Override
    public long getNumberOfArchivedComments(QueryOptions searchOptions) throws SBonitaSearchException {
        ReadPersistenceService persistenceService = this.archiveService.getDefinitiveArchiveReadPersistenceService();
        try {
            return persistenceService.getNumberOfEntities(SAComment.class, searchOptions, null);
        }
        catch (SBonitaReadException e) {
            throw new SBonitaSearchException(e);
        }
    }

    @Override
    public List<SAComment> searchArchivedComments(QueryOptions searchOptions) throws SBonitaSearchException {
        ReadPersistenceService persistenceService = this.archiveService.getDefinitiveArchiveReadPersistenceService();
        try {
            return persistenceService.searchEntity(SAComment.class, searchOptions, null);
        }
        catch (SBonitaReadException e) {
            throw new SBonitaSearchException(e);
        }
    }

    @Override
    public boolean isCommentEnabled(SystemCommentType sct) {
        if (this.systemCommentType.containsKey((Object)sct)) {
            return this.systemCommentType.get((Object)sct);
        }
        return false;
    }

    @Override
    public SAComment getArchivedComment(long archivedCommentId) throws SCommentNotFoundException, SBonitaReadException {
        ReadPersistenceService persistenceService = this.archiveService.getDefinitiveArchiveReadPersistenceService();
        SAComment selectById = persistenceService.selectById(new SelectByIdDescriptor<SAComment>("getArchivedCommentById", SAComment.class, archivedCommentId));
        if (selectById == null) {
            throw new SCommentNotFoundException("Archived comment not found with id=" + archivedCommentId);
        }
        return selectById;
    }

    @Override
    public void deleteArchivedComments(long processInstanceId) throws SBonitaException {
        List<FilterOption> filters = Collections.singletonList(new FilterOption(SAComment.class, BuilderFactory.get(SACommentBuilderFactory.class).getProcessInstanceIdKey(), processInstanceId));
        List<OrderByOption> orderByOptions = Collections.singletonList(new OrderByOption(SAComment.class, BuilderFactory.get(SACommentBuilderFactory.class).getIdKey(), OrderByType.ASC));
        List<SAComment> searchArchivedComments = null;
        QueryOptions queryOptions = new QueryOptions(0, 100, orderByOptions, filters, null);
        do {
            searchArchivedComments = this.searchArchivedComments(queryOptions);
            for (SAComment saComment : searchArchivedComments) {
                this.archiveService.recordDelete(new DeleteRecord(saComment));
            }
        } while (!searchArchivedComments.isEmpty());
    }
}

