/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.persistence;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.bonitasoft.engine.persistence.DBConfiguration;

public class DBConfigurationsProvider {
    private List<DBConfiguration> tenantConfigurations;

    public void setTenantConfigurations(List<DBConfiguration> tenantConfigurations) {
        this.tenantConfigurations = tenantConfigurations;
        Collections.sort(this.tenantConfigurations, new Comparator<DBConfiguration>(){

            @Override
            public int compare(DBConfiguration dbConfiguration1, DBConfiguration dbConfiguration2) {
                int priority1 = dbConfiguration1.getDeleteTenantObjectsPriority();
                int priority2 = dbConfiguration2.getDeleteTenantObjectsPriority();
                return priority1 - priority2;
            }
        });
    }

    public List<DBConfiguration> getTenantConfigurations() {
        return this.tenantConfigurations;
    }

    public List<DBConfiguration> getMatchingTenantConfigurations(String filter) {
        if (filter == null || filter.isEmpty()) {
            return this.getTenantConfigurations();
        }
        return this.filterTenantConfiguration(filter);
    }

    private List<DBConfiguration> filterTenantConfiguration(String filter) {
        ArrayList<DBConfiguration> matchingTenantConfiguration = new ArrayList<DBConfiguration>();
        for (DBConfiguration dbConfiguration : this.tenantConfigurations) {
            if (!dbConfiguration.matchesFilter(filter)) continue;
            matchingTenantConfiguration.add(dbConfiguration);
        }
        return matchingTenantConfiguration;
    }
}

