/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.queriablelogger.model.builder.impl;

import java.util.ArrayList;
import java.util.List;
import org.bonitasoft.engine.queriablelogger.model.SQueriableLog;
import org.bonitasoft.engine.queriablelogger.model.SQueriableLogSeverity;
import org.bonitasoft.engine.queriablelogger.model.builder.SQueriableLogBuilder;
import org.bonitasoft.engine.queriablelogger.model.builder.impl.MissingMandatoryFieldsException;
import org.bonitasoft.engine.queriablelogger.model.impl.SQueriableLogImpl;

public class SQueriableLogBuilderImpl
implements SQueriableLogBuilder {
    private final SQueriableLogImpl entity;

    public SQueriableLogBuilderImpl() {
        this.entity = new SQueriableLogImpl();
    }

    public SQueriableLogBuilderImpl(SQueriableLogImpl entity) {
        this.entity = entity;
    }

    public SQueriableLogBuilderImpl(SQueriableLog log) {
        SQueriableLogImpl local = null;
        if (log instanceof SQueriableLogImpl) {
            local = (SQueriableLogImpl)log;
        }
        if (local == null) {
            local = new SQueriableLogImpl();
        }
        this.entity = local;
    }

    @Override
    public SQueriableLogBuilder userId(String userId) {
        this.entity.setUserId(userId);
        return this;
    }

    @Override
    public SQueriableLogBuilder clusterNode(String clusterNode) {
        this.entity.setClusterNode(clusterNode);
        return this;
    }

    @Override
    public SQueriableLogBuilder productVersion(String productVersion) {
        this.entity.setProductVersion(productVersion);
        return this;
    }

    @Override
    public SQueriableLogBuilder severity(SQueriableLogSeverity severity) {
        this.entity.setSeverity(severity);
        return this;
    }

    @Override
    public SQueriableLogBuilder actionType(String actionType) {
        this.entity.setActionType(actionType);
        return this;
    }

    @Override
    public SQueriableLogBuilder actionScope(String scope) {
        this.entity.setActionScope(scope);
        return this;
    }

    @Override
    public SQueriableLogBuilder actionStatus(int status) {
        this.entity.setActionStatus(status);
        return this;
    }

    @Override
    public SQueriableLogBuilder rawMessage(String rawMessage) {
        this.entity.setRawMessage(rawMessage);
        return this;
    }

    @Override
    public SQueriableLogBuilder callerClassName(String callerClassName) {
        this.entity.setCallerClassName(callerClassName);
        return this;
    }

    @Override
    public SQueriableLogBuilder callerMethodName(String callerMethodName) {
        this.entity.setCallerMethodName(callerMethodName);
        return this;
    }

    @Override
    public SQueriableLogBuilder numericIndex(int pos, long value) {
        this.entity.setNumericIndex(pos, value);
        return this;
    }

    @Override
    public SQueriableLog done() {
        List<String> problems = this.checkMandatoryFields();
        if (problems.size() > 0) {
            throw new MissingMandatoryFieldsException("Some mandatoryFildes are missing: " + problems);
        }
        return this.entity;
    }

    private List<String> checkMandatoryFields() {
        ArrayList<String> problems = new ArrayList<String>();
        if (this.entity.getSeverity() == null) {
            problems.add("severity");
        }
        if (this.entity.getActionType() == null) {
            problems.add("actionType");
        }
        if (0 != this.entity.getActionStatus() && this.entity.getActionScope() == null) {
            problems.add("actionScope");
        }
        if (this.entity.getActionStatus() != 0 && this.entity.getActionStatus() != 1) {
            problems.add("actionStatus (must be 0, for fail or 1, for ok)");
        }
        if (this.entity.getRawMessage() == null) {
            problems.add("rawMessage");
        }
        return problems;
    }
}

