/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.service.impl;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.bonitasoft.engine.exception.BonitaHomeNotSetException;
import org.bonitasoft.engine.exception.MissingServiceException;
import org.bonitasoft.engine.home.BonitaHomeServer;
import org.bonitasoft.engine.service.impl.AbsoluteFileSystemXmlApplicationContext;
import org.bonitasoft.engine.service.impl.SpringPlatformFileSystemBeanAccessor;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.PropertyPlaceholderConfigurer;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.FileSystemXmlApplicationContext;

public class SpringTenantFileSystemBeanAccessor {
    protected static final String TENANT_ID = "tenantId";
    protected AbsoluteFileSystemXmlApplicationContext context;
    private final long tenantId;

    public SpringTenantFileSystemBeanAccessor(long tenantId) {
        this.tenantId = tenantId;
    }

    private String[] getResources() {
        BonitaHomeServer homeServer = BonitaHomeServer.getInstance();
        try {
            String tenantConfFolder = homeServer.getTenantConfFolder(this.tenantId);
            File serviceFolder = new File(tenantConfFolder + File.separatorChar + "services");
            if (!serviceFolder.isDirectory()) {
                throw new RuntimeException("Your bonita.home is corrupted: Folder 'services' not found on tenant " + tenantConfFolder);
            }
            FileFilter filter = new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname.isFile() && pathname.getName().endsWith(".xml");
                }
            };
            File[] listFiles = serviceFolder.listFiles(filter);
            List<File> listFilesCollection = Arrays.asList(listFiles);
            Collections.sort(listFilesCollection);
            listFiles = listFilesCollection.toArray(new File[listFilesCollection.size()]);
            if (listFiles.length == 0) {
                throw new RuntimeException("No file found");
            }
            String[] resources = new String[listFiles.length];
            for (int i = 0; i < listFiles.length; ++i) {
                try {
                    resources[i] = listFiles[i].getCanonicalPath();
                    continue;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            return resources;
        }
        catch (BonitaHomeNotSetException e) {
            throw new RuntimeException("Bonita home not set");
        }
    }

    public <T> T getService(Class<T> serviceClass) {
        try {
            return (T)this.getContext().getBean(serviceClass);
        }
        catch (NoSuchBeanDefinitionException e) {
            throw new MissingServiceException("Service not found: " + serviceClass.getName());
        }
    }

    protected <T> T getService(String name, Class<T> serviceClass) {
        return (T)this.getContext().getBean(name, serviceClass);
    }

    protected <T> T getService(String name) {
        return (T)this.getContext().getBean(name);
    }

    protected FileSystemXmlApplicationContext getContext() {
        if (this.context == null) {
            this.initializeContext(null);
        }
        return this.context;
    }

    public synchronized void initializeContext(ClassLoader classLoader) {
        if (this.context == null) {
            Properties properties = this.findBonitaServerTenantProperties(this.tenantId);
            properties.put(TENANT_ID, String.valueOf(this.tenantId));
            PropertyPlaceholderConfigurer ppc = new PropertyPlaceholderConfigurer();
            ppc.setProperties(properties);
            SpringPlatformFileSystemBeanAccessor.initializeContext(classLoader);
            FileSystemXmlApplicationContext platformContext = SpringPlatformFileSystemBeanAccessor.getContext();
            AbsoluteFileSystemXmlApplicationContext localContext = this.createFileSystemApplicationContext(platformContext);
            localContext.addBeanFactoryPostProcessor((BeanFactoryPostProcessor)ppc);
            localContext.refresh();
            this.context = localContext;
        }
    }

    protected AbsoluteFileSystemXmlApplicationContext createFileSystemApplicationContext(FileSystemXmlApplicationContext platformContext) {
        AbsoluteFileSystemXmlApplicationContext localContext = new AbsoluteFileSystemXmlApplicationContext(this.getResources(), false, (ApplicationContext)platformContext);
        return localContext;
    }

    protected Properties findBonitaServerTenantProperties(long tenantId) {
        BonitaHomeServer homeServer = BonitaHomeServer.getInstance();
        try {
            return homeServer.getTenantProperties(tenantId);
        }
        catch (BonitaHomeNotSetException e) {
            throw new RuntimeException("Bonita home not set !!");
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to read tenant properties file", e);
        }
    }

    public void destroy() {
        if (this.context != null) {
            this.context.close();
            this.context = null;
        }
    }
}

