/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.api.impl.transaction.profile;

import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.commons.transaction.TransactionContentWithResult;
import org.bonitasoft.engine.identity.IdentityService;
import org.bonitasoft.engine.identity.MemberType;
import org.bonitasoft.engine.identity.model.SGroup;
import org.bonitasoft.engine.identity.model.SRole;
import org.bonitasoft.engine.identity.model.SUser;
import org.bonitasoft.engine.profile.ProfileService;
import org.bonitasoft.engine.profile.model.SProfileMember;

public class CreateProfileMember
implements TransactionContentWithResult<SProfileMember> {
    private final ProfileService profileService;
    private final IdentityService identityService;
    private final long profileId;
    private final Long userId;
    private final Long groupId;
    private final Long roleId;
    private final MemberType memberType;
    private SProfileMember sProfileMember;

    public CreateProfileMember(ProfileService profileService, IdentityService identityService, long profileId, Long userId, Long groupId, Long roleId, MemberType memberType) {
        this.profileService = profileService;
        this.identityService = identityService;
        this.profileId = profileId;
        this.userId = userId;
        this.groupId = groupId;
        this.roleId = roleId;
        this.memberType = memberType;
    }

    @Override
    public void execute() throws SBonitaException {
        this.profileService.updateProfileMetaData(this.profileId);
        SUser user = null;
        SGroup group = null;
        SRole role = null;
        if (this.userId != null && this.userId > 0L) {
            user = this.identityService.getUser(this.userId);
        }
        if (this.groupId != null && this.groupId > 0L) {
            group = this.identityService.getGroup(this.groupId);
        }
        if (this.roleId != null && this.roleId > 0L) {
            role = this.identityService.getRole(this.roleId);
        }
        switch (this.memberType) {
            case USER: {
                this.sProfileMember = this.profileService.addUserToProfile(this.profileId, this.userId, user.getUserName(), user.getLastName(), user.getUserName());
                break;
            }
            case GROUP: {
                this.sProfileMember = this.profileService.addGroupToProfile(this.profileId, this.groupId, group.getName(), group.getParentPath());
                break;
            }
            case ROLE: {
                this.sProfileMember = this.profileService.addRoleToProfile(this.profileId, this.roleId, role.getName());
                break;
            }
            default: {
                this.sProfileMember = this.profileService.addRoleAndGroupToProfile(this.profileId, this.roleId, this.groupId, role.getName(), group.getName(), group.getParentPath());
            }
        }
    }

    @Override
    public SProfileMember getResult() {
        return this.sProfileMember;
    }
}

