/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.external.permission;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bonitasoft.engine.actor.mapping.ActorMappingService;
import org.bonitasoft.engine.actor.mapping.model.SActor;
import org.bonitasoft.engine.command.SCommandExecutionException;
import org.bonitasoft.engine.command.SCommandParameterizationException;
import org.bonitasoft.engine.command.TenantCommand;
import org.bonitasoft.engine.identity.IdentityService;
import org.bonitasoft.engine.identity.SUserNotFoundException;
import org.bonitasoft.engine.persistence.SBonitaReadException;
import org.bonitasoft.engine.service.TenantServiceAccessor;

public class IsAllowedToStartProcesses
extends TenantCommand {
    private TenantServiceAccessor serviceAccessor;
    private static final String PROCESSDEFINITION_IDS_KEY = "PROCESSDEFINITION_IDS_KEY";
    private static final String USER_ID_KEY = "USER_ID_KEY";

    @Override
    public Serializable execute(Map<String, Serializable> parameters, TenantServiceAccessor serviceAccessor) throws SCommandParameterizationException, SCommandExecutionException {
        this.serviceAccessor = serviceAccessor;
        ActorMappingService actorMappingService = this.serviceAccessor.getActorMappingService();
        HashMap<Long, Boolean> resMap = new HashMap<Long, Boolean>();
        List processDefinitionIds = (List)((Object)parameters.get(PROCESSDEFINITION_IDS_KEY));
        if (processDefinitionIds == null) {
            throw new SCommandParameterizationException("Mandatory parameter PROCESSDEFINITION_IDS_KEY is missing or not convertible to List<Long>.");
        }
        long userId = (Long)parameters.get(USER_ID_KEY);
        if (userId == 0L) {
            throw new SCommandParameterizationException("Mandatory parameter USER_ID_KEY is missing or not convertible to Long.");
        }
        this.checkIfUserExists(userId);
        if (!processDefinitionIds.isEmpty()) {
            for (Long processDefinitionId : processDefinitionIds) {
                try {
                    List<SActor> ckRes = actorMappingService.getActorsOfUserCanStartProcessDefinition(userId, processDefinitionId, 0, Integer.MAX_VALUE);
                    if (ckRes != null && ckRes.size() == 1) {
                        resMap.put(processDefinitionId, true);
                        continue;
                    }
                    resMap.put(processDefinitionId, false);
                }
                catch (SBonitaReadException e) {
                    e.setProcessDefinitionIdOnContext(processDefinitionId);
                    throw new SCommandExecutionException("No actor of user who can start the processDefinition.", e);
                }
            }
        }
        return resMap;
    }

    private void checkIfUserExists(long userId) throws SCommandParameterizationException {
        try {
            IdentityService identityService = this.serviceAccessor.getIdentityService();
            identityService.getUser(userId);
        }
        catch (SUserNotFoundException e) {
            throw new SCommandParameterizationException("No such user refer to this userId :" + userId, e);
        }
    }
}

