/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.external.process;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.bonitasoft.engine.builder.BuilderFactory;
import org.bonitasoft.engine.command.SCommandExecutionException;
import org.bonitasoft.engine.command.SCommandParameterizationException;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.core.expression.control.model.SExpressionContext;
import org.bonitasoft.engine.core.operation.OperationService;
import org.bonitasoft.engine.core.operation.model.SOperation;
import org.bonitasoft.engine.core.process.definition.model.builder.ServerModelConvertor;
import org.bonitasoft.engine.core.process.instance.model.builder.SAutomaticTaskInstanceBuilderFactory;
import org.bonitasoft.engine.data.instance.api.DataInstanceContainer;
import org.bonitasoft.engine.external.process.UpdateVariableValuesThroughOperations;
import org.bonitasoft.engine.operation.Operation;
import org.bonitasoft.engine.service.TenantServiceAccessor;

public class GetUpdatedVariableValuesForActivityInstance
extends UpdateVariableValuesThroughOperations {
    private static final String ACTIVITY_INSTANCE_ID_KEY = "ACTIVITY_INSTANCE_ID_KEY";
    TenantServiceAccessor serviceAccessor;

    @Override
    public Serializable execute(Map<String, Serializable> parameters, TenantServiceAccessor serviceAccessor) throws SCommandParameterizationException, SCommandExecutionException {
        long activityInstanceId;
        Map currentVariableValues;
        Map operationsInputValues;
        List operations;
        this.serviceAccessor = serviceAccessor;
        try {
            operations = (List)((Object)parameters.get("OPERATIONS_LIST_KEY"));
            operationsInputValues = (Map)((Object)parameters.get("OPERATIONS_INPUT_KEY"));
            currentVariableValues = (Map)((Object)parameters.get("CURRENT_VARIABLE_VALUES_MAP_KEY"));
            activityInstanceId = (Long)parameters.get(ACTIVITY_INSTANCE_ID_KEY);
        }
        catch (Exception e) {
            throw new SCommandParameterizationException("Mandatory parameter OPERATIONS_LIST_KEY/OPERATIONS_INPUT_KEY/CURRENT_VARIABLE_VALUES_MAP_KEY/ACTIVITY_INSTANCE_ID_KEY is missing or not convertible.");
        }
        if (operations == null || operationsInputValues == null || currentVariableValues == null) {
            throw new SCommandParameterizationException("Mandatory parameter OPERATIONS_LIST_KEY/OPERATIONS_INPUT_KEY/CURRENT_VARIABLE_VALUES_MAP_KEY/ACTIVITY_INSTANCE_ID_KEY is missing or not convertible.");
        }
        try {
            this.updateVariablesThroughOperations(operations, operationsInputValues, currentVariableValues, activityInstanceId);
        }
        catch (SCommandExecutionException e) {
            throw e;
        }
        catch (SBonitaException e) {
            throw new SCommandExecutionException(e);
        }
        return (Serializable)((Object)currentVariableValues);
    }

    @Override
    protected void executeOperation(Operation operation, Map<String, Serializable> operationsInputValues, Map<String, Serializable> currentVariableValues, long activityInstanceId) throws SBonitaException {
        if (currentVariableValues != null) {
            SOperation sOperation = ServerModelConvertor.convertOperation(operation);
            Map<String, Serializable> inputValues = operationsInputValues;
            inputValues.putAll(currentVariableValues);
            SExpressionContext sec = new SExpressionContext();
            sec.setSerializableInputValues(inputValues);
            sec.setContainerId(activityInstanceId);
            sec.setContainerType(DataInstanceContainer.ACTIVITY_INSTANCE.name());
            OperationService operationService = this.serviceAccessor.getOperationService();
            operationService.execute(sOperation, -1L, null, sec);
            for (Map.Entry<String, Serializable> variable : currentVariableValues.entrySet()) {
                Object updatedValue = sec.getInputValues().get(variable.getKey());
                variable.setValue((Serializable)updatedValue);
            }
        }
    }

    @Override
    public TenantServiceAccessor getServiceAccessor() {
        return this.serviceAccessor;
    }

    @Override
    public long getProcessDefinitionId(long containerInstanceId) throws SBonitaException {
        return this.serviceAccessor.getActivityInstanceService().getActivityInstance(containerInstanceId).getLogicalGroup(BuilderFactory.get(SAutomaticTaskInstanceBuilderFactory.class).getProcessDefinitionIndex());
    }
}

