/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.lock.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.bonitasoft.engine.lock.BonitaLock;
import org.bonitasoft.engine.lock.LockService;
import org.bonitasoft.engine.lock.SLockException;
import org.bonitasoft.engine.log.technical.TechnicalLogSeverity;
import org.bonitasoft.engine.log.technical.TechnicalLoggerService;
import org.bonitasoft.engine.sessionaccessor.ReadSessionAccessor;
import org.bonitasoft.engine.sessionaccessor.STenantIdNotSetException;

public final class MemoryLockConditionService
implements LockService {
    private final Map<Integer, ReentrantLock> locks;
    private static final String SEPARATOR = "_";
    protected final TechnicalLoggerService logger;
    protected final int lockTimeout;
    private final ReadSessionAccessor sessionAccessor;
    protected final boolean debugEnable;
    private final boolean traceEnable;
    private final Map<String, Pair> waiters;
    private final int lockPoolSize;

    public MemoryLockConditionService(TechnicalLoggerService logger, ReadSessionAccessor sessionAccessor, int lockTimeout, int lockPoolSize) {
        this.logger = logger;
        this.sessionAccessor = sessionAccessor;
        this.lockTimeout = lockTimeout;
        this.debugEnable = logger.isLoggable(this.getClass(), TechnicalLogSeverity.DEBUG);
        this.traceEnable = true;
        this.waiters = new HashMap<String, Pair>();
        this.lockPoolSize = lockPoolSize;
        HashMap<Integer, MemoryLockConditionServiceReentrantLock> tmpLocks = new HashMap<Integer, MemoryLockConditionServiceReentrantLock>();
        for (int i = 0; i < lockPoolSize; ++i) {
            tmpLocks.put(i, new MemoryLockConditionServiceReentrantLock());
        }
        this.locks = Collections.unmodifiableMap(tmpLocks);
    }

    private Lock getLock(long objectToLockId) {
        int poolKeyForThisObjectId = Long.valueOf(objectToLockId % (long)this.lockPoolSize).intValue();
        if (!this.locks.containsKey(poolKeyForThisObjectId)) {
            throw new RuntimeException("No lock defined for objectToLockId '" + objectToLockId + "' with generated key '" + poolKeyForThisObjectId + "'");
        }
        return this.locks.get(poolKeyForThisObjectId);
    }

    @Override
    public BonitaLock tryLock(long objectToLockId, String objectType, long timeout, TimeUnit timeUnit, long tenantId) {
        try {
            return this.innerTryLock(objectToLockId, objectType, timeout, timeUnit);
        }
        catch (SLockException e) {
            return null;
        }
    }

    @Override
    public BonitaLock lock(long objectToLockId, String objectType, long tenantId) throws SLockException {
        return this.innerTryLock(objectToLockId, objectType, this.lockTimeout, TimeUnit.SECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BonitaLock innerTryLock(long objectToLockId, String objectType, long timeout, TimeUnit timeUnit) throws SLockException {
        long time;
        TechnicalLogSeverity severity;
        Lock lock;
        long before;
        String key;
        block19: {
            key = this.buildKey(objectToLockId, objectType);
            before = System.currentTimeMillis();
            lock = this.getLock(objectToLockId);
            if (this.traceEnable) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, "lock " + lock.hashCode() + " id=" + key);
            }
            lock.lock();
            try {
                Condition condition = null;
                if (this.waiters.containsKey(key)) {
                    Pair waiter = this.waiters.get(key);
                    if (this.debugEnable) {
                        this.logger.log(this.getClass(), TechnicalLogSeverity.DEBUG, Thread.currentThread().getName() + " - Locking (" + key + ") waiter found: " + waiter);
                    }
                    waiter.count.getAndIncrement();
                    condition = waiter.condition;
                    boolean lockObtained = false;
                    try {
                        if (this.traceEnable) {
                            this.logger.log(this.getClass(), TechnicalLogSeverity.DEBUG, Thread.currentThread().getName() + " - Locking (" + key + ") awaiting condition: " + condition, new Exception("Forced exception to get Thread dump stack"));
                        } else if (this.debugEnable) {
                            this.logger.log(this.getClass(), TechnicalLogSeverity.DEBUG, Thread.currentThread().getName() + " - Locking (" + key + ") awaiting condition: " + condition);
                        }
                        lockObtained = condition.await(timeout, timeUnit);
                        if (this.traceEnable) {
                            this.logger.log(this.getClass(), TechnicalLogSeverity.DEBUG, Thread.currentThread().getName() + " - Lock (" + key + ") obtained: " + lockObtained + " on condition: " + condition, new Exception("Forced exception to get Thread dump stack"));
                        } else if (this.debugEnable) {
                            this.logger.log(this.getClass(), TechnicalLogSeverity.DEBUG, Thread.currentThread().getName() + " - Lock (" + key + ") obtained: " + lockObtained + " on condition: " + condition);
                        }
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    if (!lockObtained) {
                        throw new SLockException("Timeout trying to lock " + key);
                    }
                    break block19;
                }
                condition = lock.newCondition();
                if (this.debugEnable) {
                    this.logger.log(this.getClass(), TechnicalLogSeverity.DEBUG, Thread.currentThread().getName() + " - Locking (" + key + ") no waiter found for key, creating a new waiter on condition: " + condition);
                }
                this.waiters.put(key, new Pair(condition));
            }
            finally {
                lock.unlock();
            }
        }
        if (this.traceEnable) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, "locked " + lock.hashCode() + " id=" + key);
        }
        if ((severity = this.selectSeverity(time = System.currentTimeMillis() - before)) != null) {
            this.logger.log(this.getClass(), severity, "The bocking call to lock for the key " + key + " took " + time + "ms.");
            if (TechnicalLogSeverity.DEBUG.equals((Object)severity)) {
                this.logger.log(this.getClass(), severity, new Exception("Stack trace : lock for the key " + key));
            }
        }
        return new BonitaLock(lock, objectType, objectToLockId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unlock(BonitaLock bonitaLock, long tenantId) throws SLockException {
        String key = this.buildKey(bonitaLock.getObjectToLockId(), bonitaLock.getObjectType());
        if (this.traceEnable) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, "will unlock " + bonitaLock.getLock().hashCode() + " id=" + key);
        }
        Lock lock = this.getLock(bonitaLock.getObjectToLockId());
        lock.lock();
        try {
            Pair waiter = this.waiters.get(key);
            if (this.debugEnable) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.DEBUG, Thread.currentThread().getName() + " - Unlocking (" + key + ") waiter found: " + waiter);
            }
            if (waiter == null) {
                throw new SLockException("Unable to unlock an unexisting lock for key: " + key);
            }
            waiter.count.getAndDecrement();
            if (waiter.count.get() == 0) {
                if (this.debugEnable) {
                    this.logger.log(this.getClass(), TechnicalLogSeverity.DEBUG, Thread.currentThread().getName() + " - Unlocking (" + key + ") removing condition");
                }
                this.waiters.remove(key);
            }
            if (this.debugEnable) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.DEBUG, Thread.currentThread().getName() + " - Unlocking (" + key + ") signaling condition: " + waiter.condition);
            }
            waiter.condition.signal();
        }
        finally {
            lock.unlock();
        }
        if (this.traceEnable) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, "unlock " + bonitaLock.getLock().hashCode() + " id=" + key);
        }
    }

    private TechnicalLogSeverity selectSeverity(long time) {
        if (time > 150L) {
            return TechnicalLogSeverity.INFO;
        }
        if (time > 50L) {
            return TechnicalLogSeverity.DEBUG;
        }
        return null;
    }

    protected String buildKey(long objectToLockId, String objectType) {
        try {
            return objectType + SEPARATOR + objectToLockId + SEPARATOR + this.sessionAccessor.getTenantId();
        }
        catch (STenantIdNotSetException e) {
            throw new IllegalStateException("Tenant not set");
        }
    }

    private static final class MemoryLockConditionServiceReentrantLock
    extends ReentrantLock {
        private static final long serialVersionUID = -5057082500079127968L;

        private MemoryLockConditionServiceReentrantLock() {
        }
    }

    private static class Pair {
        final Condition condition;
        final AtomicInteger count = new AtomicInteger(1);

        public Pair(Condition condition) {
            this.condition = condition;
        }

        public String toString() {
            return "Pair [condition=" + this.condition + ", count=" + this.count + "]";
        }
    }
}

