/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.platform.impl;

import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bonitasoft.engine.builder.BuilderFactory;
import org.bonitasoft.engine.cache.PlatformCacheService;
import org.bonitasoft.engine.cache.SCacheException;
import org.bonitasoft.engine.commons.CollectionUtil;
import org.bonitasoft.engine.commons.LogUtil;
import org.bonitasoft.engine.log.technical.TechnicalLogSeverity;
import org.bonitasoft.engine.log.technical.TechnicalLoggerService;
import org.bonitasoft.engine.persistence.OrderByType;
import org.bonitasoft.engine.persistence.PersistentObject;
import org.bonitasoft.engine.persistence.QueryOptions;
import org.bonitasoft.engine.persistence.SBonitaReadException;
import org.bonitasoft.engine.persistence.SBonitaSearchException;
import org.bonitasoft.engine.persistence.SelectByIdDescriptor;
import org.bonitasoft.engine.persistence.SelectListDescriptor;
import org.bonitasoft.engine.persistence.SelectOneDescriptor;
import org.bonitasoft.engine.platform.PlatformService;
import org.bonitasoft.engine.platform.SDeletingActivatedTenantException;
import org.bonitasoft.engine.platform.SPlatformCreationException;
import org.bonitasoft.engine.platform.SPlatformDeletionException;
import org.bonitasoft.engine.platform.SPlatformNotFoundException;
import org.bonitasoft.engine.platform.SPlatformUpdateException;
import org.bonitasoft.engine.platform.STenantActivationException;
import org.bonitasoft.engine.platform.STenantAlreadyExistException;
import org.bonitasoft.engine.platform.STenantCreationException;
import org.bonitasoft.engine.platform.STenantDeactivationException;
import org.bonitasoft.engine.platform.STenantDeletionException;
import org.bonitasoft.engine.platform.STenantException;
import org.bonitasoft.engine.platform.STenantNotFoundException;
import org.bonitasoft.engine.platform.STenantUpdateException;
import org.bonitasoft.engine.platform.model.SPlatform;
import org.bonitasoft.engine.platform.model.SPlatformProperties;
import org.bonitasoft.engine.platform.model.STenant;
import org.bonitasoft.engine.platform.model.builder.STenantBuilderFactory;
import org.bonitasoft.engine.recorder.model.EntityUpdateDescriptor;
import org.bonitasoft.engine.services.PersistenceService;
import org.bonitasoft.engine.services.SPersistenceException;
import org.bonitasoft.engine.services.TenantPersistenceService;
import org.bonitasoft.engine.services.UpdateDescriptor;

public class PlatformServiceImpl
implements PlatformService {
    private static final String LOG_ACTIVATE_TENANT = "activateTenant";
    private static final String LOG_DELETE_TENANT_OBJECTS = "deleteTenantObjects";
    private static final String LOG_DEACTIVE_TENANT = "deactiveTenant";
    private static final String LOG_UPDATE_TENANT = "updateTenant";
    private static final String LOG_UPDATE_PLATFORM = "updatePlatform";
    private static final String LOG_GET_TENANTS = "getTenants";
    private static final String LOG_GET_PLATFORM = "getPlatform";
    private static final String LOG_DELETE_TENANT_TABLES = "deleteTenantTables";
    private static final String LOG_DELETE_TENANT = "deleteTenant";
    private static final String LOG_DELETE_PLATFORM_TABLES = "deletePlatformTables";
    private static final String LOG_DELETE_PLATFORM = "deletePlatform";
    private static final String LOG_CREATE_TENANT_TABLES = "createTenantTables";
    private static final String LOG_CREATE_TENANT = "createTenant";
    private static final String LOG_CREATE_PLATFORM = "createPlatform";
    private static final String LOG_CREATE_PLATFORM_TABLES = "createPlatformTables";
    private static final String LOG_IS_PLATFORM_CREATED = "isPlatformCreated";
    private static final String QUERY_GET_DEFAULT_TENANT = "getDefaultTenant";
    private static final String QUERY_GET_NUMBER_OF_TENANTS = "getNumberOfTenants";
    private static final String QUERY_GET_TENANTS_BY_IDS = "getTenantsByIds";
    private static final String QUERY_GET_TENANT_BY_NAME = "getTenantByName";
    private static final String QUERY_GET_TENANT_BY_ID = "getTenantById";
    private static final String QUERY_GET_PLATFORM = "getPlatform";
    private static String CACHE_KEY = "PLATFORM";
    private final PersistenceService platformPersistenceService;
    private final List<TenantPersistenceService> tenantPersistenceServices;
    private final TechnicalLoggerService logger;
    private final boolean trace;
    private final PlatformCacheService platformCacheService;
    private final SPlatformProperties sPlatformProperties;

    public PlatformServiceImpl(PersistenceService platformPersistenceService, List<TenantPersistenceService> tenantPersistenceServices, TechnicalLoggerService logger, PlatformCacheService platformCacheService, SPlatformProperties sPlatformProperties) {
        this.platformPersistenceService = platformPersistenceService;
        this.tenantPersistenceServices = tenantPersistenceServices;
        this.logger = logger;
        this.platformCacheService = platformCacheService;
        this.sPlatformProperties = sPlatformProperties;
        this.trace = logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE);
    }

    @Override
    public void createPlatformTables() throws SPlatformCreationException {
        if (this.trace) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), LOG_CREATE_PLATFORM_TABLES));
        }
        try {
            this.platformPersistenceService.createStructure();
            this.platformPersistenceService.postCreateStructure();
            if (this.trace) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), LOG_CREATE_PLATFORM_TABLES));
            }
        }
        catch (SPersistenceException e) {
            if (this.trace) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), LOG_CREATE_PLATFORM_TABLES, e));
            }
            throw new SPlatformCreationException("Unable to create platform tables : " + e.getMessage(), e);
        }
        catch (IOException e) {
            if (this.trace) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), LOG_CREATE_PLATFORM_TABLES, e));
            }
            throw new SPlatformCreationException("Unable to create platform tables : " + e.getMessage(), e);
        }
    }

    @Override
    public void createPlatform(SPlatform platform) throws SPlatformCreationException {
        if (this.trace) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), LOG_CREATE_PLATFORM));
        }
        try {
            this.platformPersistenceService.insert(platform);
            this.cachePlatform(platform);
            if (this.trace) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), LOG_CREATE_PLATFORM));
            }
        }
        catch (SPersistenceException e) {
            if (this.trace) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), LOG_CREATE_PLATFORM, e));
            }
            throw new SPlatformCreationException("Unable to insert the platform row : " + e.getMessage(), e);
        }
    }

    @Override
    public long createTenant(STenant tenant) throws STenantCreationException, STenantAlreadyExistException {
        String tenantName;
        STenant existingTenant;
        block14: {
            if (this.trace) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), LOG_CREATE_TENANT));
            }
            existingTenant = null;
            tenantName = tenant.getName();
            try {
                existingTenant = this.getTenantByName(tenantName);
            }
            catch (STenantNotFoundException e) {
                if (!this.trace) break block14;
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), LOG_CREATE_TENANT, e));
            }
        }
        if (existingTenant != null) {
            throw new STenantAlreadyExistException("Unable to create the tenant " + tenantName + " : it already exists.");
        }
        try {
            this.platformPersistenceService.insert(tenant);
        }
        catch (SPersistenceException e) {
            if (this.trace) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), LOG_CREATE_TENANT, e));
            }
            throw new STenantCreationException("Unable to insert the tenant row : " + e.getMessage(), e);
        }
        try {
            HashMap<String, String> replacements = new HashMap<String, String>();
            replacements.put("tenantid", Long.toString(tenant.getId()));
            for (PersistenceService persistenceService : this.tenantPersistenceServices) {
                persistenceService.initializeStructure(replacements);
            }
            if (this.trace) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), LOG_CREATE_TENANT));
            }
            return tenant.getId();
        }
        catch (SPersistenceException e) {
            if (this.trace) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), LOG_CREATE_TENANT, e));
            }
            throw new STenantCreationException("Unable to create tenant tables : " + e.getMessage(), e);
        }
        catch (IOException e) {
            if (this.trace) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), LOG_CREATE_TENANT, e));
            }
            throw new STenantCreationException("Unable to create tenant tables : " + e.getMessage(), e);
        }
    }

    @Override
    public void createTenantTables() throws STenantCreationException {
        try {
            for (PersistenceService persistenceService : this.tenantPersistenceServices) {
                persistenceService.createStructure();
                persistenceService.postCreateStructure();
            }
        }
        catch (SPersistenceException e) {
            if (this.trace) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), LOG_CREATE_TENANT_TABLES, e));
            }
            throw new STenantCreationException("Unable to create tenant tables : " + e.getMessage(), e);
        }
        catch (IOException e) {
            if (this.trace) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), LOG_CREATE_TENANT_TABLES, e));
            }
            throw new STenantCreationException("Unable to create tenant tables : " + e.getMessage(), e);
        }
    }

    @Override
    public void initializePlatformStructure() throws SPlatformCreationException {
        try {
            this.platformPersistenceService.initializeStructure();
        }
        catch (SPersistenceException e) {
            throw new SPlatformCreationException("Unable to initialize platform structure.", e);
        }
        catch (IOException e) {
            throw new SPlatformCreationException("Unable to initialize platform structure.", e);
        }
    }

    @Override
    public void deletePlatform() throws SPlatformDeletionException, SPlatformNotFoundException {
        if (this.trace) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), LOG_DELETE_PLATFORM));
        }
        SPlatform platform = this.readPlatform();
        this.checkNotExistingTenant();
        try {
            this.platformPersistenceService.delete(platform);
            this.platformCacheService.clear(CACHE_KEY);
            if (this.trace) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), LOG_DELETE_PLATFORM));
            }
        }
        catch (SPersistenceException e) {
            if (this.trace) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), LOG_DELETE_PLATFORM, e));
            }
            throw new SPlatformDeletionException("Unable to delete the platform row : " + e.getMessage(), e);
        }
        catch (SCacheException e) {
            throw new SPlatformDeletionException("Unable to delete the platform from cache : " + e.getMessage(), e);
        }
    }

    private void checkNotExistingTenant() throws SPlatformDeletionException {
        List<STenant> existingTenants;
        try {
            existingTenants = this.getTenants(new QueryOptions(0, 1, STenant.class, "id", OrderByType.ASC));
        }
        catch (STenantException e) {
            throw new SPlatformDeletionException(e);
        }
        if (existingTenants.size() > 0) {
            throw new SPlatformDeletionException("Some tenants still are in the system. Can not delete platform.");
        }
    }

    @Override
    public void deletePlatformTables() throws SPlatformDeletionException {
        if (this.trace) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), LOG_DELETE_PLATFORM_TABLES));
        }
        try {
            this.platformPersistenceService.preDropStructure();
            this.platformPersistenceService.deleteStructure();
            if (this.trace) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), LOG_DELETE_PLATFORM_TABLES));
            }
        }
        catch (SPersistenceException e) {
            if (this.trace) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), LOG_DELETE_PLATFORM_TABLES, e));
            }
            throw new SPlatformDeletionException("Unable to delete platform tables : " + e.getMessage(), e);
        }
        catch (IOException e) {
            if (this.trace) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), LOG_DELETE_PLATFORM_TABLES, e));
            }
            throw new SPlatformDeletionException("Unable to delete platform tables : " + e.getMessage(), e);
        }
    }

    @Override
    public void deleteTenant(long tenantId) throws STenantDeletionException, STenantNotFoundException, SDeletingActivatedTenantException {
        STenant tenant;
        if (this.trace) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), LOG_DELETE_TENANT));
        }
        if ((tenant = this.getTenant(tenantId)).getStatus().equals("ACTIVATED")) {
            throw new SDeletingActivatedTenantException();
        }
        try {
            this.platformPersistenceService.delete(tenant);
        }
        catch (SPersistenceException e) {
            if (this.trace) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), LOG_DELETE_TENANT, e));
            }
            throw new STenantDeletionException("Unable to delete the tenant : " + e.getMessage(), e);
        }
    }

    @Override
    public void deleteTenantTables() throws STenantDeletionException {
        try {
            for (PersistenceService persistenceService : this.tenantPersistenceServices) {
                persistenceService.preDropStructure();
                persistenceService.deleteStructure();
            }
            if (this.trace) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), LOG_DELETE_TENANT_TABLES));
            }
        }
        catch (SPersistenceException e) {
            if (this.trace) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), LOG_DELETE_TENANT_TABLES, e));
            }
            throw new STenantDeletionException("Unable to delete tenant tables: " + e.getMessage(), e);
        }
        catch (IOException e) {
            if (this.trace) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), LOG_DELETE_TENANT_TABLES, e));
            }
            throw new STenantDeletionException("Unable to delete tenant tables : " + e.getMessage(), e);
        }
    }

    @Override
    public void deleteTenantObjects(long tenantId) throws STenantDeletionException, STenantNotFoundException, SDeletingActivatedTenantException {
        STenant tenant;
        if (this.trace) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), LOG_DELETE_TENANT_OBJECTS));
        }
        if ((tenant = this.getTenant(tenantId)).getStatus().equals("ACTIVATED")) {
            throw new SDeletingActivatedTenantException();
        }
        try {
            for (TenantPersistenceService tenantPersistenceService : this.tenantPersistenceServices) {
                tenantPersistenceService.deleteTenant(tenantId);
            }
        }
        catch (SPersistenceException e) {
            if (this.trace) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), LOG_DELETE_TENANT_OBJECTS, e));
            }
            throw new STenantDeletionException("Unable to delete the tenant object : " + e.getMessage(), e);
        }
        catch (IOException e) {
            if (this.trace) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), LOG_DELETE_TENANT_OBJECTS, e));
            }
            throw new STenantDeletionException("Unable to delete the tenant object : " + e.getMessage(), e);
        }
    }

    @Override
    public SPlatform getPlatform() throws SPlatformNotFoundException {
        try {
            SPlatform sPlatform = (SPlatform)this.platformCacheService.get(CACHE_KEY, CACHE_KEY);
            if (sPlatform == null) {
                sPlatform = this.readPlatform();
                this.cachePlatform(sPlatform);
            }
            return sPlatform;
        }
        catch (SCacheException e) {
            throw new SPlatformNotFoundException("Platform not present in cache.", e);
        }
    }

    private void cachePlatform(SPlatform platform) {
        try {
            this.platformCacheService.store(CACHE_KEY, (Serializable)((Object)CACHE_KEY), platform);
        }
        catch (SCacheException e) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.DEBUG, "Can't cache the platform, maybe the platform cache service is not started yet");
        }
    }

    private SPlatform readPlatform() throws SPlatformNotFoundException {
        if (this.trace) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), "getPlatform"));
        }
        SPlatform platform = null;
        try {
            platform = (SPlatform)this.platformPersistenceService.selectOne(new SelectOneDescriptor("getPlatform", null, (Class<? extends PersistentObject>)((Class<PersistentObject>)SPlatform.class)));
            if (platform == null) {
                throw new SPlatformNotFoundException("No platform found");
            }
            if (this.trace) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "getPlatform"));
            }
            return platform;
        }
        catch (Exception e) {
            if (this.trace) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), "getPlatform", "Unable to check if a platform already exists : " + e.getMessage()));
            }
            throw new SPlatformNotFoundException("Unable to check if a platform already exists : " + e.getMessage(), e);
        }
    }

    @Override
    public STenant getTenant(long id) throws STenantNotFoundException {
        STenant tenant;
        if (this.trace) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), QUERY_GET_TENANT_BY_ID));
        }
        try {
            tenant = this.platformPersistenceService.selectById(new SelectByIdDescriptor<STenant>(QUERY_GET_TENANT_BY_ID, STenant.class, id));
            if (tenant == null) {
                throw new STenantNotFoundException("No tenant found with id: " + id);
            }
        }
        catch (Exception e) {
            throw new STenantNotFoundException("Unable to get the tenant : " + e.getMessage(), e);
        }
        if (this.trace) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), QUERY_GET_TENANT_BY_ID));
        }
        return tenant;
    }

    @Override
    public boolean isPlatformCreated() {
        if (this.trace) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), LOG_IS_PLATFORM_CREATED));
        }
        boolean flag = false;
        try {
            this.getPlatform();
            flag = true;
        }
        catch (SPlatformNotFoundException e) {
            if (this.trace) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), LOG_IS_PLATFORM_CREATED, e));
            }
            return false;
        }
        if (this.trace) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), LOG_IS_PLATFORM_CREATED));
        }
        return flag;
    }

    @Override
    public STenant getTenantByName(String name) throws STenantNotFoundException {
        STenant tenant;
        if (this.trace) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), QUERY_GET_TENANT_BY_NAME));
        }
        try {
            Map<String, Object> parameters = CollectionUtil.buildSimpleMap(BuilderFactory.get(STenantBuilderFactory.class).getNameKey(), name);
            tenant = (STenant)this.platformPersistenceService.selectOne(new SelectOneDescriptor(QUERY_GET_TENANT_BY_NAME, parameters, STenant.class));
            if (tenant == null) {
                throw new STenantNotFoundException("No tenant found with name: " + name);
            }
        }
        catch (SBonitaReadException e) {
            throw new STenantNotFoundException("Unable to check if a tenant already exists: " + e.getMessage(), e);
        }
        if (this.trace) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), QUERY_GET_TENANT_BY_NAME));
        }
        return tenant;
    }

    @Override
    public STenant getDefaultTenant() throws STenantNotFoundException {
        if (this.trace) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), QUERY_GET_DEFAULT_TENANT));
        }
        STenant tenant = null;
        try {
            tenant = (STenant)this.platformPersistenceService.selectOne(new SelectOneDescriptor(QUERY_GET_DEFAULT_TENANT, null, (Class<? extends PersistentObject>)((Class<PersistentObject>)STenant.class)));
            if (tenant == null) {
                throw new STenantNotFoundException("No default tenant found");
            }
        }
        catch (SBonitaReadException e) {
            if (this.trace) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), QUERY_GET_DEFAULT_TENANT, e));
            }
            throw new STenantNotFoundException("Unable to check if a default tenant already exists: " + e.getMessage(), e);
        }
        if (this.trace) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), QUERY_GET_DEFAULT_TENANT));
        }
        return tenant;
    }

    @Override
    public List<STenant> getTenants(Collection<Long> ids, QueryOptions queryOptions) throws STenantNotFoundException, STenantException {
        List<STenant> tenants;
        if (this.trace) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), LOG_GET_TENANTS));
        }
        try {
            Map<String, Object> parameters = CollectionUtil.buildSimpleMap("ids", ids);
            tenants = this.platformPersistenceService.selectList(new SelectListDescriptor(QUERY_GET_TENANTS_BY_IDS, parameters, STenant.class, queryOptions));
            if (tenants.size() != ids.size()) {
                throw new STenantNotFoundException("Unable to retrieve all tenants by ids. Expected: " + ids + ", retrieved: " + tenants);
            }
        }
        catch (SBonitaReadException e) {
            throw new STenantException("Problem getting list of tenants: " + e.getMessage(), e);
        }
        if (this.trace) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), LOG_GET_TENANTS));
        }
        return tenants;
    }

    @Override
    public void updatePlatform(SPlatform platform, EntityUpdateDescriptor descriptor) throws SPlatformUpdateException {
        if (this.trace) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), LOG_UPDATE_PLATFORM));
        }
        UpdateDescriptor desc = new UpdateDescriptor(platform);
        desc.addFields(descriptor.getFields());
        try {
            this.platformPersistenceService.update(desc);
            if (this.trace) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), LOG_UPDATE_PLATFORM));
            }
        }
        catch (SPersistenceException e) {
            if (this.trace) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), LOG_UPDATE_PLATFORM, e));
            }
            throw new SPlatformUpdateException("Problem while updating platform: " + platform, e);
        }
    }

    @Override
    public void updateTenant(STenant tenant, EntityUpdateDescriptor descriptor) throws STenantUpdateException {
        String tenantName;
        if (this.trace) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), LOG_UPDATE_TENANT));
        }
        if ((tenantName = (String)descriptor.getFields().get(BuilderFactory.get(STenantBuilderFactory.class).getNameKey())) != null) {
            try {
                if (this.getTenantByName(tenantName).getId() != tenant.getId()) {
                    throw new STenantUpdateException("Unable to update the tenant with new name " + tenantName + " : it already exists.");
                }
            }
            catch (STenantNotFoundException e) {
                // empty catch block
            }
        }
        UpdateDescriptor desc = new UpdateDescriptor(tenant);
        desc.addFields(descriptor.getFields());
        try {
            this.platformPersistenceService.update(desc);
            if (this.trace) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), LOG_UPDATE_TENANT));
            }
        }
        catch (SPersistenceException e) {
            if (this.trace) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), LOG_UPDATE_TENANT, e));
            }
            throw new STenantUpdateException("Problem while updating tenant: " + tenant, e);
        }
    }

    @Override
    public boolean activateTenant(long tenantId) throws STenantNotFoundException, STenantActivationException {
        STenant tenant;
        if (this.trace) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), LOG_ACTIVATE_TENANT));
        }
        if (this.isTenantActivated(tenant = this.getTenant(tenantId))) {
            return false;
        }
        UpdateDescriptor desc = new UpdateDescriptor(tenant);
        desc.addField(BuilderFactory.get(STenantBuilderFactory.class).getStatusKey(), "ACTIVATED");
        try {
            this.platformPersistenceService.update(desc);
            if (this.trace) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), LOG_ACTIVATE_TENANT));
            }
        }
        catch (SPersistenceException e) {
            if (this.trace) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), LOG_ACTIVATE_TENANT, e));
            }
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.DEBUG)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.DEBUG, e);
            }
            throw new STenantActivationException("Problem while activating tenant: " + tenant, e);
        }
        return true;
    }

    @Override
    public void deactiveTenant(long tenantId) throws STenantNotFoundException, STenantDeactivationException {
        if (this.trace) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), LOG_DEACTIVE_TENANT));
        }
        STenant tenant = this.getTenant(tenantId);
        UpdateDescriptor desc = new UpdateDescriptor(tenant);
        desc.addField(BuilderFactory.get(STenantBuilderFactory.class).getStatusKey(), "DEACTIVATED");
        try {
            this.platformPersistenceService.update(desc);
            if (this.trace) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), LOG_DEACTIVE_TENANT));
            }
        }
        catch (SPersistenceException e) {
            if (this.trace) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), LOG_DEACTIVE_TENANT, e));
            }
            throw new STenantDeactivationException("Problem while deactivating tenant: " + tenant, e);
        }
    }

    @Override
    public List<STenant> getTenants(QueryOptions queryOptions) throws STenantException {
        List<STenant> tenants;
        if (this.trace) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), LOG_GET_TENANTS));
        }
        try {
            tenants = this.platformPersistenceService.selectList(new SelectListDescriptor(LOG_GET_TENANTS, null, STenant.class, queryOptions));
        }
        catch (SBonitaReadException e) {
            throw new STenantException("Problem getting list of tenants : " + e.getMessage(), e);
        }
        if (this.trace) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), LOG_GET_TENANTS));
        }
        return tenants;
    }

    @Override
    public int getNumberOfTenants() throws STenantException {
        if (this.trace) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), QUERY_GET_NUMBER_OF_TENANTS));
        }
        Map<String, Object> emptyMap = Collections.emptyMap();
        try {
            Long read = this.platformPersistenceService.selectOne(new SelectOneDescriptor<Long>(QUERY_GET_NUMBER_OF_TENANTS, emptyMap, STenant.class, Long.class));
            if (this.trace) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), QUERY_GET_NUMBER_OF_TENANTS));
            }
            return read.intValue();
        }
        catch (SBonitaReadException e) {
            if (this.trace) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), QUERY_GET_NUMBER_OF_TENANTS, e));
            }
            throw new STenantException(e);
        }
    }

    @Override
    public boolean isTenantActivated(STenant sTenant) {
        return !"DEACTIVATED".equals(sTenant.getStatus());
    }

    @Override
    public List<STenant> searchTenants(QueryOptions options) throws SBonitaSearchException {
        if (this.trace) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), "searchSTenants"));
        }
        try {
            List<STenant> listsSTenants = this.platformPersistenceService.searchEntity(STenant.class, options, null);
            if (this.trace) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "searchSTenants"));
            }
            return listsSTenants;
        }
        catch (SBonitaReadException bre) {
            if (this.trace) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), "searchSTenants", bre));
            }
            throw new SBonitaSearchException(bre);
        }
    }

    @Override
    public long getNumberOfTenants(QueryOptions options) throws SBonitaSearchException {
        if (this.trace) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), "getNumberOfSTenant"));
        }
        try {
            long number = this.platformPersistenceService.getNumberOfEntities(STenant.class, options, null);
            if (this.trace) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "getNumberOfSTenant"));
            }
            return number;
        }
        catch (SBonitaReadException bre) {
            if (this.trace) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), "getNumberOfSTenant", bre));
            }
            throw new SBonitaSearchException(bre);
        }
    }

    @Override
    public void cleanTenantTables() throws STenantUpdateException {
        try {
            for (PersistenceService persistenceService : this.tenantPersistenceServices) {
                persistenceService.cleanStructure();
            }
            if (this.trace) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "cleanTenantTables"));
            }
        }
        catch (Exception e) {
            if (this.trace) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), "cleanTenantTables", e));
            }
            throw new STenantUpdateException("Unable to clean tenant tables : " + e.getMessage(), e);
        }
    }

    @Override
    public SPlatformProperties getSPlatformProperties() {
        return this.sPlatformProperties;
    }
}

