/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.sequence;

import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.bonitasoft.engine.commons.exceptions.SObjectNotFoundException;
import org.bonitasoft.engine.lock.LockService;
import org.bonitasoft.engine.sequence.SequenceManager;
import org.bonitasoft.engine.sequence.TenantSequenceManagerImpl;

public class SequenceManagerImpl
implements SequenceManager {
    private final Map<Long, Integer> rangeSizes;
    private final int defaultRangeSize;
    private final Map<String, Long> sequencesMappings;
    private final int retries;
    private final int delay;
    private final int delayFactor;
    private final DataSource datasource;
    private final LockService lockService;
    private final Map<Long, TenantSequenceManagerImpl> sequenceManagers = new HashMap<Long, TenantSequenceManagerImpl>();
    private final Object mutex = new SequenceManagerImplMutex();

    public SequenceManagerImpl(LockService lockService, Map<Long, Integer> rangeSizes, int defaultRangeSize, Map<String, Long> sequencesMappings, DataSource datasource, int retries, int delay, int delayFactor) {
        this.lockService = lockService;
        this.defaultRangeSize = defaultRangeSize;
        this.rangeSizes = rangeSizes;
        this.sequencesMappings = sequencesMappings;
        this.retries = retries;
        this.delay = delay;
        this.delayFactor = delayFactor;
        this.datasource = datasource;
    }

    @Override
    public void reset() {
        this.sequenceManagers.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getNextId(String entityName, long tenantId) throws SObjectNotFoundException {
        TenantSequenceManagerImpl mgr = this.sequenceManagers.get(tenantId);
        if (mgr == null) {
            Object object = this.mutex;
            synchronized (object) {
                mgr = this.sequenceManagers.get(tenantId);
                if (mgr == null) {
                    mgr = new TenantSequenceManagerImpl(tenantId, this.lockService, this.rangeSizes, this.defaultRangeSize, this.sequencesMappings, this.datasource, this.retries, this.delay, this.delayFactor);
                    this.sequenceManagers.put(tenantId, mgr);
                }
            }
        }
        return mgr.getNextId(entityName);
    }

    @Override
    public void clear() {
        this.sequenceManagers.clear();
    }

    @Override
    public void close() {
    }

    @Override
    public void clear(long tenantId) {
        this.sequenceManagers.remove(tenantId);
    }

    private static final class SequenceManagerImplMutex {
        private SequenceManagerImplMutex() {
        }
    }
}

