/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine;

import org.bonitasoft.engine.api.PlatformAPI;
import org.bonitasoft.engine.platform.PlatformNotFoundException;

public class PlatformTenantManager {
    private static PlatformTenantManager instance;
    private static final String STOP = "stop";
    private static final String START = "start";

    protected PlatformTenantManager() {
    }

    public static synchronized PlatformTenantManager getInstance() {
        if (instance == null) {
            instance = new PlatformTenantManager();
        }
        return instance;
    }

    public boolean createPlatform(PlatformAPI platformAPI) throws Exception {
        if (!platformAPI.isPlatformCreated()) {
            platformAPI.createAndInitializePlatform();
            return true;
        }
        return false;
    }

    private void updatePlatform(PlatformAPI platformAPI, String platformState) throws Exception {
        if (!platformAPI.isPlatformCreated()) {
            throw new PlatformNotFoundException("Can't start or stop platform if it is not created");
        }
        if (platformState.equals(START)) {
            platformAPI.startNode();
        } else if (platformState.equals(STOP)) {
            platformAPI.stopNode();
        }
    }

    public void startPlatform(PlatformAPI platformAPI) throws Exception {
        this.updatePlatform(platformAPI, START);
    }

    public void stopPlatform(PlatformAPI platformAPI) throws Exception {
        this.updatePlatform(platformAPI, STOP);
    }
}

