/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.api.impl.transaction;

import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.concurrent.Callable;
import org.bonitasoft.engine.api.impl.TenantConfiguration;
import org.bonitasoft.engine.api.impl.transaction.ServiceStrategy;
import org.bonitasoft.engine.classloader.ClassLoaderService;
import org.bonitasoft.engine.commons.TenantLifecycleService;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.core.process.definition.ProcessDefinitionService;
import org.bonitasoft.engine.dependency.DependencyService;
import org.bonitasoft.engine.dependency.model.ScopeType;
import org.bonitasoft.engine.exception.BonitaHomeConfigurationException;
import org.bonitasoft.engine.exception.BonitaHomeNotSetException;
import org.bonitasoft.engine.exception.UpdateException;
import org.bonitasoft.engine.log.technical.TechnicalLogSeverity;
import org.bonitasoft.engine.log.technical.TechnicalLoggerService;
import org.bonitasoft.engine.service.PlatformServiceAccessor;
import org.bonitasoft.engine.service.TenantServiceAccessor;
import org.bonitasoft.engine.service.impl.ServiceAccessorFactory;

public class SetServiceState
implements Callable<Void>,
Serializable {
    private static final long serialVersionUID = 7880459346729952396L;
    private final long tenantId;
    private final ServiceStrategy serviceStrategy;

    public SetServiceState(long tenantId, ServiceStrategy serviceStrategy) {
        this.tenantId = tenantId;
        this.serviceStrategy = serviceStrategy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void call() throws Exception {
        ClassLoader baseClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            PlatformServiceAccessor platformServiceAccessor = this.getPlatformAccessor();
            TenantServiceAccessor tenantServiceAccessor = platformServiceAccessor.getTenantServiceAccessor(this.tenantId);
            if (this.serviceStrategy.shouldRefreshClassLoaders()) {
                tenantServiceAccessor.getDependencyService().refreshClassLoader(ScopeType.TENANT, this.tenantId);
                this.refreshClassloaderOfProcessDefinitions(tenantServiceAccessor);
            }
            ClassLoaderService classLoaderService = tenantServiceAccessor.getClassLoaderService();
            ClassLoader serverClassLoader = classLoaderService.getLocalClassLoader(ScopeType.TENANT.name(), this.tenantId);
            Thread.currentThread().setContextClassLoader(serverClassLoader);
            TenantConfiguration tenantConfiguration = tenantServiceAccessor.getTenantConfiguration();
            TechnicalLoggerService logger = tenantServiceAccessor.getTechnicalLoggerService();
            for (TenantLifecycleService tenantService : tenantConfiguration.getLifecycleServices()) {
                if (logger.isLoggable(this.getClass(), TechnicalLogSeverity.INFO)) {
                    logger.log(this.getClass(), TechnicalLogSeverity.INFO, this.serviceStrategy.getStateName() + " tenant-level service " + tenantService.getClass().getName() + " on tenant with ID " + this.tenantId);
                }
                try {
                    this.serviceStrategy.changeState(tenantService);
                }
                catch (SBonitaException sbe) {
                    throw new UpdateException("Unable to " + this.serviceStrategy.getStateName() + " service: " + tenantService.getClass().getName(), (Throwable)sbe);
                }
            }
            Void void_ = null;
            return void_;
        }
        finally {
            Thread.currentThread().setContextClassLoader(baseClassLoader);
        }
    }

    protected void refreshClassloaderOfProcessDefinitions(TenantServiceAccessor tenantServiceAccessor) throws SBonitaException {
        List<Long> processDefinitionIds;
        DependencyService dependencyService = tenantServiceAccessor.getDependencyService();
        ProcessDefinitionService processDefinitionService = tenantServiceAccessor.getProcessDefinitionService();
        int maxResults = 100;
        int startIndex = 0;
        do {
            processDefinitionIds = processDefinitionService.getProcessDefinitionIds(startIndex, 100);
            for (Long id : processDefinitionIds) {
                dependencyService.refreshClassLoader(ScopeType.PROCESS, id);
            }
            startIndex += 100;
        } while (processDefinitionIds.size() == 100);
    }

    public PlatformServiceAccessor getPlatformAccessor() throws BonitaHomeNotSetException, InstantiationException, IllegalAccessException, ClassNotFoundException, IOException, BonitaHomeConfigurationException {
        return ServiceAccessorFactory.getInstance().createPlatformServiceAccessor();
    }
}

