/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.api.impl.transaction.actor;

import java.io.IOException;
import java.io.StringReader;
import java.util.List;
import java.util.Set;
import org.bonitasoft.engine.actor.mapping.ActorMappingService;
import org.bonitasoft.engine.actor.mapping.SActorMemberAlreadyExistsException;
import org.bonitasoft.engine.actor.mapping.model.SActor;
import org.bonitasoft.engine.actor.mapping.model.SActorMember;
import org.bonitasoft.engine.actor.xml.Actor;
import org.bonitasoft.engine.actor.xml.ActorMapping;
import org.bonitasoft.engine.actor.xml.SActorMappingImportException;
import org.bonitasoft.engine.bpm.bar.xml.XMLProcessDefinition;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.commons.transaction.TransactionContent;
import org.bonitasoft.engine.identity.IdentityService;
import org.bonitasoft.engine.identity.model.SGroup;
import org.bonitasoft.engine.identity.model.SRole;
import org.bonitasoft.engine.identity.model.SUser;
import org.bonitasoft.engine.persistence.SBonitaReadException;
import org.bonitasoft.engine.xml.Parser;

public class ImportActorMapping
implements TransactionContent {
    private final ActorMappingService actorMappingService;
    private final IdentityService identityService;
    private final Parser parser;
    private final long processDefinitionId;
    private final String xmlContent;

    public ImportActorMapping(ActorMappingService actorMappingService, IdentityService identityService, Parser parser, long processDefinitionId, String xmlContent) {
        this.actorMappingService = actorMappingService;
        this.identityService = identityService;
        this.parser = parser;
        this.processDefinitionId = processDefinitionId;
        this.xmlContent = xmlContent;
    }

    @Override
    public void execute() throws SBonitaException {
        ActorMapping actorMapping = this.getActorMappingFromXML();
        List<Actor> actors = actorMapping.getActors();
        for (Actor actor : actors) {
            SActor sActor = this.actorMappingService.getActor(actor.getName(), this.processDefinitionId);
            long actorId = sActor.getId();
            Set<String> userNames = actor.getUsers();
            for (String userName : userNames) {
                SUser user = this.identityService.getUserByUserName(userName);
                this.checkAlreadyExistingUserMapping(actorId, user.getId());
                this.actorMappingService.addUserToActor(actorId, user.getId());
            }
            Set<String> roleNames = actor.getRoles();
            for (String roleName : roleNames) {
                SRole role = this.identityService.getRoleByName(roleName);
                this.checkAlreadyExistingRoleMapping(actorId, role.getId());
                this.actorMappingService.addRoleToActor(actorId, role.getId());
            }
            Set<String> groupPaths = actor.getGroups();
            for (String groupPath : groupPaths) {
                SGroup group = this.identityService.getGroupByPath(groupPath);
                this.checkAlreadyExistingGroupMapping(actorId, group.getId());
                this.actorMappingService.addGroupToActor(actorId, group.getId());
            }
            Set<XMLProcessDefinition.BEntry<String, String>> memberships = actor.getMemberships();
            for (XMLProcessDefinition.BEntry<String, String> membership : memberships) {
                SGroup group = this.identityService.getGroupByPath((String)membership.getKey());
                SRole role = this.identityService.getRoleByName((String)membership.getValue());
                this.checkAlreadyExistingMembershipMapping(actorId, group.getId(), role.getId());
                this.actorMappingService.addRoleAndGroupToActor(actorId, role.getId(), group.getId());
            }
        }
    }

    private void checkAlreadyExistingUserMapping(long actorId, long userId) throws SActorMemberAlreadyExistsException, SBonitaReadException {
        List<SActorMember> actorMembersOfUser;
        int startIndex = 0;
        do {
            actorMembersOfUser = this.actorMappingService.getActorMembers(actorId, startIndex, 50);
            for (SActorMember sActorMember : actorMembersOfUser) {
                if (sActorMember.getUserId() != userId || sActorMember.getRoleId() != -1L || sActorMember.getGroupId() != -1L) continue;
                throw new SActorMemberAlreadyExistsException("This user / actor mapping already exists: actorId=" + actorId + ", userId=" + userId);
            }
            startIndex += 50;
        } while (actorMembersOfUser.size() > 0);
    }

    private void checkAlreadyExistingGroupMapping(long actorId, long groupId) throws SActorMemberAlreadyExistsException, SBonitaReadException {
        List<SActorMember> actorMembersOfGroup;
        int startIndex = 0;
        do {
            actorMembersOfGroup = this.actorMappingService.getActorMembers(actorId, startIndex, 50);
            for (SActorMember sActorMember : actorMembersOfGroup) {
                if (sActorMember.getGroupId() != groupId || sActorMember.getRoleId() != -1L || sActorMember.getUserId() != -1L) continue;
                throw new SActorMemberAlreadyExistsException("This group / actor mapping already exists: actorId=" + actorId + ", groupId=" + groupId);
            }
            startIndex += 50;
        } while (actorMembersOfGroup.size() > 0);
    }

    private void checkAlreadyExistingRoleMapping(long actorId, long roleId) throws SActorMemberAlreadyExistsException, SBonitaReadException {
        List<SActorMember> actorMembersOfRole;
        int startIndex = 0;
        do {
            actorMembersOfRole = this.actorMappingService.getActorMembers(actorId, startIndex, 50);
            for (SActorMember sActorMember : actorMembersOfRole) {
                if (sActorMember.getRoleId() != roleId || sActorMember.getGroupId() != -1L || sActorMember.getUserId() != -1L) continue;
                throw new SActorMemberAlreadyExistsException("This role / actor mapping already exists: actorId=" + actorId + ", roleId=" + roleId);
            }
            startIndex += 50;
        } while (actorMembersOfRole.size() > 0);
    }

    private void checkAlreadyExistingMembershipMapping(long actorId, long groupId, long roleId) throws SActorMemberAlreadyExistsException, SBonitaReadException {
        List<SActorMember> actorMembersOfMembership;
        int startIndex = 0;
        do {
            actorMembersOfMembership = this.actorMappingService.getActorMembers(actorId, startIndex, 50);
            for (SActorMember sActorMember : actorMembersOfMembership) {
                if (sActorMember.getRoleId() != roleId || sActorMember.getGroupId() != groupId) continue;
                throw new SActorMemberAlreadyExistsException("This membership / actor mapping already exists: actorId=" + actorId + ", groupId=" + groupId + ", roleId=" + roleId);
            }
            startIndex += 50;
        } while (actorMembersOfMembership.size() > 0);
    }

    private ActorMapping getActorMappingFromXML() throws SBonitaException {
        StringReader reader = new StringReader(this.xmlContent);
        try {
            this.parser.validate(reader);
            reader.close();
            reader = new StringReader(this.xmlContent);
            ActorMapping actorMapping = (ActorMapping)this.parser.getObjectFromXML(reader);
            return actorMapping;
        }
        catch (IOException ioe) {
            throw new SActorMappingImportException(ioe);
        }
        finally {
            reader.close();
        }
    }
}

