/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.api.impl.transaction.identity;

import java.util.List;
import org.bonitasoft.engine.actor.mapping.ActorMappingService;
import org.bonitasoft.engine.api.impl.transaction.identity.DeleteWithActorMembers;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.commons.transaction.TransactionContent;
import org.bonitasoft.engine.identity.IdentityService;
import org.bonitasoft.engine.profile.ProfileService;

public class DeleteUsers
extends DeleteWithActorMembers
implements TransactionContent {
    private final List<Long> userIds;

    public DeleteUsers(IdentityService identityService, ActorMappingService actorMappingService, ProfileService profileService, List<Long> userIds) {
        super(actorMappingService, profileService, identityService);
        this.userIds = userIds;
    }

    @Override
    public void execute() throws SBonitaException {
        for (Long userId : this.userIds) {
            this.deleteUserMembershipsByUser(userId);
            this.deleteActorMembersOfUser(userId);
            this.deleteProfileMembersOfUser(userId);
            this.getIdentityService().deleteUser(userId);
        }
    }
}

