/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.commons;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public class JavaMethodInvoker {
    protected static Map<String, Class<?>> primitiveTypes = new HashMap(8);
    private static Map<String, Class<?>> autoboxableTypes;

    private Method getMethod(Class<?> dataType, String operator, String className) throws NoSuchMethodException, ClassNotFoundException {
        if (className != null) {
            try {
                return dataType.getDeclaredMethod(operator, this.getClassOrPrimitiveClass(className));
            }
            catch (NoSuchMethodException e) {
                if (autoboxableTypes.containsKey(className)) {
                    return dataType.getDeclaredMethod(operator, autoboxableTypes.get(className));
                }
                throw e;
            }
        }
        return dataType.getDeclaredMethod(operator, new Class[0]);
    }

    protected Class<?> getClassOrPrimitiveClass(String type) throws ClassNotFoundException {
        if (primitiveTypes.containsKey(type)) {
            return primitiveTypes.get(type);
        }
        return Thread.currentThread().getContextClassLoader().loadClass(type);
    }

    public Object invokeJavaMethod(String typeOfValueToSet, Object valueToSetObjectWith, Object objectToInvokeJavaMethodOn, String operator, String operatorParameterClassName) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Class<?> expressionResultType = this.getClassOrPrimitiveClass(typeOfValueToSet);
        Class<?> dataType = Thread.currentThread().getContextClassLoader().loadClass(objectToInvokeJavaMethodOn.getClass().getName());
        Method method = this.getMethod(dataType, operator, operatorParameterClassName);
        Object o = dataType.cast(objectToInvokeJavaMethodOn);
        method.invoke(o, expressionResultType.cast(valueToSetObjectWith));
        return o;
    }

    static {
        primitiveTypes.put("char", Character.TYPE);
        primitiveTypes.put("byte", Byte.TYPE);
        primitiveTypes.put("long", Long.TYPE);
        primitiveTypes.put("int", Integer.TYPE);
        primitiveTypes.put("float", Float.TYPE);
        primitiveTypes.put("double", Double.TYPE);
        primitiveTypes.put("short", Short.TYPE);
        primitiveTypes.put("boolean", Boolean.TYPE);
        autoboxableTypes = new HashMap(8);
        autoboxableTypes.put(Character.class.getName(), Character.TYPE);
        autoboxableTypes.put(Byte.class.getName(), Byte.TYPE);
        autoboxableTypes.put(Long.class.getName(), Long.TYPE);
        autoboxableTypes.put(Integer.class.getName(), Integer.TYPE);
        autoboxableTypes.put(Float.class.getName(), Float.TYPE);
        autoboxableTypes.put(Double.class.getName(), Double.TYPE);
        autoboxableTypes.put(Short.class.getName(), Short.TYPE);
        autoboxableTypes.put(Boolean.class.getName(), Boolean.TYPE);
    }
}

