/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.core.process.definition.model.bindings;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bonitasoft.engine.core.process.definition.model.SActivityDefinition;
import org.bonitasoft.engine.core.process.definition.model.SBusinessDataDefinition;
import org.bonitasoft.engine.core.process.definition.model.SConnectorDefinition;
import org.bonitasoft.engine.core.process.definition.model.SDocumentDefinition;
import org.bonitasoft.engine.core.process.definition.model.SFlowNodeDefinition;
import org.bonitasoft.engine.core.process.definition.model.STransitionDefinition;
import org.bonitasoft.engine.core.process.definition.model.event.SBoundaryEventDefinition;
import org.bonitasoft.engine.core.process.definition.model.event.impl.SEndEventDefinitionImpl;
import org.bonitasoft.engine.core.process.definition.model.event.impl.SIntermediateCatchEventDefinitionImpl;
import org.bonitasoft.engine.core.process.definition.model.event.impl.SIntermediateThrowEventDefinitionImpl;
import org.bonitasoft.engine.core.process.definition.model.event.impl.SStartEventDefinitionImpl;
import org.bonitasoft.engine.core.process.definition.model.impl.SActivityDefinitionImpl;
import org.bonitasoft.engine.core.process.definition.model.impl.SFlowElementContainerDefinitionImpl;
import org.bonitasoft.engine.core.process.definition.model.impl.SFlowNodeDefinitionImpl;
import org.bonitasoft.engine.core.process.definition.model.impl.SGatewayDefinitionImpl;
import org.bonitasoft.engine.core.process.definition.model.impl.STransitionDefinitionImpl;
import org.bonitasoft.engine.data.definition.model.SDataDefinition;
import org.bonitasoft.engine.xml.ElementBinding;

public class SFlowElementBinding
extends ElementBinding {
    private final List<SActivityDefinitionImpl> activities = new ArrayList<SActivityDefinitionImpl>();
    private final List<SGatewayDefinitionImpl> gateways = new ArrayList<SGatewayDefinitionImpl>();
    private final List<SStartEventDefinitionImpl> startEvents = new ArrayList<SStartEventDefinitionImpl>();
    private final List<SIntermediateCatchEventDefinitionImpl> intermediateCatchEvents = new ArrayList<SIntermediateCatchEventDefinitionImpl>();
    private final List<SEndEventDefinitionImpl> endEvents = new ArrayList<SEndEventDefinitionImpl>();
    private final List<SIntermediateThrowEventDefinitionImpl> intermediateThrowEvents = new ArrayList<SIntermediateThrowEventDefinitionImpl>();
    private final List<STransitionDefinition> sTransitions = new ArrayList<STransitionDefinition>();
    private final List<SDataDefinition> dataDefinitions = new ArrayList<SDataDefinition>();
    private final List<SBusinessDataDefinition> businessDataDefinitions = new ArrayList<SBusinessDataDefinition>();
    private final List<SDocumentDefinition> documentDefinitions = new ArrayList<SDocumentDefinition>();
    private final List<SConnectorDefinition> connectors = new ArrayList<SConnectorDefinition>();

    @Override
    public void setAttributes(Map<String, String> attributes) {
    }

    @Override
    public void setChildElement(String name, String value, Map<String, String> attributes) {
    }

    @Override
    public void setChildObject(String name, Object value) {
        if ("automaticTask".equals(name) || "userTask".equals(name) || "manualTask".equals(name) || "callActivity".equals(name) || "receiveTask".equals(name) || "subProcess".equals(name) || "sendTask".equals(name)) {
            this.activities.add((SActivityDefinitionImpl)value);
        } else if ("connector".equals(name)) {
            this.connectors.add((SConnectorDefinition)value);
        } else if ("businessDataDefinition".equals(name)) {
            this.businessDataDefinitions.add((SBusinessDataDefinition)value);
        } else if ("dataDefinition".equals(name)) {
            this.dataDefinitions.add((SDataDefinition)value);
        } else if ("textDataDefinition".equals(name)) {
            this.dataDefinitions.add((SDataDefinition)value);
        } else if ("xmlDataDefinition".equals(name)) {
            this.dataDefinitions.add((SDataDefinition)value);
        } else if ("documentDefinition".equals(name)) {
            this.documentDefinitions.add((SDocumentDefinition)value);
        } else if ("gateway".equals(name)) {
            this.gateways.add((SGatewayDefinitionImpl)value);
        } else if ("transition".equals(name)) {
            this.sTransitions.add((STransitionDefinition)value);
        } else if ("startEvent".equals(name)) {
            this.startEvents.add((SStartEventDefinitionImpl)value);
        } else if ("intermediateCatchEvent".equals(name)) {
            this.intermediateCatchEvents.add((SIntermediateCatchEventDefinitionImpl)value);
        } else if ("endEvent".equals(name)) {
            this.endEvents.add((SEndEventDefinitionImpl)value);
        } else if ("intermediateThrowEvent".equals(name)) {
            this.intermediateThrowEvents.add((SIntermediateThrowEventDefinitionImpl)value);
        }
    }

    @Override
    public Object getObject() {
        SFlowElementContainerDefinitionImpl container = new SFlowElementContainerDefinitionImpl();
        for (STransitionDefinition transition : this.sTransitions) {
            container.addTransition(transition);
        }
        for (SActivityDefinitionImpl activity : this.activities) {
            container.addActivity(activity);
            activity.setParentContainer(container);
        }
        for (SGatewayDefinitionImpl gateway : this.gateways) {
            container.addGateway(gateway);
            gateway.setParentContainer(container);
        }
        for (SConnectorDefinition connector : this.connectors) {
            container.addConnector(connector);
        }
        for (SBusinessDataDefinition businessDataDefinition : this.businessDataDefinitions) {
            container.addBusinessDataDefinition(businessDataDefinition);
        }
        for (SDataDefinition dataDefinition : this.dataDefinitions) {
            container.addDataDefinition(dataDefinition);
        }
        for (SDocumentDefinition documentDefinition : this.documentDefinitions) {
            container.addDocumentDefinition(documentDefinition);
        }
        for (SStartEventDefinitionImpl startEvent : this.startEvents) {
            container.addStartEvent(startEvent);
            startEvent.setParentContainer(container);
        }
        for (SIntermediateCatchEventDefinitionImpl intermediateCatchEvent : this.intermediateCatchEvents) {
            container.addIntemediateCatchEvent(intermediateCatchEvent);
            intermediateCatchEvent.setParentContainer(container);
        }
        for (SEndEventDefinitionImpl endEvent : this.endEvents) {
            container.addEndEvent(endEvent);
            endEvent.setParentContainer(container);
        }
        for (SIntermediateThrowEventDefinitionImpl intermediateThrowEvent : this.intermediateThrowEvents) {
            container.addIntermediateThrowEvent(intermediateThrowEvent);
            intermediateThrowEvent.setParentContainer(container);
        }
        Map<Long, SFlowNodeDefinitionImpl> allFlowNodes = this.getAllFlowNodes(container);
        this.addTransitionOnFlowNodes(allFlowNodes);
        return container;
    }

    private Map<Long, SFlowNodeDefinitionImpl> getAllFlowNodes(SFlowElementContainerDefinitionImpl container) {
        HashMap<Long, SFlowNodeDefinitionImpl> allFlowNodes = new HashMap<Long, SFlowNodeDefinitionImpl>(container.getFlowNodes().size());
        for (SFlowNodeDefinition flowNode : container.getFlowNodes()) {
            allFlowNodes.put(flowNode.getId(), (SFlowNodeDefinitionImpl)flowNode);
        }
        for (SActivityDefinition activity : container.getActivities()) {
            if (activity.getBoundaryEventDefinitions().isEmpty()) continue;
            for (SBoundaryEventDefinition boundary : activity.getBoundaryEventDefinitions()) {
                allFlowNodes.put(boundary.getId(), (SFlowNodeDefinitionImpl)((Object)boundary));
            }
        }
        return allFlowNodes;
    }

    private void addTransitionOnFlowNodes(Map<Long, SFlowNodeDefinitionImpl> allFlowNodes) {
        block0: for (STransitionDefinition sTransition : this.sTransitions) {
            long target;
            SFlowNodeDefinitionImpl targetNode;
            long source = sTransition.getSource();
            SFlowNodeDefinitionImpl sourceNode = allFlowNodes.get(source);
            if (sourceNode != null) {
                STransitionDefinition defaultTransition = sourceNode.getDefaultTransition();
                if (defaultTransition != null && ((STransitionDefinitionImpl)defaultTransition).getId().equals(((STransitionDefinitionImpl)sTransition).getId())) {
                    sourceNode.setDefaultTransition(sTransition);
                } else {
                    List<STransitionDefinition> outgoingTransitionsForSourceNode = sourceNode.getOutgoingTransitions();
                    for (STransitionDefinition sTransitionRef : outgoingTransitionsForSourceNode) {
                        if (!sTransitionRef.getId().equals(sTransition.getId())) continue;
                        int indexOfSTransitionRef = outgoingTransitionsForSourceNode.indexOf(sTransitionRef);
                        sourceNode.removeOutgoingTransition(sTransitionRef);
                        sourceNode.addOutgoingTransition(indexOfSTransitionRef, sTransition);
                        break;
                    }
                }
            }
            if ((targetNode = allFlowNodes.get(target = sTransition.getTarget())) == null) continue;
            List<STransitionDefinition> incomingTransitionsForTargetNode = targetNode.getIncomingTransitions();
            for (STransitionDefinition sTransitionRef : incomingTransitionsForTargetNode) {
                if (!sTransitionRef.getId().equals(sTransition.getId())) continue;
                int indexOfSTransitionRef = incomingTransitionsForTargetNode.indexOf(sTransitionRef);
                targetNode.removeIncomingTransition(sTransitionRef);
                targetNode.addIncomingTransition(indexOfSTransitionRef, sTransition);
                continue block0;
            }
        }
    }

    @Override
    public String getElementTag() {
        return "flowElements";
    }
}

