/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.execution.work;

import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.core.connector.ConnectorInstanceService;
import org.bonitasoft.engine.core.connector.ConnectorResult;
import org.bonitasoft.engine.core.connector.ConnectorService;
import org.bonitasoft.engine.core.expression.control.model.SExpressionContext;
import org.bonitasoft.engine.core.operation.model.SOperation;
import org.bonitasoft.engine.core.process.definition.ProcessDefinitionService;
import org.bonitasoft.engine.core.process.definition.model.SConnectorDefinition;
import org.bonitasoft.engine.core.process.definition.model.event.SEndEventDefinition;
import org.bonitasoft.engine.core.process.instance.model.SConnectorInstance;
import org.bonitasoft.engine.core.process.instance.model.SConnectorInstanceWithFailureInfo;
import org.bonitasoft.engine.core.process.instance.model.event.SThrowEventInstance;
import org.bonitasoft.engine.dependency.model.ScopeType;
import org.bonitasoft.engine.execution.work.TenantAwareBonitaWork;
import org.bonitasoft.engine.service.TenantServiceAccessor;
import org.bonitasoft.engine.tracking.TimeTracker;
import org.bonitasoft.engine.transaction.UserTransactionService;

public abstract class ExecuteConnectorWork
extends TenantAwareBonitaWork {
    private static final long serialVersionUID = 9031279948838300081L;
    protected final long processDefinitionId;
    protected final long connectorInstanceId;
    protected final String connectorDefinitionName;
    private final SExpressionContext inputParametersContext;

    public ExecuteConnectorWork(long processDefinitionId, long connectorInstanceId, String connectorDefinitionName, SExpressionContext inputParametersContext) {
        this.processDefinitionId = processDefinitionId;
        this.connectorInstanceId = connectorInstanceId;
        this.connectorDefinitionName = connectorDefinitionName;
        this.inputParametersContext = inputParametersContext;
    }

    protected abstract void errorEventOnFail(Map<String, Object> var1, SConnectorDefinition var2, Exception var3) throws SBonitaException;

    protected abstract SThrowEventInstance createThrowErrorEventInstance(Map<String, Object> var1, SEndEventDefinition var2) throws SBonitaException;

    protected abstract SConnectorDefinition getSConnectorDefinition(ProcessDefinitionService var1) throws SBonitaException;

    protected abstract void setContainerInFail(Map<String, Object> var1) throws SBonitaException;

    protected abstract void continueFlow(Map<String, Object> var1) throws SBonitaException;

    protected abstract void evaluateOutput(Map<String, Object> var1, ConnectorResult var2, SConnectorDefinition var3) throws SBonitaException;

    protected ClassLoader getClassLoader(Map<String, Object> context) throws SBonitaException {
        return this.getTenantAccessor(context).getClassLoaderService().getLocalClassLoader(ScopeType.PROCESS.name(), this.processDefinitionId);
    }

    protected void setConnectorAndContainerToFailed(Map<String, Object> context, Exception Exception2) throws SBonitaException {
        this.setConnectorOnlyToFailed(context, Exception2);
        this.setContainerInFail(context);
    }

    protected void setConnectorOnlyToFailed(Map<String, Object> context, Exception Exception2) throws SBonitaException {
        ConnectorInstanceService connectorInstanceService = this.getTenantAccessor(context).getConnectorInstanceService();
        SConnectorInstanceWithFailureInfo connectorInstanceWithFailure = connectorInstanceService.getConnectorInstanceWithFailureInfo(this.connectorInstanceId);
        connectorInstanceService.setState(connectorInstanceWithFailure, "FAILED");
        connectorInstanceService.setConnectorInstanceFailureException(connectorInstanceWithFailure, Exception2);
    }

    protected void evaluateOutput(Map<String, Object> context, ConnectorResult result, SConnectorDefinition sConnectorDefinition, Long id, String containerType) throws SBonitaException {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor(context);
        ConnectorInstanceService connectorInstanceService = tenantAccessor.getConnectorInstanceService();
        ConnectorService connectorService = tenantAccessor.getConnectorService();
        List<SOperation> outputs = sConnectorDefinition.getOutputs();
        SExpressionContext sExpressionContext = new SExpressionContext(id, containerType, this.processDefinitionId);
        connectorService.executeOutputOperation(outputs, sExpressionContext, result);
        connectorInstanceService.setState(connectorInstanceService.getConnectorInstance(this.connectorInstanceId), "DONE");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void work(Map<String, Object> context) throws Exception {
        long startTime = System.currentTimeMillis();
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor(context);
        ConnectorService connectorService = tenantAccessor.getConnectorService();
        ConnectorInstanceService connectorInstanceService = tenantAccessor.getConnectorInstanceService();
        UserTransactionService userTransactionService = tenantAccessor.getUserTransactionService();
        ProcessDefinitionService processDefinitionService = tenantAccessor.getProcessDefinitionService();
        TimeTracker timeTracker = tenantAccessor.getTimeTracker();
        ClassLoader processClassloader = this.getClassLoader(context);
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(processClassloader);
            EvaluateParameterAndGetConnectorInstance callable = new EvaluateParameterAndGetConnectorInstance(connectorService, processDefinitionService, connectorInstanceService);
            userTransactionService.executeInTransaction(callable);
            SConnectorDefinition sConnectorDefinition = callable.getsConnectorDefinition();
            SConnectorInstance connectorInstance = callable.getConnectorInstance();
            ConnectorResult result = connectorService.executeConnector(this.processDefinitionId, connectorInstance, processClassloader, callable.getInputParameters());
            userTransactionService.executeInTransaction(new EvaluateConnectorOutputsTxContent(result, sConnectorDefinition, context));
        }
        finally {
            if (timeTracker.isTrackable("EXECUTE_CONNECTOR_WORK")) {
                long endTime = System.currentTimeMillis();
                StringBuilder desc = new StringBuilder();
                desc.append("processDefinitionId: ");
                desc.append(this.processDefinitionId);
                desc.append(" - ");
                desc.append("connectorDefinitionName: ");
                desc.append(this.connectorDefinitionName);
                desc.append(" - ");
                desc.append("connectorInstanceId: ");
                desc.append(this.connectorInstanceId);
                timeTracker.track("EXECUTE_CONNECTOR_WORK", desc.toString(), endTime - startTime);
            }
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
    }

    @Override
    public void handleFailure(Exception e, Map<String, Object> context) throws Exception {
        ProcessDefinitionService processDefinitionService;
        UserTransactionService userTransactionService = this.getTenantAccessor(context).getUserTransactionService();
        if (this.handleError(context, userTransactionService, processDefinitionService = this.getTenantAccessor(context).getProcessDefinitionService(), e)) {
            userTransactionService.executeInTransaction(new ContinueFlowTxContent(context));
        }
    }

    private boolean handleError(Map<String, Object> context, UserTransactionService userTransactionService, ProcessDefinitionService processDefinitionService, Exception e) throws Exception {
        HandleConnectorOnFailEventTxContent handleError = new HandleConnectorOnFailEventTxContent(e, processDefinitionService, context);
        return userTransactionService.executeInTransaction(handleError);
    }

    private final class EvaluateConnectorOutputsTxContent
    implements Callable<Void> {
        private final ConnectorResult result;
        private final SConnectorDefinition sConnectorDefinition;
        private final Map<String, Object> context;

        private EvaluateConnectorOutputsTxContent(ConnectorResult result, SConnectorDefinition sConnectorDefinition, Map<String, Object> context) {
            this.result = result;
            this.sConnectorDefinition = sConnectorDefinition;
            this.context = context;
        }

        @Override
        public Void call() throws Exception {
            ExecuteConnectorWork.this.evaluateOutput(this.context, this.result, this.sConnectorDefinition);
            ExecuteConnectorWork.this.continueFlow(this.context);
            return null;
        }
    }

    private final class ContinueFlowTxContent
    implements Callable<Void> {
        private final Map<String, Object> context;

        public ContinueFlowTxContent(Map<String, Object> context) {
            this.context = context;
        }

        @Override
        public Void call() throws Exception {
            ExecuteConnectorWork.this.continueFlow(this.context);
            return null;
        }
    }

    private final class HandleConnectorOnFailEventTxContent
    implements Callable<Boolean> {
        private final Exception e;
        private final ProcessDefinitionService processDefinitionService;
        private final Map<String, Object> context;

        private HandleConnectorOnFailEventTxContent(Exception e, ProcessDefinitionService processDefinitionService, Map<String, Object> context) {
            this.e = e;
            this.processDefinitionService = processDefinitionService;
            this.context = context;
        }

        @Override
        public Boolean call() throws Exception {
            SConnectorDefinition sConnectorDefinition = ExecuteConnectorWork.this.getSConnectorDefinition(this.processDefinitionService);
            switch (sConnectorDefinition.getFailAction()) {
                case ERROR_EVENT: {
                    ExecuteConnectorWork.this.errorEventOnFail(this.context, sConnectorDefinition, this.e);
                    return false;
                }
                case FAIL: {
                    ExecuteConnectorWork.this.setConnectorAndContainerToFailed(this.context, this.e);
                    return false;
                }
                case IGNORE: {
                    ExecuteConnectorWork.this.setConnectorOnlyToFailed(this.context, this.e);
                    return true;
                }
            }
            throw new Exception("No action defined for " + sConnectorDefinition.getFailAction());
        }
    }

    private final class EvaluateParameterAndGetConnectorInstance
    implements Callable<Void> {
        private final ConnectorService connectorService;
        private final ConnectorInstanceService connectorInstanceService;
        private Map<String, Object> inputParameters;
        private SConnectorInstance connectorInstance;
        private final ProcessDefinitionService processDefinitionService;
        private SConnectorDefinition sConnectorDefinition;

        private EvaluateParameterAndGetConnectorInstance(ConnectorService connectorService, ProcessDefinitionService processDefinitionService, ConnectorInstanceService connectorInstanceService) {
            this.connectorService = connectorService;
            this.processDefinitionService = processDefinitionService;
            this.connectorInstanceService = connectorInstanceService;
        }

        public Map<String, Object> getInputParameters() {
            return this.inputParameters;
        }

        public SConnectorInstance getConnectorInstance() {
            return this.connectorInstance;
        }

        public SConnectorDefinition getsConnectorDefinition() {
            return this.sConnectorDefinition;
        }

        @Override
        public Void call() throws Exception {
            this.sConnectorDefinition = ExecuteConnectorWork.this.getSConnectorDefinition(this.processDefinitionService);
            this.inputParameters = this.connectorService.evaluateInputParameters(this.sConnectorDefinition.getConnectorId(), this.sConnectorDefinition.getInputs(), ExecuteConnectorWork.this.inputParametersContext, null);
            this.connectorInstance = this.connectorInstanceService.getConnectorInstance(ExecuteConnectorWork.this.connectorInstanceId);
            return null;
        }
    }
}

