/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.identity.xml;

import java.util.List;
import java.util.Map;
import org.bonitasoft.engine.api.impl.SCustomUserInfoValueAPI;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.identity.ExportedCustomUserInfoValue;
import org.bonitasoft.engine.identity.model.SCustomUserInfoDefinition;
import org.bonitasoft.engine.identity.xml.SImportOrganizationException;

public class CustomUserInfoValueImporter {
    private SCustomUserInfoValueAPI userInfoAPI;
    private Map<String, SCustomUserInfoDefinition> customUserInfoDefinitions;

    public CustomUserInfoValueImporter(SCustomUserInfoValueAPI userInfoAPI, Map<String, SCustomUserInfoDefinition> customUserInfoDefinitions) {
        this.userInfoAPI = userInfoAPI;
        this.customUserInfoDefinitions = customUserInfoDefinitions;
    }

    public void imporCustomUserInfoValues(List<ExportedCustomUserInfoValue> customUserInfoValues, long persistedUserId) throws SBonitaException {
        for (ExportedCustomUserInfoValue infoValue : customUserInfoValues) {
            SCustomUserInfoDefinition infoDefinition = this.customUserInfoDefinitions.get(infoValue.getName());
            if (infoDefinition == null) {
                String message = "The XML file is inconsistent. A custom user info value is refenced with name '" + infoValue.getName() + "', but no custom user info definition is defined with this name.";
                throw new SImportOrganizationException(message);
            }
            this.userInfoAPI.set(infoDefinition.getId(), persistedUserId, infoValue.getValue());
        }
    }
}

