/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.platform.session.model.impl;

import java.util.Date;
import org.bonitasoft.engine.platform.session.model.SPlatformSession;

public class SPlatformSessionImpl
implements SPlatformSession {
    private static final long serialVersionUID = 1L;
    private final long id;
    private Date creationDate;
    private long duration;
    private Date lastRenewDate;
    private final String userName;
    private long userId;

    public SPlatformSessionImpl(long id, String username) {
        this.id = id;
        this.userName = username;
    }

    public SPlatformSessionImpl(SPlatformSession session) {
        this.id = session.getId();
        this.creationDate = session.getCreationDate();
        this.duration = session.getDuration();
        this.lastRenewDate = session.getLastRenewDate();
        this.userName = session.getUserName();
        this.userId = session.getUserId();
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public Date getCreationDate() {
        return this.creationDate;
    }

    @Override
    public Date getLastRenewDate() {
        return this.lastRenewDate;
    }

    @Override
    public long getDuration() {
        return this.duration;
    }

    @Override
    public Date getExpirationDate() {
        return new Date(this.lastRenewDate.getTime() + this.duration);
    }

    @Override
    public String getUserName() {
        return this.userName;
    }

    @Override
    public long getUserId() {
        return this.userId;
    }

    public void setLastRenewDate(Date lastRenewDate) {
        this.lastRenewDate = lastRenewDate;
    }

    public void setDuration(long duration) {
        this.duration = duration;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.creationDate == null ? 0 : this.creationDate.hashCode());
        result = 31 * result + (int)(this.duration ^ this.duration >>> 32);
        result = 31 * result + (int)(this.id ^ this.id >>> 32);
        result = 31 * result + (this.lastRenewDate == null ? 0 : this.lastRenewDate.hashCode());
        result = 31 * result + (int)(this.userId ^ this.userId >>> 32);
        result = 31 * result + (this.userName == null ? 0 : this.userName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SPlatformSessionImpl other = (SPlatformSessionImpl)obj;
        if (this.creationDate == null ? other.creationDate != null : !this.creationDate.equals(other.creationDate)) {
            return false;
        }
        if (this.duration != other.duration) {
            return false;
        }
        if (this.id != other.id) {
            return false;
        }
        if (this.lastRenewDate == null ? other.lastRenewDate != null : !this.lastRenewDate.equals(other.lastRenewDate)) {
            return false;
        }
        if (this.userId != other.userId) {
            return false;
        }
        return !(this.userName == null ? other.userName != null : !this.userName.equals(other.userName));
    }
}

