/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.sessionaccessor;

import org.bonitasoft.engine.sessionaccessor.STenantIdNotSetException;
import org.bonitasoft.engine.sessionaccessor.SessionAccessor;
import org.bonitasoft.engine.sessionaccessor.SessionIdNotSetException;

public class ThreadLocalSessionAccessor
implements SessionAccessor {
    private final ThreadLocal<Long> sessionData = new ThreadLocal();
    private final ThreadLocal<Long> tenantData = new ThreadLocal();

    @Override
    public long getSessionId() throws SessionIdNotSetException {
        Long sessionId = this.sessionData.get();
        if (sessionId == null) {
            throw new SessionIdNotSetException("No session set.");
        }
        return sessionId;
    }

    @Override
    public void setSessionInfo(long sessionId, long tenantId) {
        this.sessionData.set(sessionId);
        this.tenantData.set(tenantId);
    }

    @Override
    public void setTenantId(long tenantId) {
        this.tenantData.set(tenantId);
    }

    @Override
    public void deleteSessionId() {
        this.sessionData.remove();
    }

    @Override
    public void deleteTenantId() {
        this.tenantData.remove();
    }

    @Override
    public long getTenantId() throws STenantIdNotSetException {
        Long tenantId = this.tenantData.get();
        if (tenantId == null) {
            throw new STenantIdNotSetException("No tenantId set.");
        }
        return tenantId;
    }
}

